/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.block;

import jackyy.dimensionaledibles.DimensionalEdibles;
import jackyy.dimensionaledibles.block.BlockCakeBase;
import jackyy.dimensionaledibles.block.tile.TileDimensionCake;
import jackyy.dimensionaledibles.registry.ModConfig;
import jackyy.dimensionaledibles.util.TeleporterHandler;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class BlockCustomCake
extends BlockCakeBase
implements ITileEntityProvider {
    private int customX = 0;
    private int customY = 0;
    private int customZ = 0;

    public BlockCustomCake() {
        this.setRegistryName("dimensionaledibles:custom_cake");
        this.func_149663_c("dimensionaledibles.custom_cake");
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        String[] parts;
        int meta = this.func_176201_c(world.func_180495_p(pos)) - 1;
        ItemStack stack = player.func_184586_b(hand);
        int dimension = 0;
        TileEntity ent = world.func_175625_s(pos);
        if (ent != null && ent instanceof TileDimensionCake) {
            dimension = ((TileDimensionCake)ent).getDimensionID();
        }
        String fuel = "minecraft:air";
        for (String s : ModConfig.tweaks.customEdible.customCake.fuel) {
            try {
                parts = s.split(",");
                if (parts.length < 2) {
                    DimensionalEdibles.logger.log(Level.ERROR, s + " is not a valid input line! Format needs to be: <dimID>, <cakeFuel>");
                    continue;
                }
                if (Integer.parseInt(parts[0].trim()) != dimension) continue;
                fuel = parts[1].trim();
            }
            catch (NumberFormatException e) {
                DimensionalEdibles.logger.log(Level.ERROR, s + " is not a valid line input! The dimension ID needs to be a number!");
            }
        }
        for (String s : ModConfig.tweaks.customEdible.customCoords) {
            try {
                parts = s.split(",");
                if (parts.length < 4) {
                    DimensionalEdibles.logger.log(Level.ERROR, s + " is not a valid input line! Format needs to be: <dimID>, <x>, <y>, <z>");
                    continue;
                }
                if (Integer.parseInt(parts[0].trim()) != dimension) continue;
                this.customX = Integer.parseInt(parts[1].trim());
                this.customY = Integer.parseInt(parts[2].trim());
                this.customZ = Integer.parseInt(parts[3].trim());
            }
            catch (NumberFormatException e) {
                DimensionalEdibles.logger.log(Level.ERROR, s + " is not a valid line input! The dimension ID needs to be a number!");
            }
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Item.field_150901_e.func_82594_a((Object)new ResourceLocation(fuel))) {
            if (meta >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(meta)), 2);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        } else if (world.field_73011_w.getDimension() != dimension && !world.field_72995_K) {
            if (player.field_71075_bZ.field_75098_d || !ModConfig.tweaks.customEdible.customCake.consumeFuel) {
                this.teleportPlayer(world, player, dimension);
            } else {
                this.consumeCake(world, pos, player, dimension);
            }
            return true;
        }
        return false;
    }

    private void teleportPlayer(World world, EntityPlayer player, int dimension) {
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        BlockPos coords = this.customX != 0 && this.customY != 0 && this.customZ != 0 ? new BlockPos(this.customX, this.customY, this.customZ) : TeleporterHandler.getDimPos(playerMP, dimension, player.func_180425_c());
        TeleporterHandler.updateDimPos((EntityPlayer)playerMP, world.field_73011_w.getDimension(), player.func_180425_c());
        TeleporterHandler.teleport(playerMP, dimension, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), playerMP.field_71133_b.func_184103_al());
    }

    private void consumeCake(World world, BlockPos pos, EntityPlayer player, int dimension) {
        int l;
        if (player.func_71043_e(true) && (l = ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)BITES)).intValue()) < 6) {
            player.func_71024_bL().func_75122_a(2, 0.1f);
            world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(l + 1)), 3);
            this.teleportPlayer(world, player, dimension);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return ModConfig.tweaks.customEdible.customCake.preFueled ? this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(0)) : this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(6));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (ModConfig.general.customCake) {
            for (String s : ModConfig.tweaks.customEdible.dimensions) {
                try {
                    String[] parts = s.split(",");
                    if (parts.length < 2) {
                        DimensionalEdibles.logger.log(Level.ERROR, s + " is not a valid input line! Format needs to be: <dimID>, <cakeName>");
                        continue;
                    }
                    int dimension = Integer.parseInt(parts[0].trim());
                    if (DimensionManager.isDimensionRegistered((int)dimension)) {
                        ItemStack stack = new ItemStack((Block)this);
                        NBTTagCompound nbt = stack.func_77978_p();
                        if (nbt == null) {
                            nbt = new NBTTagCompound();
                            stack.func_77982_d(nbt);
                        }
                        nbt.func_74768_a("dimID", dimension);
                        nbt.func_74778_a("cakeName", parts[1].trim());
                        list.add((Object)stack);
                        continue;
                    }
                    DimensionalEdibles.logger.log(Level.ERROR, parts[0] + " is not a valid dimension ID! (Needs to be a number)");
                }
                catch (NumberFormatException e) {
                    DimensionalEdibles.logger.log(Level.ERROR, s + " is not a valid line input! The dimension ID needs to be a number!");
                }
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileDimensionCake();
    }
}

