/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.registry;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="dimensionaledibles", name="DimensionalEdibles", category="dimensionaledibles")
public class ModConfig {
    public static General general = new General();
    public static Tweaks tweaks = new Tweaks();

    @Mod.EventBusSubscriber
    public static class ConfigHolder {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("dimensionaledibles")) {
                ConfigManager.sync((String)"dimensionaledibles", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Tweaks {
        public EndCake endCake = new EndCake();
        public EnderApple enderApple = new EnderApple();
        public NetherCake netherCake = new NetherCake();
        public NetherApple netherApple = new NetherApple();
        public OverworldCake overworldCake = new OverworldCake();
        public OverworldApple overworldApple = new OverworldApple();
        public CustomEdible customEdible = new CustomEdible();
        @Config.Comment(value={"Set to true to disable the activation of vanilla End Portal."})
        public boolean disableVanillaEndPortal = false;

        public static class CustomEdible {
            @Config.Comment(value={"Set a list of dimensions to add cakes / apples for.", "Format: <Dimension ID>, <Cake / Apple Name>", "Example: 0, Overworld", "Note: \"Cake\" is automatically appended onto the end of the name for cakes."})
            public String[] dimensions = new String[0];
            @Config.Comment(value={"Set a list of custom coordinates used by Custom Cakes / Apples, this is optional.", "Format: <Dimension ID>, <X>, <Y>, <Z>", "Example: 0, 420, 123, -420"})
            public String[] customCoords = new String[0];
            public CustomCake customCake = new CustomCake();

            public static class CustomCake {
                @Config.Comment(value={"Set to true to make all Custom Cakes pre-fueled upon placed."})
                public boolean preFueled = false;
                @Config.Comment(value={"Set to true to make all Custom Cakes consume fuel."})
                public boolean consumeFuel = true;
                @Config.Comment(value={"Set the fuel used by Custom Cakes.", "Format: <Dimension ID>, <Fuel Registry Name>", "Example: 0, minecraft:apple"})
                public String[] fuel = new String[0];
            }
        }

        public static class OverworldApple {
            @Config.Comment(value={"Set to true to make the Overworld Apple teleport players to world spawn.", "Otherwise, it will use the cached position."})
            public boolean useWorldSpawn = true;
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            public CustomCoords customCoords = new CustomCoords();

            public static class CustomCoords {
                public double x = 0.0;
                public double y = 64.0;
                public double z = 0.0;
            }
        }

        public static class OverworldCake {
            @Config.Comment(value={"Set the fuel used by Overworld Cake (Don't change this unless you know what you're doing)."})
            public String fuel = "minecraft:sapling";
            @Config.Comment(value={"Set to true to make the Overworld Cake pre-fueled upon placed."})
            public boolean preFueled = false;
            @Config.Comment(value={"Set to true to make the Overworld Cake consume fuel."})
            public boolean consumeFuel = true;
            @Config.Comment(value={"Set to true to make the Overworld Apple teleport players to world spawn.", "Otherwise, it will use the cached position."})
            public boolean useWorldSpawn = true;
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            public CustomCoords customCoords = new CustomCoords();

            public static class CustomCoords {
                public double x = 0.0;
                public double y = 64.0;
                public double z = 0.0;
            }
        }

        public static class NetherApple {
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            public CustomCoords customCoords = new CustomCoords();

            public static class CustomCoords {
                public double x = 0.0;
                public double y = 64.0;
                public double z = 0.0;
            }
        }

        public static class NetherCake {
            @Config.Comment(value={"Set the fuel used by Nether Cake (Don't change this unless you know what you're doing)."})
            public String fuel = "minecraft:obsidian";
            @Config.Comment(value={"Set to true to make the Nether Cake pre-fueled upon placed."})
            public boolean preFueled = false;
            @Config.Comment(value={"Set to true to make the Nether Cake consume fuel."})
            public boolean consumeFuel = true;
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            public CustomCoords customCoords = new CustomCoords();

            public static class CustomCoords {
                public double x = 0.0;
                public double y = 64.0;
                public double z = 0.0;
            }
        }

        public static class EnderApple {
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            public CustomCoords customCoords = new CustomCoords();

            public static class CustomCoords {
                public double x = 0.0;
                public double y = 64.0;
                public double z = 0.0;
            }
        }

        public static class EndCake {
            @Config.Comment(value={"Set the fuel used by End Cake (Don't change this unless you know what you're doing)."})
            public String fuel = "minecraft:ender_eye";
            @Config.Comment(value={"Set to true to make the End Cake pre-fueled upon placed."})
            public boolean preFueled = false;
            @Config.Comment(value={"Set to true to make the End Cake consume fuel."})
            public boolean consumeFuel = true;
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            public CustomCoords customCoords = new CustomCoords();

            public static class CustomCoords {
                public double x = 0.0;
                public double y = 64.0;
                public double z = 0.0;
            }
        }
    }

    public static class General {
        @Config.Comment(value={"Set to true to enable End Cake."})
        public boolean endCake = true;
        @Config.Comment(value={"Set to true to enable Nether Cake."})
        public boolean netherCake = true;
        @Config.Comment(value={"Set to true to enable Overworld Cake."})
        public boolean overworldCake = true;
        @Config.Comment(value={"Set to true to enable custom Cakes."})
        public boolean customCake = true;
        @Config.Comment(value={"Set to true to enable Ender Cake."})
        public boolean enderApple = true;
        @Config.Comment(value={"Set to true to enable Nether Cake."})
        public boolean netherApple = true;
        @Config.Comment(value={"Set to true to enable Overworld Cake."})
        public boolean overworldApple = true;
        @Config.Comment(value={"Set to true to enable Custom Cake."})
        public boolean customApple = true;
    }
}

