/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.config;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.creativemd.creativecore.common.config.gui.GuiConfigSubControl;
import com.creativemd.creativecore.common.config.holder.ConfigHolderDynamic;
import com.creativemd.creativecore.common.config.holder.ConfigHolderObject;
import com.creativemd.creativecore.common.config.holder.ConfigKey;
import com.creativemd.creativecore.common.config.holder.ICreativeConfigHolder;
import com.creativemd.creativecore.common.config.sync.ConfigSynchronization;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiListBoxBase;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.utils.mc.ChatFormatting;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ConfigTypeConveration<T> {
    private static HashMap<Class, ConfigTypeConveration> types = new HashMap();
    private static PairList<Predicate<Class>, ConfigTypeConveration> specialTypes = new PairList();

    public static <T, U extends T> void registerType(Class<U> clazz, ConfigTypeConveration<T> type) {
        types.put(clazz, type);
    }

    public static void registerSpecialType(Predicate<Class> predicate, ConfigTypeConveration type) {
        specialTypes.add(predicate, type);
    }

    public static boolean has(Class typeClass) {
        if (types.containsKey(typeClass)) {
            return true;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return true;
        }
        return false;
    }

    public static ConfigTypeConveration get(Class typeClass) {
        ConfigTypeConveration converation = types.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).value;
        }
        throw new RuntimeException("Could not find converation for " + typeClass.getName());
    }

    public static Object read(Class typeClass, Object defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
        return ConfigTypeConveration.get(typeClass).readElement(defaultValue, loadDefault, ignoreRestart, element, side, key);
    }

    public static JsonElement write(Class typeClass, Object value, Object defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
        return ConfigTypeConveration.get(typeClass).writeElement(value, defaultValue, saveDefault, ignoreRestart, side, key);
    }

    public abstract T readElement(T var1, boolean var2, boolean var3, JsonElement var4, Side var5, @Nullable ConfigKey.ConfigKeyField var6);

    public abstract JsonElement writeElement(T var1, T var2, boolean var3, boolean var4, Side var5, @Nullable ConfigKey.ConfigKeyField var6);

    @SideOnly(value=Side.CLIENT)
    public abstract void createControls(GuiParent var1, @Nullable ConfigKey.ConfigKeyField var2, Class var3, int var4);

    @SideOnly(value=Side.CLIENT)
    public abstract void loadValue(T var1, GuiParent var2, @Nullable ConfigKey.ConfigKeyField var3);

    @SideOnly(value=Side.CLIENT)
    protected abstract T saveValue(GuiParent var1, Class var2, @Nullable ConfigKey.ConfigKeyField var3);

    public abstract T set(ConfigKey.ConfigKeyField var1, T var2);

    @SideOnly(value=Side.CLIENT)
    public T save(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
        T value = this.saveValue(parent, clazz, key);
        if (value != null && key != null) {
            return this.set(key, value);
        }
        return value;
    }

    public boolean areEqual(T one, T two) {
        return one.equals(two);
    }

    public static Object parseObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object) {
        if (ConfigTypeConveration.has(object.getClass())) {
            return object;
        }
        return new ConfigHolderObject(parent, synchronization, key, object);
    }

    static {
        SimpleConfigTypeConveration<Boolean> booleanType = new SimpleConfigTypeConveration<Boolean>(){

            @Override
            public Boolean readElement(Boolean defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return element.getAsBoolean();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Boolean value, Boolean defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
                parent.addControl(new GuiStateButton("data", 0, 0, 0, recommendedWidth, (Object)((Object)ChatFormatting.RED) + "false", (Object)((Object)ChatFormatting.GREEN) + "true"));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadValue(Boolean value, GuiParent parent) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                button.setState(value != false ? 1 : 0);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected Boolean saveValue(GuiParent parent, Class clazz) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                return button.getState() == 1;
            }

            @Override
            public Boolean set(ConfigKey.ConfigKeyField key, Boolean value) {
                return value;
            }
        };
        ConfigTypeConveration.registerType(Boolean.TYPE, booleanType);
        ConfigTypeConveration.registerType(Boolean.class, booleanType);
        SimpleConfigTypeConveration<Number> numberType = new SimpleConfigTypeConveration<Number>(){

            @Override
            public Number readElement(Number defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    Class<?> clazz = defaultValue.getClass();
                    if (clazz == Float.class || clazz == Float.TYPE) {
                        return Float.valueOf(element.getAsFloat());
                    }
                    if (clazz == Double.class || clazz == Double.TYPE) {
                        return element.getAsDouble();
                    }
                    if (clazz == Byte.class || clazz == Byte.TYPE) {
                        return element.getAsByte();
                    }
                    if (clazz == Short.class || clazz == Short.TYPE) {
                        return element.getAsShort();
                    }
                    if (clazz == Integer.class || clazz == Integer.TYPE) {
                        return element.getAsInt();
                    }
                    if (clazz == Long.class || clazz == Long.TYPE) {
                        return element.getAsLong();
                    }
                    return element.getAsNumber();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Number value, Number defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            public boolean isDecimal(Class clazz) {
                return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
                boolean decimal = this.isDecimal(clazz);
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field.getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null && decRange.slider()) {
                            parent.addControl(new GuiAnalogeSlider("data", 0, 0, recommendedWidth, 14, decRange.min(), decRange.min(), decRange.max()));
                            return;
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field.getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null && intRange.slider()) {
                            parent.addControl(new GuiSteppedSlider("data", 0, 0, recommendedWidth, 14, intRange.min(), intRange.min(), intRange.max()));
                            return;
                        }
                    }
                }
                GuiTextfield textfield = new GuiTextfield("data", "", 0, 0, recommendedWidth, 14);
                if (decimal) {
                    textfield.setFloatOnly();
                } else {
                    textfield.setNumbersIncludingNegativeOnly();
                }
                parent.addControl(textfield);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadValue(Number value, GuiParent parent) {
                GuiControl control = (GuiControl)parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    button.setValue(value.intValue());
                } else if (control instanceof GuiAnalogeSlider) {
                    GuiAnalogeSlider button = (GuiAnalogeSlider)control;
                    button.setValue(value.doubleValue());
                } else {
                    GuiTextfield button = (GuiTextfield)control;
                    button.text = value.toString();
                    button.setCursorPositionZero();
                }
            }

            public Number parseDecimal(Class clazz, double decimal) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    return Float.valueOf((float)decimal);
                }
                return decimal;
            }

            public Number parseInt(Class clazz, int number) {
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    return (byte)number;
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    return (short)number;
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return (long)number;
                }
                return number;
            }

            public Number parseNumber(Class clazz, String text) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    try {
                        return Float.valueOf(Float.parseFloat(text));
                    }
                    catch (NumberFormatException e) {
                        return Float.valueOf(0.0f);
                    }
                }
                if (clazz == Double.class || clazz == Double.TYPE) {
                    try {
                        return Double.parseDouble(text);
                    }
                    catch (NumberFormatException e) {
                        return 0.0;
                    }
                }
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    try {
                        return Byte.parseByte(text);
                    }
                    catch (NumberFormatException e) {
                        return (byte)0;
                    }
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    try {
                        return Short.parseShort(text);
                    }
                    catch (NumberFormatException e) {
                        return (short)0;
                    }
                }
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    try {
                        return Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        return 0;
                    }
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    try {
                        return Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        return 0L;
                    }
                }
                return 0;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected Number saveValue(GuiParent parent, Class clazz) {
                String text;
                boolean decimal = this.isDecimal(clazz);
                GuiControl control = (GuiControl)parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    text = "" + (int)button.value;
                } else if (control instanceof GuiAnalogeSlider) {
                    GuiAnalogeSlider button = (GuiAnalogeSlider)control;
                    text = "" + button.value;
                } else {
                    GuiTextfield button = (GuiTextfield)control;
                    text = button.text;
                }
                return this.parseNumber(clazz, text);
            }

            @Override
            public Number set(ConfigKey.ConfigKeyField key, Number value) {
                Class clazz = key.getType();
                boolean decimal = this.isDecimal(clazz);
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field.getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null) {
                            return this.parseDecimal(clazz, MathHelper.func_151237_a((double)value.doubleValue(), (double)decRange.min(), (double)decRange.max()));
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field.getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null) {
                            return this.parseInt(clazz, MathHelper.func_76125_a((int)value.intValue(), (int)intRange.min(), (int)intRange.max()));
                        }
                    }
                }
                return value;
            }
        };
        ConfigTypeConveration.registerType(Byte.TYPE, numberType);
        ConfigTypeConveration.registerType(Byte.class, numberType);
        ConfigTypeConveration.registerType(Short.TYPE, numberType);
        ConfigTypeConveration.registerType(Short.class, numberType);
        ConfigTypeConveration.registerType(Integer.TYPE, numberType);
        ConfigTypeConveration.registerType(Integer.class, numberType);
        ConfigTypeConveration.registerType(Long.TYPE, numberType);
        ConfigTypeConveration.registerType(Long.class, numberType);
        ConfigTypeConveration.registerType(Float.TYPE, numberType);
        ConfigTypeConveration.registerType(Float.class, numberType);
        ConfigTypeConveration.registerType(Double.TYPE, numberType);
        ConfigTypeConveration.registerType(Double.class, numberType);
        ConfigTypeConveration.registerType(String.class, new SimpleConfigTypeConveration<String>(){

            @Override
            public String readElement(String defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return element.getAsString();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(String value, String defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
                parent.addControl(new GuiTextfield("data", "", 0, 0, recommendedWidth, 14));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadValue(String value, GuiParent parent) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                button.text = value;
                button.setCursorPositionZero();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected String saveValue(GuiParent parent, Class clazz) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                return button.text;
            }

            @Override
            public String set(ConfigKey.ConfigKeyField key, String value) {
                return value;
            }
        });
        ConfigTypeConveration.registerType(ConfigHolderObject.class, new ConfigTypeConveration<ConfigHolderObject>(){

            @Override
            public ConfigHolderObject readElement(ConfigHolderObject defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    defaultValue.load(loadDefault, ignoreRestart, (JsonObject)element, side);
                } else {
                    defaultValue.restoreDefault(side, ignoreRestart);
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ConfigHolderObject value, ConfigHolderObject defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                return value.save(saveDefault, ignoreRestart, side);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadValue(ConfigHolderObject value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected ConfigHolderObject saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                return null;
            }

            @Override
            public ConfigHolderObject set(ConfigKey.ConfigKeyField key, ConfigHolderObject value) {
                return null;
            }
        });
        ConfigTypeConveration.registerType(ConfigHolderDynamic.class, new ConfigTypeConveration<ConfigHolderDynamic>(){

            @Override
            public ConfigHolderDynamic readElement(ConfigHolderDynamic defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    defaultValue.load(loadDefault, ignoreRestart, (JsonObject)element, side);
                } else {
                    defaultValue.restoreDefault(side, ignoreRestart);
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ConfigHolderDynamic value, ConfigHolderDynamic defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                return value.save(saveDefault, ignoreRestart, side);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadValue(ConfigHolderDynamic value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected ConfigHolderDynamic saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                return null;
            }

            @Override
            public ConfigHolderDynamic set(ConfigKey.ConfigKeyField key, ConfigHolderDynamic value) {
                return null;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> {
            if (x.isArray()) {
                if (ConfigTypeConveration.has(x.getComponentType())) {
                    return true;
                }
                throw new RuntimeException("Array with holders are not permitted");
            }
            return false;
        }, new ConfigTypeConveration(){

            public Object readElement(Object defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonArray()) {
                    JsonArray array = (JsonArray)element;
                    int size = Math.min(array.size(), Array.getLength(defaultValue));
                    Object object = Array.newInstance(defaultValue.getClass().getComponentType(), size);
                    for (int i = 0; i < size; ++i) {
                        Array.set(object, i, 6.read(defaultValue.getClass().getComponentType(), Array.get(defaultValue, i), loadDefault, ignoreRestart, array.get(i), side, null));
                    }
                    return object;
                }
                return defaultValue;
            }

            public JsonElement writeElement(Object value, Object defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                int length = Array.getLength(value);
                JsonArray array = new JsonArray();
                for (int i = 0; i < length; ++i) {
                    array.add(6.write(value.getClass().getComponentType(), Array.get(value, i), Array.get(defaultValue, i), saveDefault, ignoreRestart, side, null));
                }
                return array;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
                parent.height = 160;
                GuiListBoxBase listBox = new GuiListBoxBase("data", 0, 0, parent.width - 10, 150, false, new ArrayList());
                parent.addControl(listBox);
            }

            @SideOnly(value=Side.CLIENT)
            public void loadValue(Object value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
                GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
                if (!box.isEmpty()) {
                    box.clear();
                }
                Class<?> clazz = value.getClass().getComponentType();
                ConfigTypeConveration converation = 6.get(clazz);
                int length = Array.getLength(value);
                ArrayList<GuiConfigSubControl> controls = new ArrayList<GuiConfigSubControl>(length);
                for (int i = 0; i < length; ++i) {
                    Object entry = Array.get(value, i);
                    GuiConfigSubControl control = new GuiConfigSubControl("" + i, 2, 0, parent.width, 14);
                    converation.createControls(control, null, clazz, Math.min(100, control.width));
                    converation.loadValue(entry, control, null);
                    controls.add(control);
                }
                box.addAll(controls);
            }

            @SideOnly(value=Side.CLIENT)
            protected Object saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                Class<?> subClass = clazz.getComponentType();
                ConfigTypeConveration converation = 6.get(subClass);
                GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
                Object value = Array.newInstance(subClass, box.size());
                for (int i = 0; i < box.size(); ++i) {
                    Array.set(value, i, converation.save((GuiParent)box.get(i), subClass, null));
                }
                return value;
            }

            public Object set(ConfigKey.ConfigKeyField key, Object value) {
                return value;
            }

            public boolean areEqual(Object one, Object two) {
                int lengthTwo;
                int lengthOne = Array.getLength(one);
                if (lengthOne != (lengthTwo = Array.getLength(two))) {
                    return false;
                }
                for (int i = 0; i < lengthOne; ++i) {
                    Object entryOne = Array.get(one, i);
                    Object entryTwo = Array.get(two, i);
                    if (entryOne.getClass().isArray()) {
                        if (!entryTwo.getClass().isArray()) {
                            return false;
                        }
                        if (!this.areEqual(entryOne, entryTwo)) {
                            return false;
                        }
                    }
                    if (entryOne.equals(entryTwo)) continue;
                    return false;
                }
                return true;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> x.isEnum(), new SimpleConfigTypeConveration<Enum>(){

            @Override
            public Enum readElement(Enum defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return Enum.valueOf(defaultValue.getDeclaringClass(), element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Enum value, Enum defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.name());
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
                T[] possibleValues = clazz.getEnumConstants();
                ArrayList<String> lines = new ArrayList<String>(possibleValues.length);
                for (int i = 0; i < possibleValues.length; ++i) {
                    lines.add(((Enum)possibleValues[i]).name());
                }
                parent.addControl(new GuiComboBox("data", 0, 0, recommendedWidth, lines));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadValue(Enum value, GuiParent parent) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                box.select(value.ordinal());
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected Enum saveValue(GuiParent parent, Class clazz) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                return (Enum)clazz.getEnumConstants()[box.index];
            }

            @Override
            public Enum set(ConfigKey.ConfigKeyField key, Enum value) {
                return value;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> x == List.class || x == ArrayList.class, new ConfigTypeConveration<List>(){

            @Override
            public List readElement(List defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonArray()) {
                    JsonArray array = (JsonArray)element;
                    Class clazz = this.getListType(key);
                    ArrayList<Object> list = new ArrayList<Object>(array.size());
                    for (int i = 0; i < array.size(); ++i) {
                        list.add(8.read(clazz, null, loadDefault, ignoreRestart, array.get(i), side, null));
                    }
                    return list;
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(List value, List defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                JsonArray array = new JsonArray();
                Class clazz = this.getListType(key);
                for (int i = 0; i < value.size(); ++i) {
                    array.add(8.write(clazz, value.get(i), null, saveDefault, ignoreRestart, side, null));
                }
                return array;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
                parent.height = 160;
                final GuiListBoxBase listBox = new GuiListBoxBase("data", 0, 0, parent.width - 10, 130, true, new ArrayList());
                parent.addControl(listBox);
                final Class subClass = this.getListType(key);
                final ConfigTypeConveration converation = 8.get(subClass);
                final int parentWidth = parent.width;
                parent.addControl(new GuiButton("add", 0, 140){

                    @Override
                    public void onClicked(int x, int y, int button) {
                        GuiConfigSubControl control = new GuiConfigSubControl("0", 2, 0, parentWidth, 14);
                        converation.createControls(control, null, subClass, Math.min(100, control.width));
                        listBox.add(control);
                    }
                });
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadValue(List value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
                GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
                if (!box.isEmpty()) {
                    box.clear();
                }
                Class clazz = this.getListType(key);
                ConfigTypeConveration converation = 8.get(clazz);
                ArrayList<GuiConfigSubControl> controls = new ArrayList<GuiConfigSubControl>(value.size());
                for (int i = 0; i < value.size(); ++i) {
                    Object entry = value.get(i);
                    GuiConfigSubControl control = new GuiConfigSubControl("" + i, 2, 0, parent.width, 14);
                    converation.createControls(control, null, clazz, Math.min(100, control.width));
                    converation.loadValue(entry, control, null);
                    controls.add(control);
                }
                box.addAll(controls);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected List saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                Class subClass = this.getListType(key);
                ConfigTypeConveration converation = 8.get(subClass);
                GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
                ArrayList value = new ArrayList(box.size());
                for (int i = 0; i < box.size(); ++i) {
                    value.add(converation.save((GuiParent)box.get(i), subClass, null));
                }
                return value;
            }

            @Override
            public List set(ConfigKey.ConfigKeyField key, List value) {
                return value;
            }

            public Class getListType(ConfigKey.ConfigKeyField key) {
                ParameterizedType type = (ParameterizedType)key.field.getGenericType();
                return (Class)type.getActualTypeArguments()[0];
            }
        });
    }

    public static abstract class SimpleConfigTypeConveration<T>
    extends ConfigTypeConveration<T> {
        @Override
        public T readElement(T defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
            return this.readElement(defaultValue, loadDefault, element);
        }

        public abstract T readElement(T var1, boolean var2, JsonElement var3);

        @Override
        public JsonElement writeElement(T value, T defaultValue, boolean ignoreRestart, boolean saveDefault, Side side, @Nullable ConfigKey.ConfigKeyField key) {
            return this.writeElement(value, defaultValue, saveDefault);
        }

        public abstract JsonElement writeElement(T var1, T var2, boolean var3);

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
            this.createControls(parent, clazz, recommendedWidth);
        }

        @SideOnly(value=Side.CLIENT)
        public abstract void createControls(GuiParent var1, Class var2, int var3);

        @Override
        @SideOnly(value=Side.CLIENT)
        public void loadValue(T value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
            this.loadValue(value, parent);
        }

        @SideOnly(value=Side.CLIENT)
        public abstract void loadValue(T var1, GuiParent var2);

        @Override
        @SideOnly(value=Side.CLIENT)
        protected T saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
            return this.saveValue(parent, clazz);
        }

        @SideOnly(value=Side.CLIENT)
        protected abstract T saveValue(GuiParent var1, Class var2);
    }
}

