/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.mc;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.event.gui.GuiToolTipEvent;
import com.creativemd.creativecore.common.gui.mc.ContainerSub;
import com.creativemd.creativecore.common.gui.mc.IVanillaGUI;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiContainerSub
extends GuiContainer
implements IVanillaGUI {
    protected ArrayList<SubGui> layers;
    public boolean isOpened = false;

    public GuiContainerSub(EntityPlayer player, SubGui gui, SubContainer container) {
        super((Container)new ContainerSub(player, container));
        ((ContainerSub)this.field_147002_h).gui = this;
        Minecraft.func_71410_x().field_71439_g.field_71070_bA = this.field_147002_h;
        this.layers = new ArrayList();
        gui.container = container;
        gui.gui = this;
        container.addListener(gui);
        this.layers.add(gui);
        container.onOpened();
        this.resize();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.isOpened) {
            for (int i = 0; i < this.layers.size(); ++i) {
                this.layers.get(i).onOpened();
            }
            this.isOpened = true;
        }
    }

    public ArrayList<SubGui> getLayers() {
        return this.layers;
    }

    @Override
    public void removeLayer(SubGui layer) {
        this.layers.remove(layer);
        ((ContainerSub)this.field_147002_h).layers.remove(layer.container);
        this.resize();
    }

    @Override
    public void addLayer(SubGui layer) {
        this.layers.add(layer);
        ((ContainerSub)this.field_147002_h).layers.add(layer.container);
        this.resize();
    }

    public void resize() {
        this.field_146999_f = 0;
        this.field_147000_g = 0;
        for (int i = 0; i < this.layers.size(); ++i) {
            if (this.layers.get((int)i).width > this.field_146999_f) {
                this.field_146999_f = this.layers.get((int)i).width;
            }
            if (this.layers.get((int)i).height <= this.field_147000_g) continue;
            this.field_147000_g = this.layers.get((int)i).height;
        }
    }

    public int getWidth() {
        return this.field_146999_f;
    }

    public int getHeight() {
        return this.field_147000_g;
    }

    @Override
    public int getMaxScale(Minecraft mc) {
        int scaleFactor;
        int k = 1000;
        for (scaleFactor = 1; scaleFactor < k && this.field_146999_f * (scaleFactor + 1) <= mc.field_71443_c && this.field_147000_g * (scaleFactor + 1) <= mc.field_71440_d; ++scaleFactor) {
        }
        return scaleFactor;
    }

    @Override
    public boolean hasTopLayer() {
        return this.layers.size() > 0;
    }

    @Override
    public SubGui getTopLayer() {
        if (this.hasTopLayer()) {
            return this.layers.get(this.layers.size() - 1);
        }
        return null;
    }

    @Override
    public boolean isTopLayer(SubGui gui) {
        return this.getTopLayer() == gui;
    }

    @Override
    public boolean isOpen(Class<? extends SubGui> clazz) {
        for (int i = 0; i < this.layers.size(); ++i) {
            if (!clazz.isInstance(this.layers.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends SubGui> T get(Class<T> clazz) {
        for (int i = 0; i < this.layers.size(); ++i) {
            if (!clazz.isInstance(this.layers.get(i))) continue;
            return (T)this.layers.get(i);
        }
        return null;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    public void func_146276_q_() {
    }

    public void onTick() {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).onTick();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.layers.isEmpty()) {
            return;
        }
        int i = this.layers.size() - 1;
        GlStateManager.func_179094_E();
        int k = this.field_147003_i;
        int l = this.field_147009_r;
        int offX = (this.field_146294_l - this.layers.get((int)i).width) / 2 - k;
        int offY = (this.field_146295_m - this.layers.get((int)i).height) / 2 - l;
        GlStateManager.func_179109_b((float)k, (float)l, (float)0.0f);
        GlStateManager.func_179109_b((float)offX, (float)offY, (float)0.0f);
        Vec3d mouse = this.layers.get(i).getMousePos();
        GuiToolTipEvent event = this.layers.get(i).getToolTipEvent();
        if (event != null && this.layers.get(i).raiseEvent(event)) {
            this.drawHoveringText(event.tooltip, (int)mouse.field_72450_a, (int)mouse.field_72448_b, GuiRenderHelper.instance.font);
        }
        GlStateManager.func_179121_F();
        GL11.glClear((int)1024);
    }

    public void func_146979_b(int par1, int par2) {
        for (int i = 0; i < this.layers.size(); ++i) {
            GL11.glDisable((int)2960);
            GL11.glStencilMask((int)-1);
            GL11.glClear((int)1024);
            GL11.glStencilFunc((int)519, (int)1, (int)1);
            GL11.glStencilOp((int)7681, (int)7681, (int)7681);
            GlStateManager.func_179094_E();
            int k = this.field_147003_i;
            int l = this.field_147009_r;
            GlStateManager.func_179109_b((float)(-k), (float)(-l), (float)0.0f);
            if (this.layers.get(i).hasGrayBackground()) {
                this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
            }
            if (i == this.layers.size() - 1) {
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((GuiScreen)this));
            }
            int offX = (this.field_146294_l - this.layers.get((int)i).width) / 2 - k;
            int offY = (this.field_146295_m - this.layers.get((int)i).height) / 2 - l;
            GlStateManager.func_179109_b((float)k, (float)l, (float)0.0f);
            GlStateManager.func_179109_b((float)offX, (float)offY, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.layers.get(i).renderControl(GuiRenderHelper.instance, 1.0f, GuiControl.getScreenRect());
            GlStateManager.func_179121_F();
        }
    }

    public void func_146281_b() {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).onClosed();
        }
    }

    public void func_73869_a(char character, int key) throws IOException {
        if (this.getTopLayer() != null && !this.getTopLayer().onKeyPressed(character, key)) {
            super.func_73869_a(character, key);
        }
    }

    public void func_146269_k() throws IOException {
        if (Mouse.isCreated()) {
            this.handleScrolling();
            Vec3d mouse = this.getTopLayer().getMousePos();
            this.getTopLayer().mouseMove((int)mouse.field_72450_a, (int)mouse.field_72448_b, 0);
        }
        super.func_146269_k();
    }

    public void handleScrolling() {
        int j = Mouse.getDWheel();
        if (j != 0) {
            Vec3d mouse = this.getTopLayer().getMousePos();
            this.getTopLayer().mouseScrolled((int)mouse.field_72450_a, (int)mouse.field_72448_b, j > 0 ? 1 : -1);
        }
    }

    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.getTopLayer().mousePressed(x, y, button);
    }

    public void func_146273_a(int x, int y, int button, long time) {
        super.func_146273_a(x, y, button, time);
        this.getTopLayer().mouseDragged(x, y, button, time);
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.onMouseReleased(x, y, button);
    }

    public void onMouseReleased(int x, int y, int button) {
        this.getTopLayer().mouseReleased(x, y, button);
    }

    @Override
    public void onLayerClosed() {
        if (this.layers.isEmpty()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    @Override
    public void sendChat(String msg) {
        this.func_175275_f(msg);
    }
}

