/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import me.mrdaniel.adventuremmo.bstats.MetricsLite;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Abilities;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Ability;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.AbilityRegistryModule;
import me.mrdaniel.adventuremmo.catalogtypes.settings.Setting;
import me.mrdaniel.adventuremmo.catalogtypes.settings.SettingRegistryModule;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillTypeRegistryModule;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillTypes;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolType;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolTypeRegistryModule;
import me.mrdaniel.adventuremmo.commands.CommandBlockClear;
import me.mrdaniel.adventuremmo.commands.CommandBlockSet;
import me.mrdaniel.adventuremmo.commands.CommandItemClear;
import me.mrdaniel.adventuremmo.commands.CommandItemSet;
import me.mrdaniel.adventuremmo.commands.CommandReload;
import me.mrdaniel.adventuremmo.commands.CommandSet;
import me.mrdaniel.adventuremmo.commands.CommandSetMultiplier;
import me.mrdaniel.adventuremmo.commands.CommandSettings;
import me.mrdaniel.adventuremmo.commands.CommandSkill;
import me.mrdaniel.adventuremmo.commands.CommandSkills;
import me.mrdaniel.adventuremmo.commands.CommandTop;
import me.mrdaniel.adventuremmo.commands.CommandView;
import me.mrdaniel.adventuremmo.data.MMOKeys;
import me.mrdaniel.adventuremmo.data.manipulators.ImmutableMMOData;
import me.mrdaniel.adventuremmo.data.manipulators.ImmutableSuperToolData;
import me.mrdaniel.adventuremmo.data.manipulators.MMOData;
import me.mrdaniel.adventuremmo.data.manipulators.MMODataBuilder;
import me.mrdaniel.adventuremmo.data.manipulators.SuperToolData;
import me.mrdaniel.adventuremmo.data.manipulators.SuperToolDataBuilder;
import me.mrdaniel.adventuremmo.exception.ServiceException;
import me.mrdaniel.adventuremmo.io.Config;
import me.mrdaniel.adventuremmo.io.items.HoconItemDatabase;
import me.mrdaniel.adventuremmo.io.items.ItemDatabase;
import me.mrdaniel.adventuremmo.io.playerdata.HoconPlayerDatabase;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerDatabase;
import me.mrdaniel.adventuremmo.io.tops.HoconTopDatabase;
import me.mrdaniel.adventuremmo.io.tops.TopDatabase;
import me.mrdaniel.adventuremmo.listeners.AbilitiesListener;
import me.mrdaniel.adventuremmo.listeners.ClientListener;
import me.mrdaniel.adventuremmo.listeners.EconomyListener;
import me.mrdaniel.adventuremmo.listeners.WorldListener;
import me.mrdaniel.adventuremmo.managers.DoubleDropManager;
import me.mrdaniel.adventuremmo.managers.MenuManager;
import me.mrdaniel.adventuremmo.managers.MessageManager;
import me.mrdaniel.adventuremmo.service.AdventureMMOService;
import me.mrdaniel.adventuremmo.utils.ChoiceMaps;
import me.mrdaniel.adventuremmo.utils.ItemUtils;
import ninja.leaping.configurate.ConfigurationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Game;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStoppingEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

@Plugin(id="adventuremmo", name="AdventureMMO", version="2.1.2", description="A lightweight plugin that adds skills with all sorts of fun game mechanics to your server.", authors={"Daniel12321", "rojo8399", "The_Fireplace", "JELLY"})
public class AdventureMMO {
    private final Game game;
    private final Logger logger;
    private final Path configdir;
    private final PluginContainer container;
    private PlayerDatabase playerdata;
    private TopDatabase tops;
    private ItemDatabase itemdata;
    private MenuManager menus;
    private MessageManager messages;
    private DoubleDropManager doubledrops;
    private ChoiceMaps choices;

    @Inject
    public AdventureMMO(Game game, @ConfigDir(sharedRoot=false) Path path, PluginContainer container, MetricsLite metrics) {
        this.game = game;
        this.logger = LoggerFactory.getLogger((String)"AdventureMMO");
        this.configdir = path;
        this.container = container;
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException exc) {
                this.logger.error("Failed to create main config directory: {}", (Throwable)exc);
            }
        }
    }

    @Listener
    public void onPreInit(@Nullable GamePreInitializationEvent e) {
        this.logger.info("Registering custom data...");
        Key<Value<Integer>> key = MMOKeys.DURABILITY;
        this.game.getRegistry().registerModule(SkillType.class, (CatalogRegistryModule)new SkillTypeRegistryModule());
        this.game.getRegistry().registerModule(ToolType.class, (CatalogRegistryModule)new ToolTypeRegistryModule());
        this.game.getRegistry().registerModule(Ability.class, (CatalogRegistryModule)new AbilityRegistryModule());
        this.game.getRegistry().registerModule(Setting.class, (CatalogRegistryModule)new SettingRegistryModule());
        this.game.getServiceManager().setProvider((Object)this, AdventureMMOService.class, (Object)new AdventureMMOService(this));
        this.logger.info("Registered custom data successfully.");
    }

    @Listener
    public void onInit(@Nullable GameInitializationEvent e) {
        this.logger.info("Loading plugin...");
        DataRegistration.builder().dataClass(MMOData.class).immutableClass(ImmutableMMOData.class).builder((DataManipulatorBuilder)new MMODataBuilder()).manipulatorId("data").dataName("Data").buildAndRegister(this.container);
        DataRegistration.builder().dataClass(SuperToolData.class).immutableClass(ImmutableSuperToolData.class).builder((DataManipulatorBuilder)new SuperToolDataBuilder()).manipulatorId("super-tool-data").dataName("Super Tool Data").buildAndRegister(this.container);
        long startuptime = System.currentTimeMillis();
        Config config = new Config(this, this.configdir.resolve("config.conf"));
        Abilities.VALUES.removeIf(ability -> !config.getNode("abilities", ability.getId(), "enabled").getBoolean(true));
        Abilities.VALUES.forEach(ability -> ability.setValues((ConfigurationNode)config.getNode("abilities", ability.getId())));
        SkillTypes.VALUES.removeIf(skill -> !config.getNode("skills", skill.getId(), "enabled").getBoolean(true));
        SkillTypes.VALUES.forEach(skill -> skill.getAbilities().removeIf(Ability::isDisabled));
        this.playerdata = new HoconPlayerDatabase(this, this.configdir.resolve("playerdata"));
        this.tops = new HoconTopDatabase(this, this.configdir.resolve("tops.conf"));
        this.itemdata = new HoconItemDatabase(this, this.configdir.resolve("itemdata.conf"));
        this.menus = new MenuManager(this);
        this.messages = new MessageManager(this, (ConfigurationNode)config.getNode("messages"));
        this.doubledrops = new DoubleDropManager(this);
        this.choices = new ChoiceMaps();
        this.game.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | Skills Command"})).arguments(GenericArguments.optionalWeak((CommandElement)GenericArguments.choices((Text)Text.of((String)"skill"), this.choices.getSkills()))).executor((CommandExecutor)new CommandSkills(this)).build(), config.getNode("commands", "skills").getList(obj -> (String)obj));
        this.game.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | Top Command"})).arguments(GenericArguments.optionalWeak((CommandElement)GenericArguments.choices((Text)Text.of((String)"skill"), this.choices.getSkills()))).executor((CommandExecutor)new CommandTop(this)).build(), config.getNode("commands", "tops").getList(obj -> (String)obj));
        this.game.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | Settings Command"})).executor((CommandExecutor)new CommandSettings(this)).build(), config.getNode("commands", "settings").getList(obj -> (String)obj));
        SkillTypes.VALUES.stream().filter(skill -> config.getNode("commands", skill.getId()).getBoolean(true)).forEach(skill -> this.game.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | ", skill.getName(), " Command"})).executor((CommandExecutor)new CommandSkill(this, (SkillType)skill)).build(), new String[]{skill.getId()}));
        this.game.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().child((CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | Reload Command"})).permission("mmo.admin.reload").executor((CommandExecutor)new CommandReload(this)).build(), new String[]{"reload"}).child((CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | View Command"})).permission("mmo.admin.view").arguments(GenericArguments.user((Text)Text.of((String)"user"))).executor((CommandExecutor)new CommandView(this)).build(), new String[]{"view"}).child((CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | Set Command"})).permission("mmo.admin.set").arguments(new CommandElement[]{GenericArguments.user((Text)Text.of((String)"user")), GenericArguments.choices((Text)Text.of((String)"skill"), this.choices.getSkills()), GenericArguments.integer((Text)Text.of((String)"level")), GenericArguments.optionalWeak((CommandElement)GenericArguments.integer((Text)Text.of((String)"exp")))}).executor((CommandExecutor)new CommandSet(this)).build(), new String[]{"set"}).child((CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | SetItem Command"})).permission("mmo.admin.setitem").arguments(GenericArguments.choices((Text)Text.of((String)"tooltype"), this.choices.getTools())).executor((CommandExecutor)new CommandItemSet(this)).build(), new String[]{"setitem"}).child((CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | SetBlock Command"})).permission("mmo.admin.setblock").arguments(new CommandElement[]{GenericArguments.choices((Text)Text.of((String)"skill"), this.choices.getSkills()), GenericArguments.integer((Text)Text.of((String)"exp"))}).executor((CommandExecutor)new CommandBlockSet(this)).build(), new String[]{"setblock"}).child((CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | ClearItem Command"})).permission("mmo.admin.clearitem").executor((CommandExecutor)new CommandItemClear(this)).build(), new String[]{"clearitem"}).child((CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | ClearBlock Command"})).permission("mmo.admin.clearblock").executor((CommandExecutor)new CommandBlockClear(this)).build(), new String[]{"clearblock"}).child((CommandCallable)CommandSpec.builder().description(Text.of((Object[])new Object[]{TextColors.BLUE, "AdventureMMO | SetMultiplier Command"})).permission("mmo.admin.setmultiplier").arguments(GenericArguments.user((Text)Text.of((String)"user"))).executor((CommandExecutor)new CommandSetMultiplier(this)).build(), new String[]{"setmultiplier"}).build(), new String[]{"mmoadmin"});
        SkillTypes.VALUES.forEach(skill -> this.game.getEventManager().registerListeners((Object)this, skill.getListener().apply(this, config)));
        this.game.getEventManager().registerListeners((Object)this, (Object)new ClientListener(this));
        this.game.getEventManager().registerListeners((Object)this, (Object)new AbilitiesListener(this, config));
        this.game.getEventManager().registerListeners((Object)this, (Object)new WorldListener(this));
        this.game.getEventManager().registerListeners((Object)this, (Object)this.doubledrops);
        if (config.getNode("economy", "enabled").getBoolean()) {
            try {
                this.game.getEventManager().registerListeners((Object)this, (Object)new EconomyListener(this, config));
            }
            catch (ServiceException exc) {
                this.logger.error("No Economy Service was found! Install one or disable economy in the config file: {}", (Throwable)exc);
            }
        }
        this.logger.info("Loaded plugin successfully in {} milliseconds.", (Object)(System.currentTimeMillis() - startuptime));
    }

    @Listener
    public void onStopping(@Nullable GameStoppingEvent e) {
        this.game.getServer().getOnlinePlayers().forEach(p -> ItemUtils.restoreSuperTool(p, this.container));
        this.playerdata.unloadAll();
    }

    @Listener
    public void onReload(@Nullable GameReloadEvent e) {
        this.logger.info("Reloading...");
        this.onStopping(null);
        this.game.getEventManager().unregisterPluginListeners((Object)this);
        this.game.getScheduler().getScheduledTasks((Object)this).forEach(Task::cancel);
        this.game.getCommandManager().getOwnedBy((Object)this).forEach(arg_0 -> ((CommandManager)this.game.getCommandManager()).removeMapping(arg_0));
        this.onInit(null);
        this.logger.info("Reloaded successfully.");
    }

    @Nonnull
    public Game getGame() {
        return this.game;
    }

    @Nonnull
    public Logger getLogger() {
        return this.logger;
    }

    @Nonnull
    public PluginContainer getContainer() {
        return this.container;
    }

    @Nonnull
    public PlayerDatabase getPlayerDatabase() {
        return this.playerdata;
    }

    @Nonnull
    public TopDatabase getTops() {
        return this.tops;
    }

    @Nonnull
    public ItemDatabase getItemDatabase() {
        return this.itemdata;
    }

    @Nonnull
    public MenuManager getMenus() {
        return this.menus;
    }

    @Nonnull
    public MessageManager getMessages() {
        return this.messages;
    }

    @Nonnull
    public DoubleDropManager getDoubleDrops() {
        return this.doubledrops;
    }

    @Nonnull
    public ChoiceMaps getChoices() {
        return this.choices;
    }
}

