/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.bstats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;

public class MetricsLite {
    public static final int B_STATS_VERSION = 1;
    private static final String URL = "https://bStats.org/submitData/sponge";
    private static boolean created = false;
    private boolean enabled;
    private boolean logFailedRequests;
    private Logger logger;
    private final PluginContainer plugin;
    private String serverUUID;
    private static final List<Object> knownMetricsInstances = new ArrayList<Object>();
    private Path configDir;

    @Inject
    private MetricsLite(PluginContainer plugin, Logger logger, @ConfigDir(sharedRoot=true) Path configDir) {
        block9: {
            this.logFailedRequests = false;
            if (created) {
                throw new IllegalStateException("There's already an instance of this Metrics class!");
            }
            created = true;
            this.plugin = plugin;
            this.logger = logger;
            this.configDir = configDir;
            try {
                this.loadConfig();
            }
            catch (IOException e) {
                logger.warn("Failed to load bStats config!", (Throwable)e);
                return;
            }
            if (!this.enabled) {
                return;
            }
            Class<?> usedMetricsClass = this.getFirstBStatsClass();
            if (usedMetricsClass == null) {
                return;
            }
            if (usedMetricsClass == this.getClass()) {
                MetricsLite.linkMetrics(this);
                this.startSubmitting();
            } else {
                try {
                    usedMetricsClass.getMethod("linkMetrics", Object.class).invoke(null, this);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (!this.logFailedRequests) break block9;
                    logger.warn("Failed to link to first metrics class {}!", (Object)usedMetricsClass.getName(), (Object)e);
                }
            }
        }
    }

    public static void linkMetrics(Object metrics) {
        knownMetricsInstances.add(metrics);
    }

    public JsonObject getPluginData() {
        JsonObject data = new JsonObject();
        data.addProperty("pluginName", this.plugin.getName());
        data.addProperty("pluginVersion", this.plugin.getVersion().orElse("unknown"));
        data.add("customCharts", (JsonElement)new JsonArray());
        return data;
    }

    private void startSubmitting() {
        final Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!Sponge.getPluginManager().isLoaded(MetricsLite.this.plugin.getId())) {
                    timer.cancel();
                    return;
                }
                Task.builder().execute(() -> MetricsLite.this.submitData()).submit((Object)MetricsLite.this.plugin);
            }
        }, 300000L, 1800000L);
    }

    private JsonObject getServerData() {
        JsonObject data = new JsonObject();
        data.addProperty("serverUUID", this.serverUUID);
        data.addProperty("playerAmount", (Number)Math.min(Sponge.getServer().getOnlinePlayers().size(), 200));
        data.addProperty("onlineMode", (Number)(Sponge.getServer().getOnlineMode() ? 1 : 0));
        data.addProperty("minecraftVersion", Sponge.getGame().getPlatform().getMinecraftVersion().getName());
        data.addProperty("javaVersion", System.getProperty("java.version"));
        data.addProperty("osName", System.getProperty("os.name"));
        data.addProperty("osArch", System.getProperty("os.arch"));
        data.addProperty("osVersion", System.getProperty("os.version"));
        data.addProperty("coreCount", (Number)Runtime.getRuntime().availableProcessors());
        return data;
    }

    private void submitData() {
        JsonObject data = this.getServerData();
        JsonArray pluginData = new JsonArray();
        for (Object metrics : knownMetricsInstances) {
            try {
                Object plugin = metrics.getClass().getMethod("getPluginData", new Class[0]).invoke(metrics, new Object[0]);
                if (!(plugin instanceof JsonObject)) continue;
                pluginData.add((JsonElement)((JsonObject)plugin));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
        }
        data.add("plugins", (JsonElement)pluginData);
        new Thread(() -> {
            block2: {
                try {
                    MetricsLite.sendData(data);
                }
                catch (Exception e) {
                    if (!this.logFailedRequests) break block2;
                    this.logger.warn("Could not submit plugin stats!", (Throwable)e);
                }
            }
        }).start();
    }

    private void loadConfig() throws IOException {
        CommentedConfigurationNode node;
        Path configPath = this.configDir.resolve("bStats");
        if (!Files.exists(configPath, new LinkOption[0])) {
            Files.createDirectory(configPath, new FileAttribute[0]);
        }
        Path configFile = configPath.resolve("config.conf");
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(configFile)).build();
        if (!Files.exists(configFile, new LinkOption[0])) {
            Files.createFile(configFile, new FileAttribute[0]);
            node = (CommentedConfigurationNode)configurationLoader.load();
            node.getNode(new Object[]{"enabled"}).setValue((Object)true);
            node.getNode(new Object[]{"serverUuid"}).setValue((Object)UUID.randomUUID().toString());
            node.getNode(new Object[]{"logFailedRequests"}).setValue((Object)false);
            node.getNode(new Object[]{"enabled"}).setComment("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo honor their work, you should not disable it.\nThis has nearly no effect on the server performance!\nCheck out https://bStats.org/ to learn more :)");
            configurationLoader.save((ConfigurationNode)node);
        } else {
            node = (CommentedConfigurationNode)configurationLoader.load();
        }
        this.enabled = node.getNode(new Object[]{"enabled"}).getBoolean(true);
        this.serverUUID = node.getNode(new Object[]{"serverUuid"}).getString();
        this.logFailedRequests = node.getNode(new Object[]{"logFailedRequests"}).getBoolean(false);
    }

    private Class<?> getFirstBStatsClass() {
        Path configPath = this.configDir.resolve("bStats");
        configPath.toFile().mkdirs();
        File tempFile = new File(configPath.toFile(), "temp.txt");
        try {
            String className = this.readFile(tempFile);
            if (className != null) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.writeFile(tempFile, this.getClass().getName());
            return this.getClass();
        }
        catch (IOException e) {
            if (this.logFailedRequests) {
                this.logger.warn("Failed to get first bStats class!", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private String readFile(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeFile(File file, String text) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(text);
            bufferedWriter.newLine();
            bufferedWriter.write("Note: This class only exists for internal purpose. You can ignore it :)");
        }
    }

    private static void sendData(JsonObject data) throws Exception {
        Validate.notNull((Object)data, (String)"Data cannot be null", (Object[])new Object[0]);
        HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] compressedData = MetricsLite.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.write(compressedData);
        outputStream.flush();
        outputStream.close();
        connection.getInputStream().close();
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
        gzip.write(str.getBytes(StandardCharsets.UTF_8));
        gzip.close();
        return outputStream.toByteArray();
    }
}

