/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.catalogtypes.abilities;

import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Abilities;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.util.annotation.CatalogedBy;

@CatalogedBy(value={Abilities.class})
public abstract class Ability
implements CatalogType {
    private final String name;
    private final String id;
    private double initial;
    private double increment;
    private double cap;
    private boolean enabled;

    public Ability(@Nonnull String name, @Nonnull String id) {
        this.name = name;
        this.id = id;
        this.initial = 0.0;
        this.increment = 0.0;
        this.cap = 0.0;
        this.enabled = false;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public double getIncrement() {
        return this.increment;
    }

    public double getInitial() {
        return this.initial;
    }

    public double getCap() {
        return this.cap;
    }

    public double getValue(int level) {
        return Math.min(this.getInitial() + this.getIncrement() * (double)level, this.getCap());
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public abstract String getValueLine(int var1);

    public void setValues(@Nonnull ConfigurationNode node) {
        this.initial = node.getNode(new Object[]{"initial_value"}).getDouble(0.0);
        this.increment = node.getNode(new Object[]{"level_increment"}).getDouble(0.1);
        this.cap = node.getNode(new Object[]{"value_cap"}).getDouble(80.0);
        this.enabled = true;
    }
}

