/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.commands;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolType;
import me.mrdaniel.adventuremmo.commands.PlayerCommand;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class CommandItemSet
extends PlayerCommand {
    private final AdventureMMO mmo;

    public CommandItemSet(@Nonnull AdventureMMO mmo) {
        this.mmo = mmo;
    }

    @Override
    public void execute(Player p, CommandContext args) {
        Optional hand = p.getItemInHand(HandTypes.MAIN_HAND);
        if (!hand.isPresent()) {
            p.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be holding an item to use this command"}));
            return;
        }
        ItemType item = ((ItemStack)hand.get()).getType();
        ToolType tool = (ToolType)args.getOne("tooltype").get();
        this.mmo.getItemDatabase().set(item, tool);
        this.mmo.getMessages().sendItemSet(p, item, tool);
    }
}

