/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.commands;

import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.MMOObject;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class CommandSetMultiplier
extends MMOObject
implements CommandExecutor {
    public CommandSetMultiplier(@Nonnull AdventureMMO mmo) {
        super(mmo);
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        User user = args.getOne("user").orElse(null);
        if (user == null) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Invalid User!"}));
        }
        try {
            CommandSetMultiplier.setMeta(user, "mcmmo-multiplier", 604800);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully set " + user.getName() + "'s MCMMO multiplier!"}));
        return CommandResult.success();
    }

    static void setMeta(User USER, String KEY, Object VALUE) throws ExecutionException, InterruptedException {
        USER.getSubjectData().setOption(SubjectData.GLOBAL_CONTEXT, KEY, String.valueOf(VALUE)).get();
    }
}

