/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.data.manipulators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.data.MMOKeys;
import me.mrdaniel.adventuremmo.data.manipulators.ImmutableMMOData;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class MMOData
extends AbstractData<MMOData, ImmutableMMOData> {
    private Map<String, Long> delays;
    private Map<String, Long> abilities;
    private boolean action_bar;
    private boolean scoreboard;
    private boolean scoreboard_permanent;

    public MMOData() {
        this(Maps.newHashMap(), Maps.newHashMap(), false, false, false);
    }

    public MMOData(@Nonnull Map<String, Long> delays, @Nonnull Map<String, Long> abilities, boolean action_bar, boolean scoreboard, boolean scoreboard_permanent) {
        this.delays = delays;
        this.abilities = abilities;
        this.action_bar = action_bar;
        this.scoreboard = scoreboard;
        this.scoreboard_permanent = scoreboard_permanent;
        this.registerGettersAndSetters();
    }

    protected void registerGettersAndSetters() {
        this.registerFieldGetter(MMOKeys.DELAYS, this::getDelays);
        this.registerFieldSetter(MMOKeys.DELAYS, this::setDelays);
        this.registerKeyValue(MMOKeys.DELAYS, this::getDelaysValue);
        this.registerFieldGetter(MMOKeys.ABILITIES, this::getAbilities);
        this.registerFieldSetter(MMOKeys.ABILITIES, this::setAbilities);
        this.registerKeyValue(MMOKeys.ABILITIES, this::getAbilitiesValue);
        this.registerFieldGetter(MMOKeys.ACTION_BAR, this::getActionBar);
        this.registerFieldSetter(MMOKeys.ACTION_BAR, this::setActionBar);
        this.registerKeyValue(MMOKeys.ACTION_BAR, this::getActionBarValue);
        this.registerFieldGetter(MMOKeys.SCOREBOARD, this::getScoreboard);
        this.registerFieldSetter(MMOKeys.SCOREBOARD, this::setScoreboard);
        this.registerKeyValue(MMOKeys.SCOREBOARD, this::getScoreboardValue);
        this.registerFieldGetter(MMOKeys.SCOREBOARD_PERMANENT, this::getScoreboardPermanent);
        this.registerFieldSetter(MMOKeys.SCOREBOARD_PERMANENT, this::setScoreboardPermanent);
        this.registerKeyValue(MMOKeys.SCOREBOARD_PERMANENT, this::getScoreboardPermanentValue);
    }

    public Value<Map<String, Long>> getDelaysValue() {
        return MMOKeys.FACTORY.createMapValue(MMOKeys.DELAYS, this.delays);
    }

    public Value<Map<String, Long>> getAbilitiesValue() {
        return MMOKeys.FACTORY.createMapValue(MMOKeys.ABILITIES, this.abilities);
    }

    public Value<Boolean> getActionBarValue() {
        return MMOKeys.FACTORY.createValue(MMOKeys.ACTION_BAR, (Object)this.action_bar);
    }

    public Value<Boolean> getScoreboardValue() {
        return MMOKeys.FACTORY.createValue(MMOKeys.SCOREBOARD, (Object)this.scoreboard);
    }

    public Value<Boolean> getScoreboardPermanentValue() {
        return MMOKeys.FACTORY.createValue(MMOKeys.SCOREBOARD_PERMANENT, (Object)this.scoreboard_permanent);
    }

    public Map<String, Long> getDelays() {
        return this.delays;
    }

    public long getDelay(@Nonnull String id) {
        return Optional.ofNullable(this.delays.get(id)).orElse(0L);
    }

    public void setDelays(Map<String, Long> delays) {
        this.delays = delays;
    }

    public void setDelay(@Nonnull String id, long endtime) {
        this.delays.put(id, endtime);
    }

    public boolean isDelayActive(@Nonnull String id) {
        return this.getDelay(id) > System.currentTimeMillis();
    }

    public Map<String, Long> getAbilities() {
        return this.abilities;
    }

    public long getAbility(@Nonnull String id) {
        return Optional.ofNullable(this.abilities.get(id)).orElse(0L);
    }

    public void setAbilities(@Nonnull Map<String, Long> abilities) {
        this.abilities = abilities;
    }

    public void setAbility(@Nonnull String id, long endtime) {
        this.abilities.put(id, endtime);
    }

    public boolean isAbilityActive(@Nonnull String id) {
        return this.getAbility(id) > System.currentTimeMillis();
    }

    public boolean getActionBar() {
        return this.action_bar;
    }

    public void setActionBar(boolean action_bar) {
        this.action_bar = action_bar;
    }

    public boolean getScoreboard() {
        return this.scoreboard;
    }

    public void setScoreboard(boolean scoreboard) {
        this.scoreboard = scoreboard;
    }

    public boolean getScoreboardPermanent() {
        return this.scoreboard_permanent;
    }

    public void setScoreboardPermanent(boolean scoreboard_permanent) {
        this.scoreboard_permanent = scoreboard_permanent;
    }

    public Optional<MMOData> from(@Nonnull DataView view) {
        return Optional.of(new MMOData(view.getMap(MMOKeys.DELAYS.getQuery()).map(map -> Maps.newHashMap((Map)map)).orElse(Maps.newHashMap()), view.getMap(MMOKeys.ABILITIES.getQuery()).map(map -> Maps.newHashMap((Map)map)).orElse(Maps.newHashMap()), view.getBoolean(MMOKeys.ACTION_BAR.getQuery()).orElse(true), view.getBoolean(MMOKeys.SCOREBOARD.getQuery()).orElse(true), view.getBoolean(MMOKeys.SCOREBOARD_PERMANENT.getQuery()).orElse(false)));
    }

    public DataContainer toContainer() {
        return super.toContainer().set(MMOKeys.DELAYS.getQuery(), this.delays).set(MMOKeys.ABILITIES.getQuery(), this.abilities).set(MMOKeys.ACTION_BAR.getQuery(), (Object)this.action_bar).set(MMOKeys.SCOREBOARD.getQuery(), (Object)this.scoreboard).set(MMOKeys.SCOREBOARD_PERMANENT.getQuery(), (Object)this.scoreboard_permanent);
    }

    public Optional<MMOData> fill(DataHolder holder, MergeFunction overlap) {
        return Optional.of(((MergeFunction)Preconditions.checkNotNull((Object)overlap)).merge((ValueContainer)this.copy(), (ValueContainer)this.from(holder.toContainer()).orElse(null)));
    }

    public Optional<MMOData> from(DataContainer container) {
        return this.from((DataView)container);
    }

    public MMOData copy() {
        return new MMOData(this.delays, this.abilities, this.action_bar, this.scoreboard, this.scoreboard_permanent);
    }

    public ImmutableMMOData asImmutable() {
        return new ImmutableMMOData(this.delays, this.abilities, this.action_bar, this.scoreboard, this.scoreboard_permanent);
    }

    public int getContentVersion() {
        return 1;
    }
}

