/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.data.manipulators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.data.MMOKeys;
import me.mrdaniel.adventuremmo.data.manipulators.ImmutableSuperToolData;
import me.mrdaniel.adventuremmo.utils.TextUtils;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class SuperToolData
extends AbstractData<SuperToolData, ImmutableSuperToolData> {
    private List<Enchantment> enchants;
    private String name;
    private int durability;

    public SuperToolData() {
        this(Lists.newArrayList(), "", 0);
    }

    public SuperToolData(@Nonnull List<Enchantment> enchants, @Nonnull String name, int durability) {
        this.enchants = enchants;
        this.name = name;
        this.durability = durability;
        this.registerGettersAndSetters();
    }

    protected void registerGettersAndSetters() {
        this.registerFieldGetter(MMOKeys.ENCHANTS, this::getEnchants);
        this.registerFieldSetter(MMOKeys.ENCHANTS, this::setEnchants);
        this.registerKeyValue(MMOKeys.ENCHANTS, this::getEnchantsValue);
        this.registerFieldGetter(MMOKeys.NAME, this::getName);
        this.registerFieldSetter(MMOKeys.NAME, this::setName);
        this.registerKeyValue(MMOKeys.NAME, this::getNameValue);
        this.registerFieldGetter(MMOKeys.DURABILITY, this::getDurability);
        this.registerFieldSetter(MMOKeys.DURABILITY, this::setDurability);
        this.registerKeyValue(MMOKeys.DURABILITY, this::getDurabilityValue);
    }

    public ListValue<Enchantment> getEnchantsValue() {
        return MMOKeys.FACTORY.createListValue(MMOKeys.ENCHANTS, this.enchants);
    }

    public List<Enchantment> getEnchants() {
        return this.enchants;
    }

    public void setEnchants(List<Enchantment> enchants) {
        this.enchants = enchants;
    }

    public Value<String> getNameValue() {
        return MMOKeys.FACTORY.createValue(MMOKeys.NAME, (Object)this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Value<Integer> getDurabilityValue() {
        return MMOKeys.FACTORY.createValue(MMOKeys.DURABILITY, (Object)this.durability);
    }

    public int getDurability() {
        return this.durability;
    }

    public void setDurability(int durability) {
        this.durability = durability;
    }

    @Nonnull
    public ItemStack restore(@Nonnull ItemStack tool) {
        if (this.name.equals("")) {
            tool.remove(Keys.DISPLAY_NAME);
        } else {
            tool.offer(Keys.DISPLAY_NAME, (Object)TextUtils.toText(this.name));
        }
        tool.offer(Keys.ITEM_ENCHANTMENTS, this.enchants);
        tool.offer(Keys.UNBREAKABLE, (Object)false);
        if (this.durability != 0) {
            tool.offer(Keys.ITEM_DURABILITY, (Object)this.durability);
        }
        tool.remove(SuperToolData.class);
        return tool;
    }

    public Optional<SuperToolData> from(@Nonnull DataView view) {
        return Optional.of(new SuperToolData(view.getList(MMOKeys.ENCHANTS.getQuery()).map(l -> l).orElse(Lists.newArrayList()), view.getString(MMOKeys.NAME.getQuery()).orElse(""), view.getInt(MMOKeys.DURABILITY.getQuery()).orElse(0)));
    }

    public DataContainer toContainer() {
        return super.toContainer().set(MMOKeys.ENCHANTS.getQuery(), this.enchants).set(MMOKeys.NAME.getQuery(), (Object)this.name).set(MMOKeys.DURABILITY.getQuery(), (Object)this.durability);
    }

    public Optional<SuperToolData> fill(DataHolder holder, MergeFunction overlap) {
        return Optional.of(((MergeFunction)Preconditions.checkNotNull((Object)overlap)).merge((ValueContainer)this.copy(), (ValueContainer)this.from(holder.toContainer()).orElse(null)));
    }

    public Optional<SuperToolData> from(DataContainer container) {
        return this.from((DataView)container);
    }

    public SuperToolData copy() {
        return new SuperToolData(this.enchants, this.name, this.durability);
    }

    public ImmutableSuperToolData asImmutable() {
        return new ImmutableSuperToolData(this.enchants, this.name, this.durability);
    }

    public int getContentVersion() {
        return 1;
    }
}

