/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.event;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.ActiveAbility;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class AbilityEvent
extends AbstractEvent
implements Cancellable {
    private final Player player;
    private final ToolType tool;
    private final boolean onblock;
    private final Cause cause;
    private boolean cancelled;
    @Nullable
    private ActiveAbility ability;
    @Nullable
    private SkillType skill;

    public AbilityEvent(AdventureMMO mmo, Player player, ToolType tool, boolean onblock) {
        this.player = player;
        this.tool = tool;
        this.onblock = onblock;
        this.cause = Cause.builder().append((Object)mmo.getContainer()).build(EventContext.empty());
        this.cancelled = false;
        this.ability = null;
        this.skill = null;
    }

    @Nonnull
    public Player getPlayer() {
        return this.player;
    }

    @Nonnull
    public ToolType getTool() {
        return this.tool;
    }

    public boolean isOnBlock() {
        return this.onblock;
    }

    @Nullable
    public ActiveAbility getAbility() {
        return this.ability;
    }

    public void setAbility(@Nullable ActiveAbility ability) {
        this.ability = ability;
    }

    @Nullable
    public SkillType getSkill() {
        return this.skill;
    }

    public void setSkill(@Nullable SkillType skill) {
        this.skill = skill;
    }

    public Cause getCause() {
        return this.cause;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

