/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.asset.Asset;

public class Config {
    private final ConfigurationLoader<CommentedConfigurationNode> loader;
    private final CommentedConfigurationNode node;

    public Config(@Nonnull AdventureMMO mmo, @Nonnull Path path) {
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                ((Asset)mmo.getContainer().getAsset("config.conf").get()).copyToFile(path);
            }
            catch (IOException exc) {
                mmo.getLogger().error("Failed to save config asset: {}", (Throwable)exc);
            }
        }
        this.node = this.load(mmo.getLogger());
    }

    private CommentedConfigurationNode load(@Nonnull Logger logger) {
        try {
            return (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException exc) {
            logger.error("Failed to load config file: {}", (Throwable)exc);
            return (CommentedConfigurationNode)this.loader.createEmptyNode();
        }
    }

    @Nonnull
    public CommentedConfigurationNode getNode(Object ... keys) {
        return this.node.getNode(keys);
    }
}

