/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.io;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolType;
import me.mrdaniel.adventuremmo.io.items.BlockData;
import me.mrdaniel.adventuremmo.io.items.ItemDatabase;
import me.mrdaniel.adventuremmo.io.items.ToolData;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerDatabase;
import me.mrdaniel.adventuremmo.io.playerdata.SQLPlayerData;
import me.mrdaniel.adventuremmo.io.tops.TopDatabase;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Tuple;

public class SQLDatabase
implements PlayerDatabase,
ItemDatabase,
TopDatabase {
    private final Map<UUID, SQLPlayerData> players;

    public SQLDatabase(@Nonnull AdventureMMO mmo, @Nonnull Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                ((Asset)mmo.getContainer().getAsset("storage.db").get()).copyToFile(path);
            }
            catch (IOException exc) {
                mmo.getLogger().error("Failed to create database file from asset: {}", (Throwable)exc);
            }
        }
        this.players = new ConcurrentHashMap<UUID, SQLPlayerData>();
    }

    @Override
    public void update(@Nonnull String player, @Nullable SkillType skill, int level) {
    }

    @Override
    @Nonnull
    public Map<Integer, Tuple<String, Integer>> getTop(@Nullable SkillType skill) {
        return Maps.newHashMap();
    }

    @Override
    @Nonnull
    public Optional<BlockData> getData(@Nonnull BlockType type) {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ToolData> getData(@Nonnull ItemType type) {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ToolData> getData(@Nullable ItemStack item) {
        return Optional.empty();
    }

    @Override
    public synchronized void unload(@Nonnull UUID uuid) {
        this.players.remove(uuid);
    }

    @Override
    public synchronized void unloadAll() {
        this.players.values().forEach(SQLPlayerData::save);
        this.players.clear();
    }

    @Override
    @Nonnull
    public synchronized PlayerData get(@Nonnull UUID uuid) {
        return this.players.get(uuid);
    }

    @Override
    @Nonnull
    public Optional<PlayerData> getOffline(@Nonnull UUID uuid) {
        return Optional.empty();
    }

    @Override
    public void set(@Nonnull ItemType item, @Nonnull ToolType one) {
    }

    @Override
    public void set(@Nonnull BlockType block, @Nonnull SkillType skill, int exp) {
    }

    @Override
    public void remove(@Nonnull ItemType item) {
    }

    @Override
    public void remove(@Nonnull BlockType block) {
    }
}

