/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.io.items;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.MMOObject;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillTypes;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolType;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolTypes;
import me.mrdaniel.adventuremmo.io.items.BlockData;
import me.mrdaniel.adventuremmo.io.items.ItemDatabase;
import me.mrdaniel.adventuremmo.io.items.ToolData;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;

public class HoconItemDatabase
extends MMOObject
implements ItemDatabase {
    private final Map<BlockType, BlockData> blocks = Maps.newHashMap();
    private final Map<ItemType, ToolData> tools = Maps.newHashMap();
    private final ConfigurationLoader<CommentedConfigurationNode> loader;
    private final CommentedConfigurationNode node;

    public HoconItemDatabase(@Nonnull AdventureMMO mmo, @Nonnull Path path) {
        super(mmo);
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                ((Asset)mmo.getContainer().getAsset("itemdata.conf").get()).copyToFile(path);
            }
            catch (IOException exc) {
                mmo.getLogger().error("Failed to create itemdata file: ", (Throwable)exc);
            }
        }
        this.node = this.load();
        this.node.getNode(new Object[]{"blocks"}).getChildrenMap().forEach((ido, value) -> {
            String id = (String)ido;
            Optional type = super.getGame().getRegistry().getType(BlockType.class, id);
            Optional<BlockData> data = BlockData.deserialize(value.getString());
            if (type.isPresent()) {
                if (data.isPresent()) {
                    if (SkillTypes.VALUES.contains(data.get().getSkill())) {
                        this.blocks.put((BlockType)type.get(), data.get());
                    }
                } else {
                    super.getLogger().warn("Invalid exp format for block id {}, skipping!", (Object)id);
                }
            } else {
                super.getLogger().warn("Failed to find block id {}, skipping!", (Object)id);
            }
        });
        this.node.getNode(new Object[]{"tools"}).getChildrenMap().forEach((ido, value) -> {
            String id = (String)ido;
            Optional type = super.getGame().getRegistry().getType(ItemType.class, id);
            Optional<ToolData> data = ToolData.deserialize(value.getString());
            if (type.isPresent()) {
                if (data.isPresent()) {
                    this.tools.put((ItemType)type.get(), data.get());
                } else {
                    super.getLogger().warn("Invalid tooltype format for tool id {}, skipping!", (Object)id);
                }
            } else {
                super.getLogger().warn("Failed to find item id {}, skipping!", (Object)id);
            }
        });
    }

    private CommentedConfigurationNode load() {
        try {
            return (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException exc) {
            super.getMMO().getLogger().error("Failed to load itemdata file: ", (Throwable)exc);
            return (CommentedConfigurationNode)this.loader.createEmptyNode();
        }
    }

    private void save() {
        try {
            this.loader.save((ConfigurationNode)this.node);
        }
        catch (IOException exc) {
            super.getLogger().error("Failed to save itemdata file: ", (Throwable)exc);
        }
    }

    @Override
    @Nonnull
    public Optional<BlockData> getData(@Nonnull BlockType type) {
        return Optional.ofNullable(this.blocks.get(type));
    }

    @Override
    @Nonnull
    public Optional<ToolData> getData(@Nonnull ItemType type) {
        return Optional.ofNullable(this.tools.get(type));
    }

    @Override
    @Nonnull
    public Optional<ToolData> getData(@Nonnull ItemStack item) {
        if (item.isEmpty()) {
            return Optional.of(new ToolData(ToolTypes.HAND));
        }
        return Optional.ofNullable(this.tools.get(item.getType()));
    }

    @Override
    public void set(@Nonnull ItemType item, @Nonnull ToolType tool) {
        ToolData data = new ToolData(tool);
        this.tools.put(item, data);
        this.node.getNode(new Object[]{"tools", item.getId()}).setValue((Object)data.serialize());
        this.save();
    }

    @Override
    public void set(@Nonnull BlockType block, @Nonnull SkillType skill, int exp) {
        BlockData data = new BlockData(skill, exp);
        this.blocks.put(block, data);
        this.node.getNode(new Object[]{"blocks", block.getId()}).setValue((Object)data.serialize());
        this.save();
    }

    @Override
    public void remove(@Nonnull ItemType item) {
        this.tools.remove(item);
        this.node.getNode(new Object[]{"tools"}).removeChild((Object)item.getId());
        this.save();
    }

    @Override
    public void remove(@Nonnull BlockType block) {
        this.blocks.remove(block);
        this.node.getNode(new Object[]{"blocks"}).removeChild((Object)block.getId());
        this.save();
    }
}

