/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.io.playerdata;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoconPlayerData
implements PlayerData {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AdventureMMO Playerdata");
    private final ConfigurationLoader<CommentedConfigurationNode> loader;
    private final CommentedConfigurationNode node;
    private long last_use;

    public HoconPlayerData(@Nonnull Path path) {
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException exc) {
                LOGGER.error("Failed to create playerdata file: {}", (Throwable)exc);
            }
        }
        this.node = this.load();
        this.last_use = System.currentTimeMillis();
    }

    private CommentedConfigurationNode load() {
        try {
            return (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException exc) {
            LOGGER.error("Failed to load playerdata file: {}", (Throwable)exc);
            return (CommentedConfigurationNode)this.loader.createEmptyNode();
        }
    }

    @Override
    public void save() {
        try {
            this.loader.save((ConfigurationNode)this.node);
        }
        catch (IOException exc) {
            LOGGER.error("Failed to save playerdata file: {}", (Throwable)exc);
        }
    }

    @Override
    public int getLevel(@Nonnull SkillType skill) {
        this.setLastUse();
        return this.node.getNode(new Object[]{skill.getId(), "level"}).getInt();
    }

    @Override
    public void setLevel(@Nonnull SkillType skill, int level) {
        this.setLastUse();
        this.node.getNode(new Object[]{skill.getId(), "level"}).setValue((Object)level);
    }

    @Override
    public int getExp(@Nonnull SkillType skill) {
        this.setLastUse();
        return this.node.getNode(new Object[]{skill.getId(), "exp"}).getInt();
    }

    @Override
    public void setExp(@Nonnull SkillType skill, int exp) {
        this.setLastUse();
        this.node.getNode(new Object[]{skill.getId(), "exp"}).setValue((Object)exp);
    }

    @Override
    public long getLastUse() {
        return this.last_use;
    }

    private void setLastUse() {
        this.last_use = System.currentTimeMillis();
    }
}

