/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.io.playerdata;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.io.playerdata.HoconPlayerData;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerDatabase;
import org.spongepowered.api.scheduler.Task;

public class HoconPlayerDatabase
implements PlayerDatabase {
    private final Path path;
    private final Map<UUID, HoconPlayerData> players;

    public HoconPlayerDatabase(@Nonnull AdventureMMO mmo, @Nonnull Path path) {
        this.path = path;
        this.players = new ConcurrentHashMap<UUID, HoconPlayerData>();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException exc) {
                mmo.getLogger().error("Failed to create main playerdata directory: {}", (Throwable)exc);
            }
        }
        Task.builder().async().delay(30L, TimeUnit.SECONDS).interval(30L, TimeUnit.SECONDS).execute(() -> {
            this.players.values().forEach(HoconPlayerData::save);
            this.players.entrySet().stream().filter(e -> ((HoconPlayerData)e.getValue()).getLastUse() < System.currentTimeMillis() - 180000L).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(this.players::remove);
        }).submit((Object)mmo);
    }

    @Override
    public synchronized void unload(@Nonnull UUID uuid) {
        Optional.ofNullable(this.players.get(uuid)).ifPresent(data -> {
            data.save();
            this.players.remove(uuid);
        });
    }

    @Override
    public synchronized void unloadAll() {
        this.players.values().forEach(HoconPlayerData::save);
        this.players.clear();
    }

    @Override
    @Nonnull
    public synchronized PlayerData get(@Nonnull UUID uuid) {
        HoconPlayerData data = this.players.get(uuid);
        if (data == null) {
            data = new HoconPlayerData(this.path.resolve(uuid.toString() + ".conf"));
            this.players.put(uuid, data);
        }
        return data;
    }

    @Override
    @Nonnull
    public Optional<PlayerData> getOffline(@Nonnull UUID uuid) {
        Path path = this.path.resolve(uuid.toString() + ".conf");
        if (!Files.exists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(new HoconPlayerData(path));
    }
}

