/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.io.playerdata;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.event.LevelUpEvent;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import me.mrdaniel.adventuremmo.utils.MathUtils;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.service.permission.SubjectData;

public interface PlayerDatabase {
    public void unload(UUID var1);

    public void unloadAll();

    public PlayerData get(UUID var1);

    public Optional<PlayerData> getOffline(UUID var1);

    default public PlayerData addExp(@Nonnull AdventureMMO mmo, @Nonnull Player p, @Nonnull SkillType skill, int exp) {
        int exp_till_next_level;
        PlayerData data = this.get(p.getUniqueId());
        HashMap<String, String> meta = PlayerDatabase.getMeta(p);
        if (PlayerDatabase.metaContainsKey(meta, "mcmmo-booster")) {
            if (ChronoUnit.SECONDS.between(Instant.now(), Instant.parse(PlayerDatabase.getMetaValue(meta, "mcmmo-booster"))) > 0L) {
                exp *= 2;
            } else {
                try {
                    PlayerDatabase.setMeta(p, "mcmmo-booster", null);
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    exp /= 2;
                }
            }
        }
        int current_level = data.getLevel(skill);
        int current_exp = data.getExp(skill);
        int new_exp = current_exp + exp;
        if (new_exp >= (exp_till_next_level = MathUtils.expTillNextLevel(current_level)) && !mmo.getGame().getEventManager().post((Event)new LevelUpEvent(mmo, p, skill, current_level, current_level + 1))) {
            data.setLevel(skill, current_level + 1);
            new_exp -= exp_till_next_level;
        }
        data.setExp(skill, new_exp);
        return data;
    }

    public static boolean setMeta(Player PLAYER, String KEY, Object VALUE) throws ExecutionException, InterruptedException {
        return (Boolean)PLAYER.getSubjectData().setOption(SubjectData.GLOBAL_CONTEXT, KEY, String.valueOf(VALUE)).get();
    }

    public static boolean metaContainsKey(HashMap<String, String> META, String KEY) {
        return META.containsKey(KEY);
    }

    public static String getMetaValue(HashMap<String, String> META, String KEY) {
        return META.get(KEY);
    }

    public static HashMap<String, String> getMeta(Player PLAYER) {
        return new HashMap<String, String>(PLAYER.getSubjectData().getOptions(SubjectData.GLOBAL_CONTEXT));
    }
}

