/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.io.tops;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.MMOObject;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.io.tops.TopDatabase;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.util.Tuple;

public class HoconTopDatabase
extends MMOObject
implements TopDatabase {
    private final ConfigurationLoader<CommentedConfigurationNode> loader;
    private final ConfigurationNode node;

    public HoconTopDatabase(@Nonnull AdventureMMO mmo, @Nonnull Path path) {
        super(mmo);
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException exc) {
                super.getLogger().error("Failed to create playerdata file: {}", (Throwable)exc);
            }
        }
        this.node = this.load();
    }

    private ConfigurationNode load() {
        try {
            return this.loader.load();
        }
        catch (IOException exc) {
            super.getLogger().error("Failed to load playerdata file: {}", (Throwable)exc);
            return this.loader.createEmptyNode();
        }
    }

    private void save() {
        try {
            this.loader.save(this.node);
        }
        catch (IOException exc) {
            super.getLogger().error("Failed to save playerdata file: {}", (Throwable)exc);
        }
    }

    @Override
    @Nonnull
    public Map<Integer, Tuple<String, Integer>> getTop(@Nullable SkillType skill) {
        ConfigurationNode node = this.node.getNode(new Object[]{skill == null ? "total" : skill.getId()});
        HashMap top = Maps.newHashMap();
        for (int i = 1; i <= 10; ++i) {
            top.put(i, new Tuple((Object)node.getNode(new Object[]{String.valueOf(i), "name"}).getString(""), (Object)node.getNode(new Object[]{String.valueOf(i), "level"}).getInt(0)));
        }
        return top;
    }

    @Override
    public void update(@Nonnull String player, @Nullable SkillType skill, int level) {
        this.update(this.node.getNode(new Object[]{skill == null ? "total" : skill.getId()}), player, level);
        this.save();
    }

    private void update(@Nonnull ConfigurationNode node, @Nonnull String name, int level) {
        int i;
        for (i = 1; i <= 10; ++i) {
            if (!name.equalsIgnoreCase(node.getNode(new Object[]{String.valueOf(i), "name"}).getString())) continue;
            node.getNode(new Object[]{String.valueOf(i), "level"}).setValue((Object)level);
            for (int j = i; j > 1; --j) {
                if (level <= node.getNode(new Object[]{String.valueOf(j - 1), "level"}).getInt()) continue;
                node.getNode(new Object[]{String.valueOf(j), "name"}).setValue((Object)node.getNode(new Object[]{String.valueOf(j - 1), "name"})).getString();
                node.getNode(new Object[]{String.valueOf(j), "level"}).setValue((Object)node.getNode(new Object[]{String.valueOf(j - 1), "level"})).getInt();
                node.getNode(new Object[]{String.valueOf(j - 1), "name"}).setValue((Object)name);
                node.getNode(new Object[]{String.valueOf(j - 1), "level"}).setValue((Object)level);
            }
            return;
        }
        for (i = 1; i <= 10; ++i) {
            if (level < node.getNode(new Object[]{String.valueOf(i), "level"}).getInt()) continue;
            for (int j = 9; j > i; --j) {
                node.getNode(new Object[]{String.valueOf(j + 1), "name"}).setValue((Object)node.getNode(new Object[]{String.valueOf(j), "name"})).getString();
                node.getNode(new Object[]{String.valueOf(j + 1), "level"}).setValue((Object)node.getNode(new Object[]{String.valueOf(j), "level"})).getInt();
            }
            node.getNode(new Object[]{String.valueOf(i), "name"}).setValue((Object)name);
            node.getNode(new Object[]{String.valueOf(i), "level"}).setValue((Object)level);
            return;
        }
    }
}

