/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.listeners;

import java.util.UUID;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.MMOObject;
import me.mrdaniel.adventuremmo.data.manipulators.ImmutableSuperToolData;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.tileentity.Piston;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.filter.type.Include;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.World;

public class WorldListener
extends MMOObject {
    private final UUID uuid = UUID.fromString("af191b27-3180-4021-bf4a-1d0484069300");

    public WorldListener(@Nonnull AdventureMMO mmo) {
        super(mmo);
    }

    @Include(value={ChangeBlockEvent.Decay.class, ChangeBlockEvent.Grow.class, ChangeBlockEvent.Break.class})
    @Listener(order=Order.LATE)
    @IsCancelled(value=Tristate.FALSE)
    public void onChange(ChangeBlockEvent e) {
        e.getTransactions().forEach(trans -> ((BlockSnapshot)trans.getOriginal()).getLocation().ifPresent(loc -> ((World)loc.getExtent()).setCreator(loc.getBlockPosition(), null)));
    }

    @Listener(order=Order.LATE)
    @IsCancelled(value=Tristate.FALSE)
    public void onBlockPlace(ChangeBlockEvent.Place e) {
        if (e.getCause().first(Piston.class).isPresent() || e.getCause().first(Player.class).isPresent()) {
            e.getTransactions().forEach(trans -> ((BlockSnapshot)trans.getOriginal()).getLocation().ifPresent(loc -> ((World)loc.getExtent()).setCreator(loc.getBlockPosition(), e.getCause().first(Player.class).map(Identifiable::getUniqueId).orElse(this.uuid))));
        }
    }

    @Listener(order=Order.EARLY)
    @IsCancelled(value=Tristate.FALSE)
    public void onItemClick(ClickInventoryEvent e, @First Player p) {
        for (SlotTransaction trans : e.getTransactions()) {
            if (!((ItemStackSnapshot)trans.getOriginal()).get(ImmutableSuperToolData.class).isPresent()) continue;
            e.setCancelled(true);
        }
    }

    @Listener(order=Order.EARLY)
    @IsCancelled(value=Tristate.FALSE)
    public void onItemDrop(DropItemEvent.Pre e) {
        for (ItemStackSnapshot item : e.getOriginalDroppedItems()) {
            if (!item.get(ImmutableSuperToolData.class).isPresent()) continue;
            e.setCancelled(true);
            return;
        }
    }
}

