/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.listeners.skills;

import com.flowpowered.math.vector.Vector3d;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.MMOObject;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Abilities;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillTypes;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.arrow.Arrow;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.projectile.LaunchProjectileEvent;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.util.Tristate;

public class ArcheryListener
extends MMOObject {
    private final int damage_exp;
    private final int kill_exp;

    public ArcheryListener(@Nonnull AdventureMMO mmo, int damage_exp, int kill_exp) {
        super(mmo);
        this.damage_exp = damage_exp;
        this.kill_exp = kill_exp;
    }

    @Listener(order=Order.LATE)
    @IsCancelled(value=Tristate.FALSE)
    public void onDamage(DamageEntityEvent e, @First EntityDamageSource source) {
        Arrow arrow;
        if (source.getSource() instanceof Arrow && (arrow = (Arrow)source.getSource()).getShooter() instanceof Player) {
            super.getMMO().getPlayerDatabase().addExp(super.getMMO(), (Player)arrow.getShooter(), SkillTypes.ARCHERY, e.willCauseDeath() ? this.kill_exp : this.damage_exp);
        }
    }

    @Listener(order=Order.LATE)
    @IsCancelled(value=Tristate.FALSE)
    public void onArrowFire(LaunchProjectileEvent e) {
        if (e.getTargetEntity() instanceof Arrow && e.getTargetEntity().getShooter() instanceof Player) {
            Player p = (Player)e.getTargetEntity().getShooter();
            PlayerData data = super.getMMO().getPlayerDatabase().get(p.getUniqueId());
            if (Abilities.ARROW_RAIN.getChance(data.getLevel(SkillTypes.ARCHERY))) {
                e.getTargetEntity().offer(Keys.FIRE_TICKS, (Object)1000);
                EntityArchetype a = e.getTargetEntity().createArchetype();
                Vector3d v = e.getTargetEntity().getVelocity();
                for (int i = 0; i < 9; ++i) {
                    a.offer(Keys.VELOCITY, (Object)v.add(0.05 - Math.random() * 0.1, 0.05 - Math.random() * 0.1, 0.05 - Math.random() * 0.1));
                    a.apply(e.getTargetEntity().getLocation());
                }
            }
        }
    }
}

