/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.listeners.skills;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Abilities;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillTypes;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolTypes;
import me.mrdaniel.adventuremmo.event.BreakBlockEvent;
import me.mrdaniel.adventuremmo.io.Config;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import me.mrdaniel.adventuremmo.listeners.skills.ActiveAbilityListener;
import me.mrdaniel.adventuremmo.utils.ItemInfo;
import me.mrdaniel.adventuremmo.utils.ItemUtils;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.World;

public class ExcavationListener
extends ActiveAbilityListener {
    private final List<Integer> levels = Lists.newArrayList();
    private final Map<Integer, Tuple<Double, ItemInfo>> drops = Maps.newHashMap();

    public ExcavationListener(@Nonnull AdventureMMO mmo, @Nonnull Config config) {
        super(mmo, Abilities.GIGA_DRILL, SkillTypes.EXCAVATION, ToolTypes.SHOVEL, Tristate.UNDEFINED);
        config.getNode("abilities", "treasurehunt", "loot").getChildrenMap().forEach((typeO, node) -> {
            Optional type = mmo.getGame().getRegistry().getType(ItemType.class, (String)typeO);
            if (type.isPresent()) {
                this.drops.put(node.getNode(new Object[]{"lvl"}).getInt(0), (Tuple<Double, ItemInfo>)new Tuple((Object)node.getNode(new Object[]{"chance"}).getDouble(1.0), (Object)new ItemInfo((ItemType)type.get(), node.getNode(new Object[]{"min_amount"}).getInt(1), node.getNode(new Object[]{"max_amount"}).getInt(1), node.getNode(new Object[]{"min_damage"}).getInt(0), node.getNode(new Object[]{"max_damage"}).getInt(0), node.getNode(new Object[]{"enchanted"}).getBoolean(false))));
            } else {
                mmo.getLogger().error("Failed to find itemtype for: {}", typeO);
            }
        });
        this.levels.addAll(this.drops.keySet());
        this.levels.sort(null);
    }

    @Listener
    public void onBlockBreak(BreakBlockEvent e) {
        if (e.getBlock().getSkill() == this.skill && e.getTool() != null && e.getTool() == this.tool) {
            PlayerData pdata = super.getMMO().getPlayerDatabase().addExp(super.getMMO(), e.getPlayer(), this.skill, e.getBlock().getExp());
            int level = pdata.getLevel(this.skill);
            if (Abilities.DOUBLE_DROP.getChance(level)) {
                super.getMMO().getDoubleDrops().addDouble((World)e.getLocation().getExtent(), e.getLocation().getBlockPosition());
            }
            if (Abilities.TREASURE_HUNT.getChance(level)) {
                ItemUtils.drop(e.getLocation(), this.getDrop(level).createSnapshot());
            }
        }
    }

    @Nonnull
    private ItemStack getDrop(int level) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            int l = this.levels.get(i);
            if (level < l || !((Double)this.drops.get(l).getFirst() > Math.random() * 100.0)) continue;
            return ((ItemInfo)this.drops.get(l).getSecond()).create(super.getMMO());
        }
        return ItemStack.of((ItemType)ItemTypes.GLOWSTONE_DUST, (int)1);
    }
}

