/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.listeners.skills;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Abilities;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillTypes;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolTypes;
import me.mrdaniel.adventuremmo.io.Config;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import me.mrdaniel.adventuremmo.listeners.skills.ActiveAbilityListener;
import me.mrdaniel.adventuremmo.utils.ItemInfo;
import me.mrdaniel.adventuremmo.utils.ItemUtils;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.action.FishingEvent;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.Tuple;

public class FishingListener
extends ActiveAbilityListener {
    private final int fish_exp;
    private final boolean replace_default_loot;
    private final List<Integer> levels;
    private final Map<Integer, Tuple<Double, ItemInfo>> drops;

    public FishingListener(@Nonnull AdventureMMO mmo, @Nonnull Config config) {
        super(mmo, Abilities.FISH_FRENZY, SkillTypes.FISHING, ToolTypes.ROD, Tristate.UNDEFINED);
        this.fish_exp = config.getNode("skills", "fishing", "fish_exp").getInt(250);
        this.replace_default_loot = config.getNode("abilities", "watertreasure", "replace_default_loot").getBoolean(true);
        this.levels = Lists.newArrayList();
        this.drops = Maps.newHashMap();
        config.getNode("abilities", "watertreasure", "loot").getChildrenMap().forEach((typeO, node) -> {
            Optional type = mmo.getGame().getRegistry().getType(ItemType.class, (String)typeO);
            if (type.isPresent()) {
                this.drops.put(node.getNode(new Object[]{"lvl"}).getInt(0), (Tuple<Double, ItemInfo>)new Tuple((Object)node.getNode(new Object[]{"chance"}).getDouble(1.0), (Object)new ItemInfo((ItemType)type.get(), node.getNode(new Object[]{"min_amount"}).getInt(1), node.getNode(new Object[]{"max_amount"}).getInt(1), node.getNode(new Object[]{"min_damage"}).getInt(0), node.getNode(new Object[]{"max_damage"}).getInt(0), node.getNode(new Object[]{"enchanted"}).getBoolean(false))));
            } else {
                mmo.getLogger().error("Failed to find itemtype for: {}", typeO);
            }
        });
        this.levels.addAll(this.drops.keySet());
        this.levels.sort(null);
    }

    @Listener(order=Order.LATE)
    @IsCancelled(value=Tristate.FALSE)
    public void onFish(FishingEvent.Stop e, @Root Player player) {
        e.getTransactions().forEach(trans -> {
            PlayerData pdata = super.getMMO().getPlayerDatabase().addExp(super.getMMO(), player, this.skill, this.fish_exp);
            int level = pdata.getLevel(this.skill);
            ItemStack item = ((ItemStackSnapshot)trans.getFinal()).createStack();
            if (Abilities.WATER_TREASURE.getChance(level)) {
                item = this.getDrop(level);
            } else {
                if (this.replace_default_loot && item.getType() != ItemTypes.FISH) {
                    item = ItemStack.builder().itemType(ItemTypes.FISH).build();
                }
                if (Abilities.DOUBLE_DROP.getChance(level)) {
                    item.setQuantity(item.getQuantity() * 2);
                }
            }
            trans.setCustom((DataSerializable)item.createSnapshot());
        });
    }

    @Nonnull
    private ItemStack getDrop(int level) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            int l = this.levels.get(i);
            if (level < l || !((Double)this.drops.get(l).getFirst() > Math.random() * 100.0)) continue;
            return ((ItemInfo)this.drops.get(l).getSecond()).create(super.getMMO());
        }
        return ItemUtils.build(ItemTypes.DYE, (int)(Math.random() * 11.0) + 10, 4);
    }
}

