/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.listeners.skills;

import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Abilities;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillTypes;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolTypes;
import me.mrdaniel.adventuremmo.data.manipulators.MMOData;
import me.mrdaniel.adventuremmo.event.BreakBlockEvent;
import me.mrdaniel.adventuremmo.io.items.BlockData;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import me.mrdaniel.adventuremmo.listeners.skills.ActiveAbilityListener;
import me.mrdaniel.adventuremmo.utils.ItemUtils;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.type.TreeTypes;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class WoodcuttingListener
extends ActiveAbilityListener {
    public WoodcuttingListener(@Nonnull AdventureMMO mmo) {
        super(mmo, Abilities.TREE_FELLER, SkillTypes.WOODCUTTING, ToolTypes.AXE, Tristate.TRUE);
    }

    @Listener
    public void onBlockBreak(BreakBlockEvent e) {
        if (e.getBlock().getSkill() == this.skill && e.getTool() != null && e.getTool() == this.tool) {
            PlayerData pdata = super.getMMO().getPlayerDatabase().addExp(super.getMMO(), e.getPlayer(), this.skill, e.getBlock().getExp());
            if (Abilities.DOUBLE_DROP.getChance(pdata.getLevel(this.skill))) {
                super.getMMO().getDoubleDrops().addDouble((World)e.getLocation().getExtent(), e.getLocation().getBlockPosition());
            }
            if (e.getPlayer().get(MMOData.class).orElse(new MMOData()).isAbilityActive(this.ability.getId())) {
                Task.builder().delayTicks(2L).execute(() -> Lists.newArrayList((Object[])new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}).forEach(direction -> {
                    Location newloc = e.getLocation().getRelative(direction);
                    super.getMMO().getItemDatabase().getData(newloc.getBlockType()).ifPresent(blockdata -> {
                        if (blockdata.getSkill() == this.skill) {
                            ItemStackSnapshot item = ItemUtils.build((ItemType)newloc.getBlockType().getItem().get(), Abilities.DOUBLE_DROP.getChance(pdata.getLevel(this.skill)) ? 1 : 2, this.matchTree(newloc.getBlock().get(Keys.TREE_TYPE).orElse(TreeTypes.OAK))).createSnapshot();
                            newloc.setBlockType(BlockTypes.AIR, BlockChangeFlags.ALL);
                            ItemUtils.drop((Location<World>)newloc, item);
                            super.getGame().getEventManager().post((Event)new BreakBlockEvent(super.getMMO(), e.getPlayer(), (Location<World>)newloc, (BlockData)blockdata, this.tool));
                        }
                    });
                })).submit((Object)super.getMMO());
            }
        }
    }

    private int matchTree(@Nonnull TreeType type) {
        return type == TreeTypes.SPRUCE || type == TreeTypes.DARK_OAK ? 1 : (type == TreeTypes.BIRCH ? 2 : (type == TreeTypes.JUNGLE ? 3 : 0));
    }
}

