/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.managers;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.World;

public class DoubleDropManager {
    private final Map<World, Map<Vector3i, Integer>> blocks = Maps.newHashMap();

    public DoubleDropManager(@Nonnull AdventureMMO mmo) {
        Task.builder().delayTicks(10L).intervalTicks(1L).execute(() -> this.blocks.values().forEach(Map::clear)).submit((Object)mmo);
        mmo.getGame().getServer().getWorlds().forEach(w -> this.blocks.put((World)w, Maps.newHashMap()));
    }

    public void addDouble(@Nonnull World world, @Nonnull Vector3i pos) {
        this.blocks.get(world).put(pos, 2);
    }

    public void addTriple(@Nonnull World world, @Nonnull Vector3i pos) {
        this.blocks.get(world).put(pos, 3);
    }

    @Listener
    @IsCancelled(value=Tristate.FALSE)
    public void onWorldLoad(LoadWorldEvent e) {
        this.blocks.put(e.getTargetWorld(), Maps.newHashMap());
    }

    @Listener
    @IsCancelled(value=Tristate.FALSE)
    public void onWorldUnload(UnloadWorldEvent e) {
        this.blocks.remove(e.getTargetWorld());
    }

    @Listener(order=Order.LATE)
    @IsCancelled(value=Tristate.FALSE)
    public void onItemDrop(DropItemEvent.Destruct e) {
        e.getEntities().stream().filter(ent -> ent instanceof Item).map(ent -> (Item)ent).forEach(item -> Optional.ofNullable(this.blocks.get(item.getWorld()).get(item.getLocation().getBlockPosition())).ifPresent(times -> {
            ItemStack is = ((ItemStackSnapshot)item.item().get()).createStack();
            is.setQuantity(is.getQuantity() * times);
            item.offer(Keys.REPRESENTED_ITEM, (Object)is.createSnapshot());
        }));
    }
}

