/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.managers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Ability;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillTypes;
import me.mrdaniel.adventuremmo.data.manipulators.MMOData;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import me.mrdaniel.adventuremmo.managers.ScoreboardManager;
import me.mrdaniel.adventuremmo.utils.MathUtils;
import me.mrdaniel.adventuremmo.utils.TextUtils;
import me.mrdaniel.adventuremmo.utils.Texts;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tuple;

public class MenuManager {
    private final ScoreboardManager scoreboards;
    private int i;

    public MenuManager(@Nonnull AdventureMMO mmo) {
        this.scoreboards = new ScoreboardManager(mmo);
        this.i = 0;
    }

    public void sendAdminView(@Nonnull MessageReceiver src, @Nonnull PlayerData data, @Nonnull String name) {
        src.sendMessage(Text.EMPTY);
        src.sendMessage(this.getTitle(name, false));
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, "Total", TextColors.GRAY, " - ", TextColors.GREEN, "Level ", data.getLevels()}));
        SkillTypes.VALUES.forEach(skill -> src.sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, skill.getName(), TextColors.GRAY, " - ", TextColors.GREEN, "Level ", data.getLevel((SkillType)skill)})));
        src.sendMessage(Text.EMPTY);
    }

    public void sendSkillList(@Nonnull Player p) {
        PlayerData pData = this.scoreboards.getMMO().getPlayerDatabase().get(p.getUniqueId());
        MMOData sData = p.get(MMOData.class).orElse(new MMOData());
        if (sData.getScoreboard()) {
            if (sData.getScoreboardPermanent()) {
                this.scoreboards.setRepeating(p, this.getTitle("Skills", true), this::getSkillListLines);
            } else {
                this.scoreboards.setTemp(p, this.getTitle("Skills", true), this.getSkillListLines(pData));
            }
        } else {
            String title = "&d&lSkills";
            ArrayList<Text> contents = new ArrayList<Text>();
            contents.add(Texts.of("&7- &fTotal&7: &d" + pData.getLevels()));
            SkillTypes.VALUES.forEach(skill -> contents.add(Text.builder().append(new Text[]{Texts.of("&7- &f" + skill.getName() + "&7: &d" + pData.getLevel((SkillType)skill))}).onHover((HoverAction)TextActions.showText((Text)Texts.of("&dClick here for more info!"))).onClick((ClickAction)TextActions.runCommand((String)("/skill " + skill.getId()))).build()));
            PaginationList.builder().title(Texts.of(title)).padding(Texts.of("&8&m-")).contents(contents).build().sendTo((MessageReceiver)p);
        }
    }

    public void sendSkillInfo(@Nonnull Player p, @Nonnull SkillType skill) {
        PlayerData pData = this.scoreboards.getMMO().getPlayerDatabase().get(p.getUniqueId());
        MMOData sData = p.get(MMOData.class).orElse(new MMOData());
        if (sData.getScoreboard()) {
            if (sData.getScoreboardPermanent()) {
                this.scoreboards.setRepeating(p, this.getTitle(skill.getName(), true), data -> this.getSkillInfoLines((PlayerData)data, skill));
            } else {
                this.scoreboards.setTemp(p, this.getTitle(skill.getName(), true), this.getSkillInfoLines(pData, skill));
            }
        } else {
            String title = "&d&l" + skill.getName() + " &f&lInfo";
            ArrayList<Text> contents = new ArrayList<Text>();
            contents.add(Texts.of("&7- &fLevel&7: &d" + pData.getLevel(skill)));
            contents.add(Texts.of("&7- &fEXP&7: &d" + pData.getExp(skill)));
            contents.add(Text.EMPTY);
            contents.add(Texts.of("&7- &dAbilities&7:"));
            skill.getAbilities().forEach(ability -> {
                contents.add(Texts.of(" &7* &f" + ability.getName() + "&7:"));
                contents.add(Texts.of("  &7\u2022 &f" + ability.getValueLine(pData.getLevel(skill))));
            });
            PaginationList.builder().title(Texts.of(title)).padding(Texts.of("&8&m-")).contents(contents).build().sendTo((MessageReceiver)p);
        }
    }

    public void sendSkillTop(@Nonnull Player p, @Nullable SkillType type) {
        MMOData sData = p.get(MMOData.class).orElse(new MMOData());
        if (sData.getScoreboard()) {
            String title;
            String string = title = type == null ? "&d&lTotal Top" : "&d&l" + type.getName() + " Top";
            if (sData.getScoreboardPermanent()) {
                this.scoreboards.setRepeating(p, this.getTitle(title, true), data -> this.getSkillTopLines(type));
            } else {
                this.scoreboards.setTemp(p, this.getTitle(title, true), this.getSkillTopLines(type));
            }
        } else {
            String title = type == null ? "&d&lMCMMO &7&l- &f&lAverage Top" : "&d&lMCMMO &7&l- &f&l" + type.getName() + " Top";
            ArrayList contents = new ArrayList();
            this.scoreboards.getMMO().getTops().getTop(type).forEach((number, player) -> {
                if (!((String)player.getFirst()).isEmpty()) {
                    contents.add(Texts.of("&7" + number + ". &d" + (String)player.getFirst() + " &7- &fLevel &d" + player.getSecond()));
                }
            });
            PaginationList.builder().title(Texts.of(title)).padding(Texts.of("&8&m-")).contents(contents).build().sendTo((MessageReceiver)p);
        }
    }

    public void sendSettingsInfo(@Nonnull Player p) {
        MMOData data = p.get(MMOData.class).orElse(new MMOData());
        p.sendMessage(Text.EMPTY);
        p.sendMessage(this.getTitle("Settings", false));
        p.sendMessage(Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "Action Bar: ", TextUtils.getValueText(data.getActionBar())})}).onHover((HoverAction)TextActions.showText((Text)TextUtils.getToggleText(data.getActionBar()))).onClick((ClickAction)TextActions.executeCallback(src -> {
            data.setActionBar(!data.getActionBar());
            p.offer((ValueContainer)data);
            this.sendSettingsInfo((Player)src);
        })).build());
        p.sendMessage(Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "Scoreboard: ", TextUtils.getValueText(data.getScoreboard())})}).onHover((HoverAction)TextActions.showText((Text)TextUtils.getToggleText(data.getScoreboard()))).onClick((ClickAction)TextActions.executeCallback(src -> {
            data.setScoreboard(!data.getScoreboard());
            p.offer((ValueContainer)data);
            this.sendSettingsInfo((Player)src);
            this.scoreboards.unload(p);
        })).build());
        p.sendMessage(Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "Scoreboard Permanent: ", TextUtils.getValueText(data.getScoreboardPermanent())})}).onHover((HoverAction)TextActions.showText((Text)TextUtils.getToggleText(data.getScoreboardPermanent()))).onClick((ClickAction)TextActions.executeCallback(src -> {
            data.setScoreboardPermanent(!data.getScoreboardPermanent());
            p.offer((ValueContainer)data);
            this.sendSettingsInfo((Player)src);
            this.scoreboards.unload(p);
        })).build());
        p.sendMessage(Text.EMPTY);
    }

    @Nonnull
    private Multimap<Integer, Text> getSkillListLines(@Nonnull PlayerData data) {
        ArrayListMultimap lines = ArrayListMultimap.create();
        SkillTypes.VALUES.forEach(arg_0 -> MenuManager.lambda$getSkillListLines$9((Multimap)lines, data, arg_0));
        lines.put((Object)data.getLevels(), (Object)Text.of((Object[])new Object[]{TextColors.GREEN, "Total", TextColors.GRAY, " - "}));
        return lines;
    }

    @Nonnull
    private Multimap<Integer, Text> getSkillInfoLines(@Nonnull PlayerData data, @Nonnull SkillType skill) {
        ArrayListMultimap lines = ArrayListMultimap.create();
        int i = 1;
        for (Ability ability : skill.getAbilities()) {
            lines.put((Object)i++, (Object)Texts.of(ability.getValueLine(data.getLevel(skill))));
            lines.put((Object)i++, (Object)this.getBoardTitle(ability.getName(), true));
            lines.put((Object)i++, (Object)this.getEmptyLine());
        }
        lines.put((Object)i++, (Object)Text.of((Object[])new Object[]{TextColors.GREEN, "EXP: ", data.getExp(skill), " / ", MathUtils.expTillNextLevel(data.getLevel(skill))}));
        lines.put((Object)i++, (Object)Text.of((Object[])new Object[]{TextColors.GREEN, "Level: ", data.getLevel(skill)}));
        return lines;
    }

    @Nonnull
    private Multimap<Integer, Text> getSkillTopLines(@Nullable SkillType type) {
        ArrayListMultimap lines = ArrayListMultimap.create();
        this.scoreboards.getMMO().getTops().getTop(type).forEach((arg_0, arg_1) -> MenuManager.lambda$getSkillTopLines$10((Multimap)lines, arg_0, arg_1));
        return lines;
    }

    @Nonnull
    private Text getTitle(@Nonnull String txt, boolean small) {
        return small ? Text.of((Object[])new Object[]{TextColors.RED, "--=[ ", TextColors.AQUA, txt, TextColors.RED, " ]=--"}) : Text.of((Object[])new Object[]{TextColors.RED, "----===[ ", TextColors.AQUA, txt, TextColors.RED, " ]===---"});
    }

    @Nonnull
    private Text getBoardTitle(@Nonnull String txt, boolean small) {
        return small ? Text.of((Object[])new Object[]{TextColors.RED, "-=[ ", TextColors.DARK_GREEN, txt, TextColors.RED, " ]=-"}) : Text.of((Object[])new Object[]{TextColors.RED, "---==[ ", TextColors.AQUA, txt, TextColors.RED, " ]==---"});
    }

    @Nonnull
    private Text getEmptyLine() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.i; ++i) {
            str.append(" ");
        }
        if (this.i++ > 8) {
            this.i = 0;
        }
        return Text.of((String)str.toString());
    }

    @Nonnull
    public ScoreboardManager getScoreboardManager() {
        return this.scoreboards;
    }

    private static /* synthetic */ void lambda$getSkillTopLines$10(Multimap lines, Integer number, Tuple player) {
        lines.put(player.getSecond(), (Object)Text.of((Object[])new Object[]{TextColors.GRAY, player.getFirst()}));
    }

    private static /* synthetic */ void lambda$getSkillListLines$9(Multimap lines, PlayerData data, SkillType type) {
        lines.put((Object)data.getLevel(type), (Object)Text.of((Object[])new Object[]{TextColors.AQUA, type.getName(), TextColors.GRAY, " - "}));
    }
}

