/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.managers;

import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.MMOObject;
import me.mrdaniel.adventuremmo.catalogtypes.abilities.Ability;
import me.mrdaniel.adventuremmo.catalogtypes.skills.SkillType;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolType;
import me.mrdaniel.adventuremmo.data.manipulators.MMOData;
import me.mrdaniel.adventuremmo.utils.TextUtils;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;

public class MessageManager
extends MMOObject {
    private final int delay_seconds;
    private final Text dodge;
    private final Text roll;
    private final Text disarm;
    private final Text reload;
    private final String set;
    private final String setitem;
    private final String clearitem;
    private final String setblock;
    private final String clearblock;
    private final String levelup;
    private final String ability_recharge;
    private final String ability_activate;
    private final String ability_end;

    public MessageManager(@Nonnull AdventureMMO mmo, @Nonnull ConfigurationNode node) {
        super(mmo);
        this.delay_seconds = node.getNode(new Object[]{"seconds_between_messages"}).getInt(5);
        String prefix = node.getNode(new Object[]{"prefix"}).getString("&8[&9MMO&8]");
        if (!prefix.equals("")) {
            prefix = prefix + " ";
        }
        this.dodge = TextUtils.toText(prefix + node.getNode(new Object[]{"dodge"}).getString(""));
        this.roll = TextUtils.toText(prefix + node.getNode(new Object[]{"roll"}).getString(""));
        this.disarm = TextUtils.toText(prefix + node.getNode(new Object[]{"disarm"}).getString(""));
        this.reload = TextUtils.toText(prefix + "&cReloaded successfully.");
        this.set = prefix + "&aYou set %player%'s %skill% level to %level%";
        this.setitem = prefix + "&aYou allowed %item% to be used as a(n) %tool%.";
        this.clearitem = prefix + "&aYou removed %item% from the tool list.";
        this.setblock = prefix + "&aYou set %block% to give %exp% exp to the %skill% skill when broken.";
        this.clearblock = prefix + "&aYou removed %block% from the block list.";
        this.levelup = prefix + node.getNode(new Object[]{"levelup"}).getString("");
        this.ability_recharge = prefix + node.getNode(new Object[]{"ability_recharge"}).getString("");
        this.ability_activate = prefix + node.getNode(new Object[]{"ability_activate"}).getString("");
        this.ability_end = prefix + node.getNode(new Object[]{"ability_end"}).getString("");
    }

    public void sendDodge(@Nonnull Player p) {
        this.send(p, this.dodge, p.get(MMOData.class).orElse(new MMOData()));
    }

    public void sendRoll(@Nonnull Player p) {
        this.send(p, this.roll, p.get(MMOData.class).orElse(new MMOData()));
    }

    public void sendDisarm(@Nonnull Player p) {
        this.send(p, this.disarm, p.get(MMOData.class).orElse(new MMOData()));
    }

    public void sendLevelUp(@Nonnull Player p, @Nonnull SkillType skill, int level) {
        this.send(p, TextUtils.toText(this.levelup.replace("%skill%", skill.getName()).replace("%level%", String.valueOf(level))), p.get(MMOData.class).orElse(new MMOData()));
    }

    public void sendAbilityRecharge(@Nonnull Player p, int seconds) {
        this.sendDelayed(p, TextUtils.toText(this.ability_recharge.replace("%seconds%", String.valueOf(seconds))), p.get(MMOData.class).orElse(new MMOData()));
    }

    public void sendAbilityActivate(@Nonnull Player p, @Nonnull Ability ability) {
        this.send(p, TextUtils.toText(this.ability_activate.replace("%ability%", ability.getName())), p.get(MMOData.class).orElse(new MMOData()));
    }

    public void sendAbilityEnd(@Nonnull Player p, @Nonnull Ability ability) {
        this.send(p, TextUtils.toText(this.ability_end.replace("%ability%", ability.getName())), p.get(MMOData.class).orElse(new MMOData()));
    }

    public void sendReload(@Nonnull CommandSource src) {
        src.sendMessage(this.reload);
    }

    public void sendSet(@Nonnull CommandSource src, @Nonnull String player, @Nonnull SkillType skill, int level) {
        src.sendMessage(TextUtils.toText(this.set.replace("%player%", player).replace("%skill%", skill.getName()).replace("%level%", String.valueOf(level))));
    }

    public void sendItemSet(@Nonnull Player p, @Nonnull ItemType item, @Nonnull ToolType tool) {
        p.sendMessage(TextUtils.toText(this.setitem.replace("%item%", item.getName()).replace("%tool%", tool.getName())));
    }

    public void sendItemClear(@Nonnull Player p, @Nonnull ItemType item) {
        p.sendMessage(TextUtils.toText(this.clearitem.replace("%item%", item.getName())));
    }

    public void sendBlockSet(@Nonnull Player p, @Nonnull BlockType block, @Nonnull SkillType skill, int exp) {
        p.sendMessage(TextUtils.toText(this.setblock.replace("%block%", block.getName()).replace("%skill%", skill.getName()).replace("%exp%", String.valueOf(exp))));
    }

    public void sendBlockClear(@Nonnull Player p, @Nonnull BlockType block) {
        p.sendMessage(TextUtils.toText(this.clearblock.replace("%block%", block.getName())));
    }

    private void sendDelayed(@Nonnull Player p, @Nonnull Text txt, @Nonnull MMOData data) {
        if (!data.isDelayActive("message_delay")) {
            this.send(p, txt, data);
        }
    }

    private void send(@Nonnull Player p, @Nonnull Text txt, @Nonnull MMOData data) {
        p.sendMessage(data.getActionBar() ? ChatTypes.ACTION_BAR : ChatTypes.CHAT, txt);
        data.setDelay("message_delay", System.currentTimeMillis() + (long)(this.delay_seconds * 1000));
        p.offer((ValueContainer)data);
    }
}

