/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.managers;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.MMOObject;
import me.mrdaniel.adventuremmo.io.playerdata.PlayerData;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.critieria.Criteria;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.text.Text;

public class ScoreboardManager
extends MMOObject {
    private final Map<UUID, Task> tasks = Maps.newHashMap();

    public ScoreboardManager(@Nonnull AdventureMMO mmo) {
        super(mmo);
    }

    public void setTemp(@Nonnull Player p, @Nonnull Text title, @Nonnull Multimap<Integer, Text> lines) {
        this.unload(p);
        this.set(p, title, lines);
        this.tasks.put(p.getUniqueId(), Task.builder().delayTicks(300L).execute(() -> this.unload(p)).submit((Object)super.getMMO()));
    }

    public void setRepeating(@Nonnull Player p, @Nonnull Text title, @Nonnull Function<PlayerData, Multimap<Integer, Text>> function) {
        this.unload(p);
        this.tasks.put(p.getUniqueId(), Task.builder().delayTicks(0L).intervalTicks(100L).execute(t -> this.set(p, title, (Multimap<Integer, Text>)((Multimap)function.apply(super.getMMO().getPlayerDatabase().get(p.getUniqueId()))))).submit((Object)super.getMMO()));
    }

    private void set(@Nonnull Player p, @Nonnull Text title, @Nonnull Multimap<Integer, Text> lines) {
        Scoreboard board = Scoreboard.builder().build();
        Objective obj = Objective.builder().name("mmo_board").criterion(Criteria.DUMMY).displayName(title).build();
        lines.asMap().forEach((line, txts) -> txts.forEach(txt -> obj.getOrCreateScore(txt).setScore(line.intValue())));
        board.addObjective(obj);
        p.setScoreboard(board);
        board.updateDisplaySlot(obj, DisplaySlots.SIDEBAR);
    }

    public void unload(@Nonnull Player p) {
        Optional.ofNullable(this.tasks.get(p.getUniqueId())).ifPresent(t -> {
            t.cancel();
            this.tasks.remove(p.getUniqueId());
        });
        p.getScoreboard().clearSlot(DisplaySlots.SIDEBAR);
    }
}

