/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import me.mrdaniel.adventuremmo.AdventureMMO;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolType;
import me.mrdaniel.adventuremmo.catalogtypes.tools.ToolTypes;
import me.mrdaniel.adventuremmo.data.manipulators.SuperToolData;
import me.mrdaniel.adventuremmo.utils.MathUtils;
import me.mrdaniel.adventuremmo.utils.TextUtils;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.data.type.SkullType;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.enchantment.EnchantmentTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ItemUtils {
    @Nonnull
    public static ItemStack build(@Nonnull ItemType type, int amount, int unsafe) {
        return ItemStack.builder().fromContainer((DataView)DataContainer.createNew().set(DataQuery.of((String[])new String[]{"ItemType"}), (Object)type).set(DataQuery.of((String[])new String[]{"Count"}), (Object)amount).set(DataQuery.of((String[])new String[]{"UnsafeDamage"}), (Object)unsafe)).build();
    }

    @Nonnull
    public static Entity drop(@Nonnull Location<World> loc, @Nonnull ItemStackSnapshot item) {
        Entity e = loc.createEntity(EntityTypes.ITEM);
        e.offer(Keys.REPRESENTED_ITEM, (Object)item);
        e.offer(Keys.PICKUP_DELAY, (Object)10);
        ((World)loc.getExtent()).spawnEntity(e);
        return e;
    }

    @Nonnull
    public static Optional<ItemStack> getHead(@Nonnull EntityType type) {
        SkullType skull;
        ItemStack item = ItemStack.builder().itemType(ItemTypes.SKULL).quantity(1).build();
        if (type == EntityTypes.ZOMBIE) {
            skull = SkullTypes.ZOMBIE;
        } else if (type == EntityTypes.SKELETON) {
            skull = SkullTypes.SKELETON;
        } else if (type == EntityTypes.CREEPER) {
            skull = SkullTypes.CREEPER;
        } else if (type == EntityTypes.WITHER_SKELETON) {
            skull = SkullTypes.WITHER_SKELETON;
        } else if (type == EntityTypes.ENDER_DRAGON) {
            skull = SkullTypes.ENDER_DRAGON;
        } else {
            return Optional.empty();
        }
        item.offer(Keys.SKULL_TYPE, (Object)skull);
        return Optional.of(item);
    }

    @Nonnull
    public static ItemStack getPlayerHead(@Nonnull Player p) {
        return ItemStack.builder().itemType(ItemTypes.SKULL).add(Keys.SKULL_TYPE, (Object)SkullTypes.PLAYER).add(Keys.REPRESENTED_PLAYER, (Object)p.getProfile()).build();
    }

    public static void giveSuperTool(@Nonnull Player p, @Nonnull ToolType tool) {
        ItemStack item = (ItemStack)p.getItemInHand(HandTypes.MAIN_HAND).get();
        item.offer((ValueContainer)new SuperToolData(item.get(Keys.ITEM_ENCHANTMENTS).orElse(Lists.newArrayList()), TextUtils.toString((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)""))), item.get(Keys.ITEM_DURABILITY).orElse(0)));
        item.offer(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextColors.RED, TextStyles.BOLD, "Super ", tool.getName()}));
        item.offer(Keys.UNBREAKABLE, (Object)true);
        boolean rod = tool == ToolTypes.ROD;
        int lvl = rod ? 3 : 5;
        int max_lvl = rod ? 5 : 10;
        EnchantmentType type = rod ? EnchantmentTypes.LURE : EnchantmentTypes.EFFICIENCY;
        List ench = item.get(Keys.ITEM_ENCHANTMENTS).orElse(Lists.newArrayList());
        for (Enchantment enchant : ench) {
            if (enchant.getType() != type) continue;
            lvl += enchant.getLevel();
            ench.remove(enchant);
            break;
        }
        ench.add(Enchantment.of((EnchantmentType)type, (int)MathUtils.between(lvl, 1, max_lvl)));
        item.offer(Keys.ITEM_ENCHANTMENTS, (Object)ench);
        p.setItemInHand(HandTypes.MAIN_HAND, item);
    }

    public static void restoreSuperTool(@Nonnull Player p, @Nonnull PluginContainer container) {
        p.closeInventory();
        p.getInventory().slots().forEach(slot -> slot.peek().ifPresent(item -> item.get(SuperToolData.class).ifPresent(data -> slot.set(data.restore((ItemStack)item)))));
    }

    @Nonnull
    public static ItemStack enchant(@Nonnull AdventureMMO mmo, @Nonnull ItemStack item) {
        ArrayList enchants = Lists.newArrayList();
        mmo.getGame().getRegistry().getAllOf(EnchantmentType.class).forEach(ench -> {
            if (Math.random() > 0.9 && ench.canBeAppliedByTable(item)) {
                enchants.add(Enchantment.of((EnchantmentType)ench, (int)((int)(Math.random() * (double)ench.getMaximumLevel()) + 1)));
            }
        });
        item.offer(Keys.ITEM_ENCHANTMENTS, (Object)enchants);
        return item;
    }

    public static void doAxeDurabilityReduction(ItemStack stack, int reduceAmount) {
        if (stack.get(Keys.ITEM_DURABILITY).isPresent()) {
            if (stack.get(Keys.ITEM_ENCHANTMENTS).isPresent() && ((List)stack.get(Keys.ITEM_ENCHANTMENTS).get()).stream().anyMatch(enchantment -> enchantment.getType().equals(EnchantmentTypes.UNBREAKING))) {
                int enchLevel = ((List)stack.get(Keys.ITEM_ENCHANTMENTS).get()).stream().filter(enchantment -> enchantment.getType().equals(EnchantmentTypes.UNBREAKING)).findFirst().get().getLevel();
                for (int i = 0; i < reduceAmount; ++i) {
                    Random random = new Random();
                    if (!(random.nextFloat() > (60.0f + 40.0f / ((float)enchLevel + 1.0f)) / 100.0f)) continue;
                    --reduceAmount;
                }
            }
            stack.offer(Keys.ITEM_DURABILITY, (Object)((Integer)stack.get(Keys.ITEM_DURABILITY).get() - reduceAmount));
        }
    }
}

