/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.utils;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ServerUtils {
    public static void broadcast(@Nonnull Server server, @Nonnull Text message) {
        server.getOnlinePlayers().forEach(p -> p.sendMessage(message));
    }

    @Nonnull
    public static Optional<Location<World>> getFirstBlock(@Nonnull Player p) {
        for (BlockRayHit worldBlockRayHit : BlockRay.from((Entity)p).distanceLimit(50.0)) {
            Location loc = worldBlockRayHit.getLocation();
            if (loc.getBlockType() == BlockTypes.AIR) continue;
            return Optional.of(loc);
        }
        return Optional.empty();
    }
}

