/*
 * Decompiled with CFR 0.152.
 */
package me.mrdaniel.adventuremmo.utils;

import javax.annotation.Nonnull;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;

public class TextUtils {
    @Nonnull
    public static Text toText(@Nonnull String text) {
        return TextSerializers.formattingCode((char)'&').deserialize(text);
    }

    @Nonnull
    public static String toString(@Nonnull Text text) {
        return TextSerializers.formattingCode((char)'&').serialize(text);
    }

    @Nonnull
    public static Text getCommandText(@Nonnull Text msg, @Nonnull Text hover, @Nonnull String cmd) {
        return Text.builder().append(new Text[]{msg}).onHover((HoverAction)TextActions.showText((Text)hover)).onClick((ClickAction)TextActions.runCommand((String)cmd)).build();
    }

    @Nonnull
    public static TextColor getColor(boolean value) {
        return value ? TextColors.GREEN : TextColors.RED;
    }

    @Nonnull
    public static Text getValueText(boolean value) {
        return value ? Text.of((Object[])new Object[]{TextColors.GREEN, "Enabled"}) : Text.of((Object[])new Object[]{TextColors.RED, "Disabled"});
    }

    @Nonnull
    public static Text getToggleText(boolean value) {
        return value ? Text.of((Object[])new Object[]{TextColors.RED, "Disable"}) : Text.of((Object[])new Object[]{TextColors.GREEN, "Enable"});
    }
}

