/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.blocks;

import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.MoreFurnaces;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockMoreFurnaces
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<FurnaceType> VARIANT = PropertyEnum.func_177709_a((String)"variant", FurnaceType.class);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockMoreFurnaces() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)FurnaceType.IRON)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("furnaceblock");
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public Block func_149663_c(String name) {
        super.func_149663_c(name);
        this.setRegistryName("morefurnaces", name);
        return this;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)FurnaceType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((FurnaceType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listed = new IProperty[]{VARIANT, FACING, ACTIVE};
        return new BlockStateContainer((Block)this, listed);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = EnumFacing.NORTH;
        boolean active = false;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronFurnace) {
            TileEntityIronFurnace furnace = (TileEntityIronFurnace)te;
            facing = EnumFacing.func_82600_a((int)furnace.getFacing());
            if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                facing = EnumFacing.NORTH;
            }
            active = furnace.isActive();
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return FurnaceType.makeEntity(meta);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronFurnace) {
            return ((TileEntityIronFurnace)te).isActive() ? 12 : 0;
        }
        return 0;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultDirection(world, pos, state);
    }

    private void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof TileEntityIronFurnace) {
                enumfacing = EnumFacing.func_82600_a((int)((TileEntityIronFurnace)te).getFacing());
            }
            IBlockState iblockstate = world.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = world.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = world.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = world.func_180495_p(pos.func_177974_f());
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            if (te != null && te instanceof TileEntityIronFurnace) {
                ((TileEntityIronFurnace)te).setFacing((byte)enumfacing.ordinal());
                world.func_184138_a(pos, state, state, 3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        TileEntityIronFurnace tef;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronFurnace && (tef = (TileEntityIronFurnace)te).isActive()) {
            byte facing = tef.getFacing();
            float x = (float)pos.func_177958_n() + 0.5f;
            float y = (float)pos.func_177956_o() + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float z = (float)pos.func_177952_p() + 0.5f;
            float var10 = 0.52f;
            float var11 = random.nextFloat() * 0.6f - 0.3f;
            if (facing == 4) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(x - var10), (double)y, (double)(z + var11), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(x - var10), (double)y, (double)(z + var11), 0.0, 0.0, 0.0, new int[0]);
            } else if (facing == 5) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(x + var10), (double)y, (double)(z + var11), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(x + var10), (double)y, (double)(z + var11), 0.0, 0.0, 0.0, new int[0]);
            } else if (facing == 2) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(x + var11), (double)y, (double)(z - var10), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(x + var11), (double)y, (double)(z - var10), 0.0, 0.0, 0.0, new int[0]);
            } else if (facing == 3) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(x + var11), (double)y, (double)(z + var10), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(x + var11), (double)y, (double)(z + var10), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float f1, float f2, float f3) {
        FurnaceType type = (FurnaceType)((Object)state.func_177229_b(VARIANT));
        if (type == FurnaceType.NETHERRACK && facing == EnumFacing.UP) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityIronFurnace)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)MoreFurnaces.instance, ((TileEntityIronFurnace)te).getType().ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        EnumFacing facing = living.func_174811_aO().func_176734_d();
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronFurnace) {
            ((TileEntityIronFurnace)te).setFacing((byte)facing.ordinal());
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIronFurnace) {
            ((TileEntityIronFurnace)te).getItemHandler().dropAllItems(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        for (FurnaceType type : FurnaceType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        FurnaceType type = (FurnaceType)((Object)world.func_180495_p(pos).func_177229_b(VARIANT));
        return type == FurnaceType.NETHERRACK && side == EnumFacing.UP;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }
}

