/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.inventory;

import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.inventory.ItemHandlerMoveStacks;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemHandlerFurnace
extends ItemStackHandler {
    private final TileEntityIronFurnace tile;
    private final FurnaceType type;
    private final ItemHandlerMoveStacks[] inputHandlers;
    private final ItemHandlerMoveStacks[] outputHandlers;
    private final IItemHandlerModifiable fuelHandler;
    private final IItemHandlerModifiable bottomSideHandler;
    private final IItemHandlerModifiable topSideHandler;
    private final IItemHandlerModifiable sidesSideHandler;
    public boolean slotChecksEnabled = true;

    public ItemHandlerFurnace(TileEntityIronFurnace tile) {
        super(tile.getType().getNumSlots());
        this.tile = tile;
        this.type = tile.getType();
        this.fuelHandler = this.type.fuelSlots > 0 ? new ItemHandlerMoveStacks(this, this.type.getFirstFuelSlot(), this.type.getLastFuelSlot(), 0) : new EmptyHandler();
        this.inputHandlers = new ItemHandlerMoveStacks[this.type.parallelSmelting];
        this.outputHandlers = new ItemHandlerMoveStacks[this.type.parallelSmelting];
        for (int i = 0; i < this.type.parallelSmelting; ++i) {
            this.inputHandlers[i] = new ItemHandlerMoveStacks(this, this.type.getFirstInputSlot(i), this.type.getLastInputSlot(i), 0);
            int firstOutput = this.type.getFirstOutputSlot(i);
            int lastOutput = this.type.getLastOutputSlot(i);
            this.outputHandlers[i] = new ItemHandlerMoveStacks(this, firstOutput, lastOutput, this.range(1, lastOutput - firstOutput + 1));
        }
        this.bottomSideHandler = this.createBottomSideHandler();
        this.topSideHandler = new CombinedInvWrapper((IItemHandlerModifiable[])this.inputHandlers);
        this.sidesSideHandler = this.fuelHandler;
    }

    private CombinedInvWrapper createBottomSideHandler() {
        IItemHandlerModifiable[] handlers = new IItemHandlerModifiable[this.outputHandlers.length + 1];
        System.arraycopy(this.outputHandlers, 0, handlers, 0, this.outputHandlers.length);
        handlers[handlers.length - 1] = this.fuelHandler;
        return new CombinedInvWrapper(handlers);
    }

    private int[] range(int min, int max) {
        if (min > max) {
            return new int[0];
        }
        int[] range = new int[max - min + 1];
        for (int i = 0; i < range.length; ++i) {
            range[i] = min + i;
        }
        return range;
    }

    public IItemHandlerModifiable getHandlerForSide(@Nonnull EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return this.bottomSideHandler;
        }
        if (facing == EnumFacing.UP) {
            return this.topSideHandler;
        }
        return this.sidesSideHandler;
    }

    public void moveFuelStacks() {
        if (this.fuelHandler instanceof ItemHandlerMoveStacks) {
            ((ItemHandlerMoveStacks)this.fuelHandler).moveStacks();
        }
    }

    public void moveInputStacks() {
        Arrays.stream(this.inputHandlers).forEach(ItemHandlerMoveStacks::moveStacks);
    }

    public void moveOutputStacks() {
        Arrays.stream(this.outputHandlers).forEach(ItemHandlerMoveStacks::moveStacks);
    }

    public ItemHandlerMoveStacks[] getInputHandlers() {
        return this.inputHandlers;
    }

    public ItemHandlerMoveStacks[] getOutputHandlers() {
        return this.outputHandlers;
    }

    public IItemHandlerModifiable getFuelHandler() {
        return this.fuelHandler;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.isStackValidForSlot(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    private boolean isStackValidForSlot(int index, @Nonnull ItemStack stack) {
        if (!this.slotChecksEnabled) {
            return true;
        }
        if (this.type.isOutputSlot(index)) {
            return false;
        }
        if (this.type.isInputSlot(index)) {
            return true;
        }
        return TileEntityFurnace.func_145954_b((ItemStack)stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Item item;
        if (this.slotChecksEnabled && this.type.isFuelSlot(slot) && (item = this.getStackInSlot(slot).func_77973_b()) != Items.field_151131_as && item != Items.field_151133_ar) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.tile.func_70296_d();
    }

    public void dropAllItems(World world, double x, double y, double z) {
        CombinedInvWrapper inv = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.bottomSideHandler, this.topSideHandler, this.sidesSideHandler});
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.extractItem(i, 64, false);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)stack);
        }
    }
}

