/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.components.RegionLocation;
import com.universeguard.region.enums.RegionPoint;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.InventoryUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionLocationUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class EventRegionSelect {
    @Listener
    public void onRightClick(InteractBlockEvent.Primary.MainHand event) {
        this.setPoint(RegionPoint.PRIMARY, HandTypes.MAIN_HAND, (InteractBlockEvent)event);
    }

    @Listener
    public void onRightClick(InteractBlockEvent.Primary.OffHand event) {
        this.setPoint(RegionPoint.PRIMARY, HandTypes.OFF_HAND, (InteractBlockEvent)event);
    }

    @Listener
    public void onRightClick(InteractBlockEvent.Secondary.MainHand event) {
        this.setPoint(RegionPoint.SECONDARY, HandTypes.MAIN_HAND, (InteractBlockEvent)event);
    }

    @Listener
    public void onRightClick(InteractBlockEvent.Secondary.OffHand event) {
        this.setPoint(RegionPoint.SECONDARY, HandTypes.OFF_HAND, (InteractBlockEvent)event);
    }

    private void setPoint(RegionPoint point, HandType hand, InteractBlockEvent event) {
        ItemStack itemStack;
        Player player;
        if (event.getCause().last(Player.class).isPresent() && (player = (Player)event.getCause().last(Player.class).get()).getItemInHand(hand).isPresent() && InventoryUtils.isSelector(itemStack = (ItemStack)player.getItemInHand(hand).get())) {
            event.setCancelled(true);
            if (PermissionUtils.hasAllPermissions(player)) {
                BlockSnapshot block = event.getTargetBlock();
                BlockType blockType = block.getState().getType();
                RegionLocation location = null;
                location = blockType.equals(BlockTypes.AIR) ? RegionLocationUtils.fromLocation(player, (Location<World>)player.getLocation()) : RegionLocationUtils.fromLocation(player, (Location<World>)((Location)block.getLocation().get()));
                LocalRegion region = null;
                if (!RegionUtils.hasPendingRegion(player)) {
                    region = new LocalRegion("");
                } else {
                    region = (LocalRegion)RegionUtils.getPendingRegion(player);
                    RegionUtils.setPendingRegion(player, null);
                }
                if (point.equals((Object)RegionPoint.PRIMARY)) {
                    region.setFirstPoint(location);
                    MessageUtils.sendHotbarMessage(player, RegionText.FIRST_POINT_SET.getValue() + " " + location.toString());
                } else {
                    region.setSecondPoint(location);
                    MessageUtils.sendHotbarMessage(player, RegionText.SECOND_POINT_SET.getValue() + " " + location.toString());
                }
                RegionUtils.setRegionScoreboard(player, region);
                RegionUtils.setPendingRegion(player, (Region)region);
            } else {
                MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_ITEM.getValue());
            }
        }
    }
}

