/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.RegionEventType;
import com.universeguard.utils.InventoryUtils;
import com.universeguard.utils.RegionUtils;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagItemDropListener {
    @Listener
    public void onItemDrop(DropItemEvent.Pre event, @First Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handleEvent((Cancellable)event, (Location<World>)player.getLocation(), player);
        } else {
            this.handleEvent((Cancellable)event, (Location<World>)entity.getLocation(), null);
        }
    }

    @Listener
    public void onItemDrop(DropItemEvent.Dispense event, @First Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handleEvent((Cancellable)event, (Location<World>)player.getLocation(), player);
        } else {
            this.handleEvent((Cancellable)event, (Location<World>)entity.getLocation(), null);
        }
    }

    @Listener
    public void onItemDropByInventory(DropItemEvent.Custom event) {
        Item item;
        Optional stack;
        Player player;
        if (event.getSource() instanceof Player && this.handleEvent((Cancellable)event, (Location<World>)(player = (Player)event.getSource()).getLocation(), player) && !event.getEntities().isEmpty() && event.getEntities().get(0) instanceof Item && (stack = (item = (Item)event.getEntities().get(0)).get(Keys.REPRESENTED_ITEM)).isPresent()) {
            InventoryUtils.addItemStackToInventory(player, ((ItemStackSnapshot)stack.get()).createStack());
            event.setCancelled(true);
        }
    }

    @Listener
    public void onItemDropFromInventory(SpawnEntityEvent event, @First Player player, @Root SpawnType cause) {
        Entity entity;
        EntityType type;
        if ((cause.equals(SpawnTypes.DROPPED_ITEM) || cause.equals(SpawnTypes.PLACEMENT)) && !event.getEntities().isEmpty() && (type = (entity = (Entity)event.getEntities().get(0)).getType()).equals(EntityTypes.ITEM)) {
            this.handleEvent((Cancellable)event, (Location<World>)player.getLocation(), player);
        }
    }

    private boolean handleEvent(Cancellable event, Location<World> location, Player player) {
        return RegionUtils.handleEvent(event, EnumRegionFlag.ITEM_DROP, location, player, RegionEventType.GLOBAL);
    }
}

