/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.Region;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.monster.Monster;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.entity.damage.source.IndirectEntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.projectile.LaunchProjectileEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagMobDamageListener {
    @Listener
    public void onMobDamage(DamageEntityEvent event, @First IndirectEntityDamageSource source) {
        Entity entity = source.getIndirectSource();
        if (event.getTargetEntity() instanceof Player && !(entity instanceof Player) && entity instanceof Living) {
            this.handleEvent((Cancellable)event, entity);
        }
    }

    @Listener
    public void onProjectileShot(LaunchProjectileEvent event, @First Living source) {
        if (!(event.getTargetEntity() instanceof Player)) {
            this.handleEvent((Cancellable)event, (Entity)source);
        }
    }

    private void handleEvent(Cancellable event, Entity entity) {
        EntityType type = entity.getType();
        if (!FlagUtils.isBlockEntity(type) && !FlagUtils.isVehicle(type) && entity instanceof Living) {
            String name = type.getId().toLowerCase();
            Region region = RegionUtils.getRegion((Location<World>)entity.getLocation());
            if (region != null) {
                boolean cancel;
                boolean relatedAllFlag;
                boolean bl = relatedAllFlag = !region.getMobDamage("all");
                if (entity instanceof Monster) {
                    boolean bl2 = relatedAllFlag = relatedAllFlag || !region.getMobDamage("allhostile");
                }
                if (entity instanceof Creature || entity instanceof Animal) {
                    relatedAllFlag = relatedAllFlag || !region.getMobDamage("allpassive");
                }
                boolean bl3 = cancel = relatedAllFlag || !region.getMobDamage(name);
                if (cancel) {
                    event.setCancelled(true);
                }
            }
        }
    }
}

