/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.monster.Monster;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagMobSpawnListener {
    @Listener
    public void onMobSpawn(SpawnEntityEvent event, @Root Entity cause) {
        if (!event.getEntities().isEmpty()) {
            if (cause instanceof Player) {
                this.handleEvent(event, (Entity)event.getEntities().get(0), (Player)cause);
            } else {
                this.handleEvent(event, (Entity)event.getEntities().get(0), null);
            }
        }
    }

    @Listener
    public void onMobSpawn(SpawnEntityEvent event) {
        if (event.getContext().containsKey(EventContextKeys.SPAWN_TYPE)) {
            SpawnType type = (SpawnType)event.getContext().get(EventContextKeys.SPAWN_TYPE).get();
            if (!(event.getEntities().isEmpty() || type.equals(SpawnTypes.PLACEMENT) || type.equals(SpawnTypes.DROPPED_ITEM) || type.equals(SpawnTypes.CHUNK_LOAD))) {
                this.handleEvent(event, (Entity)event.getEntities().get(0), null);
            }
        }
    }

    private void handleEvent(SpawnEntityEvent event, Entity entity, Player player) {
        EntityType type = entity.getType();
        if (!FlagUtils.isBlockEntity(type) && !FlagUtils.isVehicle(type) && !(entity instanceof ArmorStand) && entity instanceof Living) {
            String name = type.getId().toLowerCase();
            Region region = RegionUtils.getRegion((Location<World>)entity.getLocation());
            if (region != null) {
                boolean cancel;
                boolean relatedAllFlag;
                boolean bl = relatedAllFlag = !region.getMobSpawn("all");
                if (entity instanceof Monster) {
                    boolean bl2 = relatedAllFlag = relatedAllFlag || !region.getMobSpawn("allhostile");
                }
                if (entity instanceof Creature || entity instanceof Animal) {
                    relatedAllFlag = relatedAllFlag || !region.getMobSpawn("allpassive");
                }
                boolean bl3 = cancel = relatedAllFlag || !region.getMobSpawn(name);
                if (player != null) {
                    boolean bl4 = cancel = cancel && !PermissionUtils.hasPermission(player, RegionPermission.REGION);
                }
                if (cancel) {
                    event.setCancelled(true);
                    if (player != null) {
                        MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                    }
                }
            }
        }
    }
}

