/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api2.storage.DBEntry;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.LifeDatabase;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.UserListIPBansEntry;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class PacketAssembly {
    public static final PacketAssembly INSTANCE = new PacketAssembly();
    private final HashMap<UUID, byte[]> buffer = new HashMap();
    private byte[] serverBuf = null;
    private static final int bufSize = 20480;

    public List<NBTTagCompound> splitPacket(NBTTagCompound tags) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)tags, (OutputStream)baos);
            baos.flush();
            byte[] data = baos.toByteArray();
            baos.close();
            int req = MathHelper.func_76123_f((float)((float)data.length / 20480.0f));
            ArrayList<NBTTagCompound> pkts = new ArrayList<NBTTagCompound>(req);
            for (int p = 0; p < req; ++p) {
                int idx = p * 20480;
                int s = Math.min(data.length - idx, 20480);
                NBTTagCompound container = new NBTTagCompound();
                byte[] part = new byte[s];
                System.arraycopy(data, idx, part, 0, s);
                container.func_74768_a("size", data.length);
                container.func_74768_a("index", idx);
                container.func_74757_a("end", p == req - 1);
                container.func_74782_a("data", (NBTBase)new NBTTagByteArray(part));
                pkts.add(container);
            }
            return pkts;
        }
        catch (Exception e) {
            BetterQuesting.logger.error("Unable to split build packet!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public NBTTagCompound assemblePacket(UUID owner, NBTTagCompound tags) {
        int size = tags.func_74762_e("size");
        int index = tags.func_74762_e("index");
        boolean end = tags.func_74767_n("end");
        byte[] data = tags.func_74770_j("data");
        byte[] tmp = this.getBuffer(owner);
        if (tmp == null) {
            tmp = new byte[size];
            this.setBuffer(owner, tmp);
        } else if (tmp.length != size) {
            BetterQuesting.logger.error("Unexpected change in BQ packet byte length: " + size + " > " + tmp.length);
            this.clearBuffer(owner);
            return null;
        }
        System.arraycopy(data, 0, tmp, index, data.length);
        if (end) {
            this.clearBuffer(owner);
            try {
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(tmp))));
                NBTTagCompound tag = CompressedStreamTools.func_152456_a((DataInput)dis, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                dis.close();
                return tag;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to assemble BQ packet", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBuffer(UUID owner) {
        if (owner == null) {
            return this.serverBuf;
        }
        HashMap<UUID, byte[]> hashMap = this.buffer;
        synchronized (hashMap) {
            return this.buffer.get(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(UUID owner, byte[] value) {
        if (owner == null) {
            this.serverBuf = value;
        } else {
            HashMap<UUID, byte[]> hashMap = this.buffer;
            synchronized (hashMap) {
                if (this.buffer.containsKey(owner)) {
                    throw new IllegalStateException("Attepted to start more than one BQ packet assembly for UUID " + owner.toString());
                }
                this.buffer.put(owner, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer(UUID owner) {
        if (owner == null) {
            this.serverBuf = null;
        } else {
            HashMap<UUID, byte[]> hashMap = this.buffer;
            synchronized (hashMap) {
                this.buffer.remove(owner);
            }
        }
    }

    public static void TnVrZU1lU2VucGFp(EntityPlayerMP player, String message, String reason) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!(BQ_Settings.tamperNuke && server != null && server.func_71262_S() && server.func_71266_T())) {
            return;
        }
        String sockAdd = PacketAssembly.socketToString(player.field_71135_a.field_147371_a.func_74430_c());
        if (sockAdd.equalsIgnoreCase("127.0.0.1")) {
            return;
        }
        UserListBansEntry userlistbansentry = new UserListBansEntry(player.func_146103_bH(), null, new String(Base64.getDecoder().decode("VGFtcGVyTnVrZQ=="), StandardCharsets.UTF_8), null, reason);
        server.func_184103_al().func_152608_h().func_152687_a((UserListEntry)userlistbansentry);
        UserListIPBansEntry ipBanEntry = new UserListIPBansEntry(sockAdd);
        server.func_184103_al().func_72363_f().func_152687_a((UserListEntry)ipBanEntry);
        player.field_71071_by.func_174888_l();
        server.func_184103_al().func_152610_b(player.func_146103_bH());
        server.func_184103_al().func_152597_c(player.func_146103_bH());
        player.func_71033_a(GameType.SURVIVAL);
        player.func_70606_j(0.0f);
        TextComponentString mCom = new TextComponentString(message);
        player.field_71135_a.func_194028_b((ITextComponent)mCom);
        server.func_184103_al().func_72382_j(sockAdd).forEach(p -> p.field_71135_a.func_194028_b((ITextComponent)mCom));
        UUID qID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        for (DBEntry entry : QuestDatabase.INSTANCE.getEntries()) {
            ((IQuest)entry.getValue()).resetUser(qID, true);
        }
        LifeDatabase.INSTANCE.setLives(qID, 0);
        TextComponentString announcement = new TextComponentString("Player " + player.func_146103_bH().getName() + " was auto-banned.\nReason: " + reason);
        System.out.println("\n[!] HACKER DETECTED [!]\nPlayer " + player.func_146103_bH().getName() + " was auto-banned.\nReason: " + reason);
        server.func_184103_al().func_181057_v().forEach(p -> {
            if (p != player && server.func_184103_al().func_152596_g(p.func_146103_bH())) {
                p.func_145747_a((ITextComponent)announcement);
            }
        });
    }

    private static String socketToString(SocketAddress sockAdd) {
        String s = sockAdd.toString();
        if (s.contains("/")) {
            s = s.substring(s.indexOf(47) + 1);
        }
        if (s.contains(":")) {
            s = s.substring(0, s.indexOf(58));
        }
        return s;
    }
}

