/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns;

import com.atherys.core.AtherysCore;
import com.atherys.core.command.CommandService;
import com.atherys.core.economy.Economy;
import com.atherys.core.event.AtherysHibernateConfigurationEvent;
import com.atherys.core.event.AtherysHibernateInitializedEvent;
import com.atherys.towns.AtherysTownsModule;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.permission.Permission;
import com.atherys.towns.api.permission.PermissionRegistryModule;
import com.atherys.towns.api.permission.TownsPermissionContext;
import com.atherys.towns.api.permission.TownsPermissionContextRegistryModule;
import com.atherys.towns.api.permission.WorldPermissionRegistryModule;
import com.atherys.towns.api.permission.world.WorldPermission;
import com.atherys.towns.command.nation.NationCommand;
import com.atherys.towns.command.plot.PlotCommand;
import com.atherys.towns.command.resident.ResidentCommand;
import com.atherys.towns.command.town.TownCommand;
import com.atherys.towns.facade.NationFacade;
import com.atherys.towns.facade.PermissionFacade;
import com.atherys.towns.facade.PlotBorderFacade;
import com.atherys.towns.facade.PlotFacade;
import com.atherys.towns.facade.PlotSelectionFacade;
import com.atherys.towns.facade.PollFacade;
import com.atherys.towns.facade.ResidentFacade;
import com.atherys.towns.facade.TaxFacade;
import com.atherys.towns.facade.TownAdminFacade;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownRaidFacade;
import com.atherys.towns.facade.TownSpawnFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.integration.AtherysChatIntegration;
import com.atherys.towns.listener.PlayerListener;
import com.atherys.towns.listener.ProtectionListener;
import com.atherys.towns.listener.RaidListener;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.NationPlot;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.model.entity.TownPlotPermission;
import com.atherys.towns.permission.TownsContextCalculator;
import com.atherys.towns.persistence.NationPlotRepository;
import com.atherys.towns.persistence.NationRepository;
import com.atherys.towns.persistence.ResidentRepository;
import com.atherys.towns.persistence.TownPlotRepository;
import com.atherys.towns.persistence.TownRepository;
import com.atherys.towns.persistence.cache.TownPlotCache;
import com.atherys.towns.persistence.cache.TownsCache;
import com.atherys.towns.service.NationService;
import com.atherys.towns.service.PlotService;
import com.atherys.towns.service.PollService;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.RoleService;
import com.atherys.towns.service.TaxService;
import com.atherys.towns.service.TownRaidService;
import com.atherys.towns.service.TownService;
import com.atherys.towns.service.TownsPermissionService;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionService;

@Plugin(id="atherystowns", name="A'therys Towns", description="A land-management plugin for the Atherys Horizons server", version="1.3.5", dependencies={@Dependency(id="atheryscore"), @Dependency(id="atherysparties", optional=true), @Dependency(id="atheryschat", optional=true)})
public class AtherysTowns {
    static final String ID = "atherystowns";
    static final String NAME = "A'therys Towns";
    static final String DESCRIPTION = "A land-management plugin for the Atherys Horizons server";
    static final String VERSION = "1.3.5";
    private static AtherysTowns instance;
    private static boolean init;
    private boolean economyEnabled;
    @Inject
    private Logger logger;
    @Inject
    private Injector spongeInjector;
    private Components components;
    private Injector townsInjector;

    public static AtherysTowns getInstance() {
        return instance;
    }

    public static boolean economyIsEnabled() {
        return AtherysTowns.getInstance().economyEnabled;
    }

    private void init() {
        instance = this;
        Sponge.getRegistry().registerModule(Permission.class, (CatalogRegistryModule)new PermissionRegistryModule());
        Sponge.getRegistry().registerModule(WorldPermission.class, (CatalogRegistryModule)new WorldPermissionRegistryModule());
        Sponge.getRegistry().registerModule(TownsPermissionContext.class, (CatalogRegistryModule)new TownsPermissionContextRegistryModule());
        this.components = new Components();
        this.townsInjector = this.spongeInjector.createChildInjector(new Module[]{new AtherysTownsModule()});
        this.townsInjector.injectMembers((Object)this.components);
        this.getConfig().init();
        init = true;
    }

    private void start() {
        boolean bl = this.economyEnabled = Economy.isPresent() && ((Components)this.components).config.ECONOMY;
        if (((Components)this.components).config.TOWN.TOWN_WARMUP < 0) {
            this.logger.warn("Town spawn warmup is negative. Will default to zero.");
            ((Components)this.components).config.TOWN.TOWN_WARMUP = 0;
        }
        if (((Components)this.components).config.TOWN.TOWN_COOLDOWN < 0) {
            ((Components)this.components).config.TOWN.TOWN_COOLDOWN = 0;
            this.logger.warn("Town spawn cooldown is negative. Will default to zero.");
        }
        this.getRoleService().init();
        this.getTownsCache().initCache();
        this.getTownRaidService().initRaidTimer();
        this.getPlotBorderFacade().initBorderTask();
        this.getTaxFacade().init();
        Sponge.getEventManager().registerListeners((Object)this, (Object)this.components.playerListener);
        Sponge.getEventManager().registerListeners((Object)this, (Object)this.components.protectionListener);
        Sponge.getEventManager().registerListeners((Object)this, (Object)this.components.raidListener);
        if (Sponge.getPluginManager().isLoaded("atheryschat")) {
            AtherysChatIntegration.registerChannels();
        }
        ((PermissionService)Sponge.getServiceManager().provideUnchecked(PermissionService.class)).registerContextCalculator((ContextCalculator)new TownsContextCalculator());
        try {
            AtherysCore.getCommandService().register((CommandExecutor)new ResidentCommand(), (Object)this);
            AtherysCore.getCommandService().register((CommandExecutor)new PlotCommand(), (Object)this);
            AtherysCore.getCommandService().register((CommandExecutor)new TownCommand(), (Object)this);
            AtherysCore.getCommandService().register((CommandExecutor)new NationCommand(), (Object)this);
        }
        catch (CommandService.AnnotatedCommandException e) {
            e.printStackTrace();
        }
    }

    private void stop() {
        this.getTownsCache().flushCache();
    }

    @Listener
    public void onHibernateInit(AtherysHibernateInitializedEvent event) {
        this.init();
    }

    @Listener
    public void onHibernateConfiguration(AtherysHibernateConfigurationEvent event) {
        event.registerEntity(Nation.class);
        event.registerEntity(Town.class);
        event.registerEntity(NationPlot.class);
        event.registerEntity(TownPlot.class);
        event.registerEntity(Resident.class);
        event.registerEntity(TownPlotPermission.class);
    }

    @Listener(order=Order.LAST)
    public void onStart(GameStartingServerEvent event) {
        if (init) {
            this.start();
        }
    }

    @Listener
    public void onStop(GameStoppingServerEvent event) {
        if (init) {
            this.stop();
        }
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        this.getConfig().init();
    }

    public TownsConfig getConfig() {
        return this.components.config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TownRepository getTownRepository() {
        return this.components.townRepository;
    }

    public NationRepository getNationRepository() {
        return this.components.nationRepository;
    }

    public TownPlotRepository getTownPlotRepository() {
        return this.components.townPlotRepository;
    }

    public NationPlotRepository getNationPlotRepository() {
        return this.components.nationPlotRepository;
    }

    public ResidentRepository getResidentRepository() {
        return this.components.residentRepository;
    }

    public TaxService getTaxService() {
        return this.components.taxService;
    }

    public PollService getPollService() {
        return this.components.pollService;
    }

    public NationService getNationService() {
        return this.components.nationService;
    }

    public TownService getTownService() {
        return this.components.townService;
    }

    public PlotService getPlotService() {
        return this.components.plotService;
    }

    public ResidentService getResidentService() {
        return this.components.residentService;
    }

    public RoleService getRoleService() {
        return this.components.roleService;
    }

    public TownsPermissionService getPermissionService() {
        return this.components.townsPermissionService;
    }

    public TownsMessagingFacade getTownsMessagingService() {
        return this.components.townsMessagingFacade;
    }

    public TownRaidService getTownRaidService() {
        return this.components.townRaidService;
    }

    public NationFacade getNationFacade() {
        return this.components.nationFacade;
    }

    public TownFacade getTownFacade() {
        return this.components.townFacade;
    }

    public TownSpawnFacade getTownSpawnCommand() {
        return this.components.townSpawnFacade;
    }

    public TownAdminFacade getTownAdminFacade() {
        return this.components.townAdminFacade;
    }

    public PlotFacade getPlotFacade() {
        return this.components.plotFacade;
    }

    public ResidentFacade getResidentFacade() {
        return this.components.residentFacade;
    }

    public PermissionFacade getPermissionFacade() {
        return this.components.permissionFacade;
    }

    public PlotSelectionFacade getPlotSelectionFacade() {
        return this.components.plotSelectionFacade;
    }

    public PollFacade getPollFacade() {
        return this.components.pollFacade;
    }

    public PlotBorderFacade getPlotBorderFacade() {
        return this.components.plotBorderFacade;
    }

    public TownRaidFacade getTownRaidFacade() {
        return this.components.townRaidFacade;
    }

    public TaxFacade getTaxFacade() {
        return this.components.taxFacade;
    }

    public TownsCache getTownsCache() {
        return this.components.townsCache;
    }

    static {
        init = false;
    }

    private static class Components {
        @Inject
        private TownsConfig config;
        @Inject
        private TownsCache townsCache;
        @Inject
        private TownPlotCache townPlotCache;
        @Inject
        private NationRepository nationRepository;
        @Inject
        private TownRepository townRepository;
        @Inject
        private TownPlotRepository townPlotRepository;
        @Inject
        private NationPlotRepository nationPlotRepository;
        @Inject
        private ResidentRepository residentRepository;
        @Inject
        private TaxService taxService;
        @Inject
        private PollService pollService;
        @Inject
        private NationService nationService;
        @Inject
        private TownService townService;
        @Inject
        private PlotService plotService;
        @Inject
        private ResidentService residentService;
        @Inject
        private RoleService roleService;
        @Inject
        private TownsPermissionService townsPermissionService;
        @Inject
        private TownRaidService townRaidService;
        @Inject
        private TownsMessagingFacade townsMessagingFacade;
        @Inject
        private NationFacade nationFacade;
        @Inject
        private TownFacade townFacade;
        @Inject
        private TownSpawnFacade townSpawnFacade;
        @Inject
        private TownAdminFacade townAdminFacade;
        @Inject
        private PlotFacade plotFacade;
        @Inject
        private ResidentFacade residentFacade;
        @Inject
        private PermissionFacade permissionFacade;
        @Inject
        private PlotSelectionFacade plotSelectionFacade;
        @Inject
        private PollFacade pollFacade;
        @Inject
        private PlotBorderFacade plotBorderFacade;
        @Inject
        private TownRaidFacade townRaidFacade;
        @Inject
        private TaxFacade taxFacade;
        @Inject
        private PlayerListener playerListener;
        @Inject
        private ProtectionListener protectionListener;
        @Inject
        private RaidListener raidListener;

        private Components() {
        }
    }
}

