/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.config;

import com.atherys.towns.api.permission.Permission;
import com.atherys.towns.api.permission.TownsPermissionContexts;
import com.atherys.towns.api.permission.town.TownPermissions;
import com.atherys.towns.api.permission.world.WorldPermission;
import com.atherys.towns.api.permission.world.WorldPermissions;
import com.atherys.towns.config.PlotPermissionConfig;
import com.atherys.towns.config.TownRoleConfig;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;

@ConfigSerializable
public class TownConfig {
    @Setting(value="plot-max-area")
    public int MAX_PLOT_AREA = 1024;
    @Setting(value="plot-min-side")
    public int MIN_PLOT_SIDE = 16;
    @Setting(value="town-min-creation-distance")
    public int MIN_CREATION_DISTANCE = 100;
    @Setting(value="default-town-max-size")
    public int DEFAULT_TOWN_MAX_SIZE = 4096;
    @Setting(value="max-town-name-size")
    public int MAX_TOWN_NAME_LENGTH = 25;
    @Setting(value="town-spawn-cooldown-minutes")
    public int TOWN_COOLDOWN = 0;
    @Setting(value="town-spawn-warmup-seconds")
    public int TOWN_WARMUP = 0;
    @Setting(value="town-leader-role")
    public String TOWN_LEADER_ROLE = "mayor";
    @Setting(value="town-default-role")
    public String TOWN_DEFAULT_ROLE = "resident";
    @Setting(value="local-transactions")
    public boolean LOCAL_TRANSACTIONS = false;
    @Setting(value="town-creation-cost")
    public double CREATION_COST = 0.0;
    @Setting(value="generate-roles")
    public boolean GENERATE_ROLES = true;
    @Setting(value="default-plot-permissions")
    public Set<PlotPermissionConfig> DEFAULT_PLOT_PERMISSIONS = new HashSet<PlotPermissionConfig>();
    @Setting(value="roles")
    public Map<String, TownRoleConfig> ROLES;

    public TownConfig() {
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.DESTROY));
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.BUILD));
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.DAMAGE_NONPLAYERS));
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.DAMAGE_PLAYERS));
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.INTERACT_ENTITIES));
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.INTERACT_TILE_ENTITIES));
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.INTERACT_DOORS));
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.INTERACT_REDSTONE));
        this.DEFAULT_PLOT_PERMISSIONS.add(new PlotPermissionConfig(TownsPermissionContexts.TOWN, WorldPermissions.SPAWN_ENTITIES));
        this.ROLES = new HashMap<String, TownRoleConfig>();
        TownRoleConfig townLeader = new TownRoleConfig();
        townLeader.setName("Mayor");
        townLeader.setTownPermissions((Set<Permission>)ImmutableSet.of((Object)TownPermissions.RUIN_TOWN, (Object)TownPermissions.START_RAID, (Object)TownPermissions.CANCEL_RAID, (Object)TownPermissions.INVITE_RESIDENT, (Object)TownPermissions.KICK_RESIDENT, (Object)TownPermissions.CLAIM_PLOT, (Object[])new Permission[]{TownPermissions.UNCLAIM_PLOT, TownPermissions.GRANT_PLOT, TownPermissions.SET_PERMISSION, TownPermissions.WITHDRAW_FROM_BANK, TownPermissions.DEPOSIT_INTO_BANK, TownPermissions.JOIN_NATION, TownPermissions.SET_NAME, TownPermissions.SET_DESCRIPTION, TownPermissions.SET_MOTD, TownPermissions.SET_COLOR, TownPermissions.SET_FREELY_JOINABLE, TownPermissions.SET_SPAWN, TownPermissions.SET_PVP, TownPermissions.SET_ROLE, TownPermissions.TRANSFER_LEADERSHIP, TownPermissions.CHAT}));
        townLeader.setWorldPermissions((Set<WorldPermission>)ImmutableSet.of((Object)WorldPermissions.BUILD, (Object)WorldPermissions.DESTROY, (Object)WorldPermissions.DAMAGE_NONPLAYERS, (Object)WorldPermissions.DAMAGE_PLAYERS, (Object)WorldPermissions.INTERACT_TILE_ENTITIES, (Object)WorldPermissions.INTERACT_DOORS, (Object[])new WorldPermission[]{WorldPermissions.INTERACT_REDSTONE, WorldPermissions.INTERACT_ENTITIES, WorldPermissions.SPAWN_ENTITIES}));
        TownRoleConfig townMember = new TownRoleConfig();
        townMember.setName("Resident");
        townMember.setTownPermissions((Set<Permission>)ImmutableSet.of((Object)TownPermissions.DEPOSIT_INTO_BANK, (Object)TownPermissions.CHAT));
        townMember.setWorldPermissions((Set<WorldPermission>)ImmutableSet.of((Object)WorldPermissions.BUILD, (Object)WorldPermissions.DESTROY, (Object)WorldPermissions.DAMAGE_NONPLAYERS, (Object)WorldPermissions.DAMAGE_PLAYERS, (Object)WorldPermissions.INTERACT_TILE_ENTITIES, (Object)WorldPermissions.INTERACT_DOORS, (Object[])new WorldPermission[]{WorldPermissions.INTERACT_REDSTONE, WorldPermissions.INTERACT_ENTITIES, WorldPermissions.SPAWN_ENTITIES}));
        this.ROLES.put("mayor", townLeader);
        this.ROLES.put("resident", townMember);
    }
}

