/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.core.economy.Economy;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.api.permission.nation.NationPermission;
import com.atherys.towns.facade.EconomyFacade;
import com.atherys.towns.facade.PermissionFacade;
import com.atherys.towns.facade.PlotSelectionFacade;
import com.atherys.towns.facade.ResidentFacade;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.PlotSelection;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.NationPlot;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.service.NationService;
import com.atherys.towns.service.PlotService;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.RoleService;
import com.atherys.towns.service.TownsPermissionService;
import com.atherys.towns.util.MathUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.transaction.TransferResult;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class NationFacade
implements EconomyFacade {
    @Inject
    private PlotSelectionFacade plotSelectionFacade;
    @Inject
    private TownsConfig config;
    @Inject
    private NationService nationService;
    @Inject
    private RoleService roleService;
    @Inject
    private TownsMessagingFacade townsMsg;
    @Inject
    private TownFacade townFacade;
    @Inject
    private ResidentFacade residentFacade;
    @Inject
    private PermissionFacade permissionFacade;
    @Inject
    private TownsPermissionService townsPermissionService;
    @Inject
    private ResidentService residentService;
    @Inject
    private PlotService plotService;

    NationFacade() {
    }

    public void createNation(String nationName, Town capital) throws TownsCommandException {
        if (nationName.length() > this.config.NATION.MAX_NATION_NAME_LENGTH) {
            throw new TownsCommandException("Your name is longer than the maximum (", this.config.NATION.MAX_NATION_NAME_LENGTH, ").");
        }
        if (this.nationService.getNationFromName(nationName).isPresent()) {
            throw new TownsCommandException("A nation with that name already exists.");
        }
        if (capital.getNation() != null) {
            throw new TownsCommandException("Town ", capital.getName(), " is already in a nation.");
        }
        this.nationService.createNation(nationName, capital);
        this.townsMsg.broadcastInfo("The nation of ", TextColors.GOLD, nationName, TextColors.DARK_GREEN, " was created.");
    }

    public void disbandNation(CommandSource source, Nation nation) {
        this.nationService.disbandNation(nation);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"The nation of ", TextColors.GOLD, nation.getName(), TextColors.DARK_GREEN, " was disbaned."});
    }

    public void setNationName(Player source, String nationName) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        this.nationService.setNationName(nation, nationName);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Nation name set."});
    }

    public void setNationDescription(Player source, Text nationDescription) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        this.nationService.setNationDescription(nation, nationDescription);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Nation description set."});
    }

    public void setNationCapital(Player source, Town town) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        if (town.getNation() == null || town.getNation() != nation) {
            throw new TownsCommandException("Town ", town.getName(), " is not part of your nation.");
        }
        this.nationService.addTown(nation, town);
        this.nationService.setCapital(nation, town);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Nation capital set."});
    }

    public void setNationColor(Player source, TextColor color) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        this.nationService.setColor(nation, color);
    }

    public void addTownToNation(Nation nation, Town town) throws TownsCommandException {
        if (town.getNation() != null) {
            throw new TownsCommandException("Town ", town.getName(), " is already part of a nation.");
        }
        this.nationService.addTown(nation, town);
        this.townsMsg.broadcastNationInfo(nation, "The town ", TextColors.GOLD, town.getName(), TextColors.DARK_GREEN, " has joined the nation");
    }

    public void removeTownFromNation(Nation nation, Town town) throws TownsCommandException {
        if (!town.getNation().equals(nation)) {
            throw new TownsCommandException("Town ", town.getName(), " is not part of ", nation.getName(), ".");
        }
        if (nation.getCapital().equals(town)) {
            throw new TownsCommandException("Town ", town.getName(), " cannot be removed as it is the capital of ", nation.getName(), ".");
        }
        this.nationService.removeTown(nation, town);
        this.townsMsg.broadcastNationInfo(nation, "The town ", TextColors.GOLD, town.getName(), TextColors.DARK_GREEN, " has left the nation");
        this.townsMsg.broadcastTownInfo(town, "Your town ", TextColors.GOLD, town.getName(), TextColors.DARK_GREEN, " has left the nation ", TextColors.GOLD, nation.getName());
    }

    public void addNationAlly(Player source, Nation ally) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        if (nation.equals(ally)) {
            throw new TownsCommandException("Cannot add your own nation as an ally.");
        }
        this.nationService.addNationAlly(nation, ally);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Your nation is now allied with ", TextColors.GOLD, ally.getName(), TextColors.DARK_GREEN, "."});
    }

    public void addNationNeutral(Player source, Nation neutral) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        this.nationService.addNationNeutral(nation, neutral);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Your nation is now neutral with ", TextColors.GOLD, neutral.getName(), TextColors.DARK_GREEN, "."});
    }

    public void addNationEnemy(Player source, Nation enemy) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        this.nationService.addNationEnemy(nation, enemy);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Your nation is now enemies with ", TextColors.GOLD, enemy.getName(), TextColors.DARK_GREEN, "."});
    }

    public void setNationTax(Player source, double tax) throws TownsCommandException {
        double minMultiplier = this.config.TAXES.MIN_NATION_TAX_MODIFIER;
        double maxMultiplier = this.config.TAXES.MAX_NATION_TAX_MODIFIER;
        if (tax > maxMultiplier || tax < minMultiplier) {
            throw new TownsCommandException(Text.of((Object[])new Object[]{"Tax amount does not meet requirements (", minMultiplier, " - ", maxMultiplier, ")"}));
        }
        Nation nation = this.getPlayerNation(source);
        this.nationService.setTax(nation, tax);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Nation tax rate changed to: ", TextColors.GOLD, tax});
    }

    public void claimNationPlotFromPlayerSelection(Player player, Nation nation) throws CommandException {
        PlotSelection selection = this.plotSelectionFacade.getValidPlayerPlotSelection(player);
        NationPlot plot = this.plotService.createNationPlotFromSelection(selection);
        Set<NationPlot> plots = this.plotService.getNationPlotsByLocation((Location<World>)player.getLocation());
        for (NationPlot other : plots) {
            if (!other.getNation().equals(nation)) {
                throw new TownsCommandException("Plot for nation: ", other.getNation(), " already exists at this location.");
            }
            if (MathUtils.equals(plot, other)) {
                throw new TownsCommandException("Plot with same coordinates already exists.");
            }
            if (!MathUtils.contains(other, plot)) continue;
            throw new TownsCommandException("Plot fits within an existing nation plot.");
        }
        this.nationService.claimPlotForNation(plot, nation);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Nation Plot claimed."});
    }

    public void removeNationPlotAtPlayerLocation(Player player) throws TownsCommandException {
        Set<NationPlot> plots = this.plotService.getNationPlotsByLocation((Location<World>)player.getLocation());
        if (plots.size() < 1) {
            throw new TownsCommandException("There is no plot at this location.");
        }
        if (plots.size() > 1) {
            throw new TownsCommandException("Multiple plots exist at this location.");
        }
        this.nationService.removeNationPlot(plots.iterator().next());
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Nation Plot removed."});
    }

    public void sendInfoOnPlotAtPlayerLocation(Player player) throws TownsCommandException {
        Set<NationPlot> plots = this.plotService.getNationPlotsByLocation((Location<World>)player.getLocation());
        if (plots.size() < 1) {
            throw new TownsCommandException("There is no nation plot at this location.");
        }
        Text.Builder plotText = Text.builder();
        plotText.append(new Text[]{this.townsMsg.createTownsHeader("Nation Plots")});
        for (NationPlot plot : plots) {
            plotText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Plot ID: ", TextColors.GOLD, plot.getId(), Text.NEW_LINE, TextColors.DARK_GREEN, "Nation: ", plot.getNation() == null ? Text.of((Object[])new Object[]{TextColors.RED, "None"}) : Text.of((Object[])new Object[]{TextColors.GOLD, plot.getNation().getName()}), Text.NEW_LINE})});
            plotText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Point A: ", TextColors.GOLD, "x: ", plot.getSouthWestCorner().getX(), ", z: ", plot.getSouthWestCorner().getY(), Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Point B: ", TextColors.GOLD, "x: ", plot.getNorthEastCorner().getX(), ", z: ", plot.getNorthEastCorner().getY()})}).append(new Text[]{Text.NEW_LINE, Text.NEW_LINE});
        }
        player.sendMessage(plotText.build());
    }

    public void addNationPermission(Player source, User target, NationPermission permission) throws TownsCommandException {
    }

    public void removeNationPermission(Player source, User target, NationPermission permission) throws TownsCommandException {
    }

    public void addNationRole(Player source, User target, String role) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        if (!this.partOfSameNation((User)source, target)) {
            throw new TownsCommandException(target.getName(), " is not in the same nation as you!");
        }
        this.roleService.addNationRole((Subject)target, nation, role);
        this.townsMsg.info((MessageReceiver)source, new Object[]{TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, " was granted the role ", TextColors.GOLD, role, "."});
    }

    public void removeNationRole(Player source, User target, String role) throws TownsCommandException {
        Nation nation = this.getPlayerNation(source);
        if (!this.partOfSameNation((User)source, target)) {
            throw new TownsCommandException(target.getName(), " is not in the same nation as you!");
        }
        this.roleService.removeNationRole((Subject)target, nation, role);
        this.townsMsg.info((MessageReceiver)source, new Object[]{TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, " had the role ", TextColors.GOLD, role, TextColors.DARK_GREEN, " revoked."});
    }

    public void depositToNation(Player source, BigDecimal amount) throws TownsCommandException {
        this.checkEconomyEnabled();
        Nation nation = this.getPlayerNation(source);
        Optional result = Economy.transferCurrency((UUID)source.getUniqueId(), (String)nation.getBank().toString(), (Currency)this.config.DEFAULT_CURRENCY, (BigDecimal)amount, (Cause)Sponge.getCauseStackManager().getCurrentCause());
        if (result.isPresent()) {
            Text feedback = this.getResultFeedback(((TransferResult)result.get()).getResult(), Text.of((Object[])new Object[]{"Deposited ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(amount), TextColors.DARK_GREEN, " to the nation."}), (Text)Text.of((String)"You do not have enough to deposit."), (Text)Text.of((String)"Depositing failed."));
            this.townsMsg.info((MessageReceiver)source, new Object[]{feedback});
        }
    }

    public void withdrawFromNation(Player source, BigDecimal amount) throws TownsCommandException {
        this.checkEconomyEnabled();
        Nation nation = this.getPlayerNation(source);
        Optional result = Economy.transferCurrency((String)nation.getBank().toString(), (UUID)source.getUniqueId(), (Currency)this.config.DEFAULT_CURRENCY, (BigDecimal)amount, (Cause)Sponge.getCauseStackManager().getCurrentCause());
        if (result.isPresent()) {
            Text feedback = this.getResultFeedback(((TransferResult)result.get()).getResult(), Text.of((Object[])new Object[]{"Withdrew ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(amount), TextColors.DARK_GREEN, " from the nation."}), (Text)Text.of((String)"The town does not have enough to withdraw."), (Text)Text.of((String)"Withdrawing failed."));
            this.townsMsg.info((MessageReceiver)source, new Object[]{feedback});
        }
    }

    public void sendPlayerNationInfo(Player player) throws TownsCommandException {
        this.sendNationInfo((MessageReceiver)player, this.getPlayerNation(player));
    }

    public void sendNationInfo(MessageReceiver receiver, Nation nation) {
        Text.Builder nationInfo = Text.builder();
        nationInfo.append(new Text[]{this.townsMsg.createTownsHeader(nation.getName())});
        if (!nation.getDescription().equals((Object)NationService.DEFAULT_NATION_DESCRIPTION)) {
            nationInfo.append(new Text[]{nation.getDescription(), Text.NEW_LINE});
        }
        LiteralText leader = nation.getLeader() == null ? Text.of((String)"No Leader") : this.residentFacade.renderResident(nation.getLeader());
        LiteralText capital = nation.getCapital() == null ? Text.of((String)"No Capital") : this.townFacade.renderTown(nation.getCapital());
        nationInfo.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Capital: ", TextColors.GOLD, capital}), Text.NEW_LINE}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Leader: ", TextColors.GOLD, leader}), Text.NEW_LINE}).append(new Text[]{this.townsMsg.renderBank(nation.getBank().toString()), Text.NEW_LINE}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Tax Rate: ", TextColors.GOLD, nation.getTax(), Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Population: ", TextColors.GOLD, this.nationService.getNationPopulation(nation)}), Text.NEW_LINE}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Towns [", TextColors.GREEN, nation.getTowns().size(), TextColors.DARK_GREEN, "]: ", TextColors.GOLD, this.townFacade.renderTowns(nation.getTowns())})});
        if (!nation.getAllies().isEmpty()) {
            nationInfo.append(new Text[]{Text.of((Object[])new Object[]{Text.NEW_LINE, TextColors.DARK_GREEN, "Allies: ", this.renderNations(nation.getAllies())})});
        }
        if (!nation.getEnemies().isEmpty()) {
            nationInfo.append(new Text[]{Text.of((Object[])new Object[]{Text.NEW_LINE, TextColors.DARK_GREEN, "Enemies: ", this.renderNations(nation.getEnemies())})});
        }
        receiver.sendMessage(nationInfo.build());
    }

    public Text renderNation(Nation nation) {
        if (nation == null) {
            return Text.of((Object[])new Object[]{TextColors.GOLD, "No Nation"});
        }
        String leader = nation.getLeader() == null ? "No Leader" : nation.getLeader().getName();
        return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, nation.getName()})}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, nation.getName(), Text.NEW_LINE, TextColors.DARK_GREEN, "Leader: ", TextColors.GOLD, leader, Text.NEW_LINE, TextColors.DARK_GREEN, "Towns: ", TextColors.GOLD, nation.getTowns().size(), Text.NEW_LINE, TextColors.DARK_GREEN, "Population: ", TextColors.GOLD, this.nationService.getNationPopulation(nation), Text.NEW_LINE, this.townsMsg.renderBank(nation.getBank().toString()), Text.NEW_LINE, TextColors.DARK_GRAY, "Click to view"}))).onClick((ClickAction)TextActions.executeCallback(source -> this.sendNationInfo((MessageReceiver)source, nation))).build();
    }

    public Text renderNations(Collection<Nation> nations) {
        Text.Builder nationsText = Text.builder();
        int i = 0;
        for (Nation nation : nations) {
            nationsText.append(new Text[]{Text.of((Object[])new Object[]{this.renderNation(nation), ++i == nations.size() ? "" : ", "})});
        }
        return nationsText.build();
    }

    public void listNations(MessageReceiver receiver) {
        Text.Builder nationList = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GRAY, "[]====[ ", TextColors.GOLD, "Nations", TextColors.DARK_GRAY, " ]====[]", Text.NEW_LINE})});
        int i = 1;
        Collection<Nation> allNations = this.nationService.getAllNations();
        for (Nation nation : allNations) {
            nationList.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "- ", this.renderNation(nation)})});
            if (i < allNations.size()) {
                nationList.append(new Text[]{Text.NEW_LINE});
            }
            ++i;
        }
        receiver.sendMessage(nationList.build());
    }

    private Nation getPlayerNation(Player player) throws TownsCommandException {
        Town town = this.residentService.getOrCreate((User)player).getTown();
        if (town == null) {
            throw new TownsCommandException("You are not part of a town!");
        }
        Nation nation = town.getNation();
        if (nation == null) {
            throw new TownsCommandException("Your town is not part of a nation!");
        }
        return nation;
    }

    public Set<Player> getOnlineNationMembers(Nation nation) {
        return nation.getTowns().stream().flatMap(town -> this.townFacade.getOnlineTownMembers((Town)town).stream()).collect(Collectors.toSet());
    }

    public boolean partOfSameNation(User user, User other) {
        Town town = this.residentService.getOrCreate(user).getTown();
        Town otherTown = this.residentService.getOrCreate(other).getTown();
        if (town != null && otherTown != null && town.getNation() != null && otherTown.getNation() != null) {
            return town.getNation().equals(otherTown.getNation());
        }
        return false;
    }
}

