/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.facade.PlotSelectionFacade;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.BorderInfo;
import com.atherys.towns.model.PlotSelection;
import com.atherys.towns.model.entity.Plot;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.service.PlotService;
import com.atherys.towns.util.MathUtils;
import com.flowpowered.math.vector.Vector3d;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class PlotBorderFacade {
    private final Map<UUID, Boolean> borderViewers = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, Set<BorderInfo>> activeBorders = new ConcurrentHashMap<UUID, Set<BorderInfo>>();
    private final ParticleEffect.Builder wallEffectBuilder = ParticleEffect.builder().type(ParticleTypes.REDSTONE_DUST).offset(new Vector3d(0.0f, 4.0f, 0.0f)).quantity(8);
    private final ParticleEffect blueWalls = this.wallEffectBuilder.option(ParticleOptions.COLOR, (Object)Color.BLUE).build();
    private final ParticleEffect greenWalls = this.wallEffectBuilder.option(ParticleOptions.COLOR, (Object)Color.GREEN).build();
    private final ParticleEffect yellowWalls = this.wallEffectBuilder.option(ParticleOptions.COLOR, (Object)Color.YELLOW).build();
    @Inject
    PlotService plotService;
    @Inject
    PlotSelectionFacade plotSelectionFacade;
    @Inject
    TownFacade townFacade;
    @Inject
    TownsMessagingFacade townMsg;
    @Inject
    private TownsConfig config;

    public boolean isPlayerViewingBorders(Player player) {
        return this.borderViewers.getOrDefault(player.getUniqueId(), false);
    }

    public void showAllBorders(Player player, Location<World> location) {
        this.showPlotBorders(player, location);
        this.showNewPlotSelectionBorders(player, location);
    }

    public void clearBorders(Player player) {
        this.activeBorders.remove(player.getUniqueId());
    }

    public void refreshBorders(Player player, Location<World> location) {
        this.clearBorders(player);
        this.showAllBorders(player, location);
    }

    public void removeSelectionBorder(Player player, Plot plot) {
        Set<BorderInfo> playerBorders = this.activeBorders.get(player.getUniqueId());
        if (playerBorders != null && playerBorders.size() > 0 && plot != null) {
            playerBorders.removeIf(borderInfo -> borderInfo.getNECorner().equals((Object)plot.getNorthEastCorner()));
        }
    }

    public void removeBordersForTown(Town town) {
        for (Plot plot : town.getPlots()) {
            HashMap<UUID, Set> bordersToRemove = new HashMap<UUID, Set>();
            for (Map.Entry<UUID, Set<BorderInfo>> info : this.activeBorders.entrySet()) {
                Set borders = info.getValue().stream().filter(borderInfo -> borderInfo.getNECorner() == plot.getNorthEastCorner()).collect(Collectors.toSet());
                bordersToRemove.put(info.getKey(), borders);
            }
            bordersToRemove.forEach(this.activeBorders::remove);
        }
    }

    public void addSelectionBorder(Player player, BorderInfo borderInfo) {
        Set<BorderInfo> playerBorders = this.activeBorders.get(player.getUniqueId());
        if (playerBorders != null) {
            if (playerBorders.stream().noneMatch(borderInfo::equals)) {
                playerBorders.add(borderInfo);
            }
        } else {
            HashSet<BorderInfo> borderSet = new HashSet<BorderInfo>();
            borderSet.add(borderInfo);
            this.activeBorders.put(player.getUniqueId(), borderSet);
        }
    }

    public void showPlotBorders(Player player, Location<World> newLocation) {
        Optional<TownPlot> plot = this.plotService.getTownPlotByLocation(newLocation);
        if (plot.isPresent() && this.isPlayerViewingBorders(player)) {
            BorderInfo borderInfo = new BorderInfo(this.blueWalls, player.getUniqueId(), plot.get().getNorthEastCorner(), plot.get().getSouthWestCorner());
            this.addSelectionBorder(player, borderInfo);
        }
    }

    public void showNewPlotSelectionBorders(Player player, Location<World> location) {
        TownPlot plot;
        int plotArea;
        PlotSelection selection = this.plotSelectionFacade.getCurrentPlotSelection(player);
        if (selection.isComplete() && this.isPlayerViewingBorders(player) && (plotArea = MathUtils.getArea(plot = this.plotService.createTownPlotFromSelection(selection))) < this.config.TOWN.MAX_PLOT_AREA) {
            ParticleEffect effect = this.townFacade.isValidNewTownPlot(plot, player, location, true) ? this.greenWalls : this.yellowWalls;
            BorderInfo borderInfo = new BorderInfo(effect, player.getUniqueId(), plot.getNorthEastCorner(), plot.getSouthWestCorner());
            this.addSelectionBorder(player, borderInfo);
        }
    }

    public void initBorderTask() {
        Task.builder().execute(task -> this.activeBorders.forEach((uuid, borderInfoSet) -> Sponge.getServer().getPlayer(uuid).ifPresent(player -> borderInfoSet.forEach(borderInfo -> {
            int i;
            int width = MathUtils.getWidth(borderInfo);
            int height = MathUtils.getHeight(borderInfo);
            Vector3d particleLocationNE = new Vector3d((float)borderInfo.getNECorner().getX(), (float)player.getPosition().getFloorY(), (float)borderInfo.getNECorner().getY());
            Vector3d particleLocationSW = new Vector3d((float)borderInfo.getSWCorner().getX(), (float)player.getPosition().getFloorY(), (float)borderInfo.getSWCorner().getY());
            player.spawnParticles(borderInfo.getEffect(), particleLocationNE);
            player.spawnParticles(borderInfo.getEffect(), particleLocationSW);
            for (i = 1; i <= height; ++i) {
                player.spawnParticles(borderInfo.getEffect(), particleLocationNE.add(0.0f, 0.0f, (float)i));
                player.spawnParticles(borderInfo.getEffect(), particleLocationSW.sub(0.0f, 0.0f, (float)i));
            }
            for (i = 1; i <= width; ++i) {
                player.spawnParticles(borderInfo.getEffect(), particleLocationNE.sub((float)i, 0.0f, 0.0f));
                player.spawnParticles(borderInfo.getEffect(), particleLocationSW.add((float)i, 0.0f, 0.0f));
            }
        })))).intervalTicks(10L).submit((Object)AtherysTowns.getInstance());
    }

    public void setPlayerViewBorderStatus(Player player, boolean state) throws TownsCommandException {
        Text.Builder statusText = Text.builder();
        Text status = state ? Text.of((Object[])new Object[]{TextColors.GREEN, "Enabled"}) : Text.of((Object[])new Object[]{TextColors.RED, "Disabled"});
        statusText.append(new Text[]{Text.of((Object[])new Object[]{"Plot border viewing has been ", status})});
        if (state == this.isPlayerViewingBorders(player)) {
            throw new TownsCommandException("Plot border viewing is already ", status);
        }
        this.townMsg.info((MessageReceiver)player, new Object[]{statusText.build()});
        this.borderViewers.put(player.getUniqueId(), state);
        if (state) {
            this.showAllBorders(player, (Location<World>)player.getLocation());
        } else {
            this.clearBorders(player);
        }
    }

    public void onPlayerMove(Transform<World> from, Transform<World> to, Player player) {
        if (this.isPlayerViewingBorders(player)) {
            Optional<TownPlot> plotTo = this.plotService.getTownPlotByLocation((Location<World>)to.getLocation());
            Optional<TownPlot> plotFrom = this.plotService.getTownPlotByLocation((Location<World>)from.getLocation());
            PlotSelection selection = this.plotSelectionFacade.getCurrentPlotSelection(player);
            if (plotFrom.isPresent() && !plotTo.isPresent()) {
                this.removeSelectionBorder(player, plotFrom.get());
            }
            if (!plotFrom.isPresent() && plotTo.isPresent()) {
                this.refreshBorders(player, (Location<World>)to.getLocation());
            }
            if (plotTo.isPresent() && plotFrom.isPresent() && !plotFrom.equals(plotTo)) {
                this.refreshBorders(player, (Location<World>)to.getLocation());
            }
            if (selection.isComplete()) {
                TownPlot selectionPlot = this.plotService.createTownPlotFromSelection(selection);
                boolean fromInSelection = this.plotService.isLocationWithinPlot((Location<World>)from.getLocation(), selectionPlot);
                boolean toInSelection = this.plotService.isLocationWithinPlot((Location<World>)to.getLocation(), selectionPlot);
                if (fromInSelection && !toInSelection || !fromInSelection && toInSelection) {
                    this.refreshBorders(player, (Location<World>)to.getLocation());
                }
            }
        }
    }
}

