/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.api.permission.TownsPermissionContext;
import com.atherys.towns.api.permission.TownsPermissionContexts;
import com.atherys.towns.api.permission.town.TownPermissions;
import com.atherys.towns.api.permission.world.WorldPermission;
import com.atherys.towns.facade.PermissionFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.model.entity.TownPlotPermission;
import com.atherys.towns.service.PlotService;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.TownsPermissionService;
import com.atherys.towns.util.MathUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class PlotFacade {
    @Inject
    TownsConfig config;
    @Inject
    PlotService plotService;
    @Inject
    PermissionFacade permissionFacade;
    @Inject
    TownsMessagingFacade townsMsg;
    @Inject
    ResidentService residentService;
    @Inject
    TownsPermissionService townsPermissionService;

    PlotFacade() {
    }

    public void renameTownPlotAtPlayerLocation(Player player, Text newName) throws TownsCommandException {
        TownPlot plot = this.getPlotAtPlayer(player);
        if (!this.permissionFacade.isPermitted(player, TownPermissions.RENAME_PLOT) && !this.residentService.getOrCreate((User)player).equals(plot.getOwner())) {
            throw new TownsCommandException("You are not permitted to rename this plot.");
        }
        this.plotService.setTownPlotName(plot, newName);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Plot renamed."});
    }

    public void sendInfoOnPlotAtPlayerLocation(Player player) throws TownsCommandException {
        TownPlot plot = this.getPlotAtPlayer(player);
        Resident plotOwner = plot.getOwner() != null ? plot.getOwner() : new Resident();
        String ownerName = plotOwner.getName() != null ? plotOwner.getName() : "None";
        Text.Builder plotText = Text.builder();
        plotText.append(new Text[]{this.townsMsg.createTownsHeader(plot.getName().toPlain())});
        plotText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Town: ", plot.getTown() == null ? Text.of((Object[])new Object[]{TextColors.RED, "None"}) : Text.of((Object[])new Object[]{TextColors.GOLD, plot.getTown().getName()}), Text.NEW_LINE})});
        plotText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Owner: ", TextColors.GOLD, ownerName, Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Size: ", TextColors.GOLD, MathUtils.getArea(plot), Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Point A: ", TextColors.GOLD, "x: ", plot.getSouthWestCorner().getX(), ", z: ", plot.getSouthWestCorner().getY(), Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Point B: ", TextColors.GOLD, "x: ", plot.getNorthEastCorner().getX(), ", z: ", plot.getNorthEastCorner().getY()})});
        player.sendMessage(plotText.build());
    }

    public void grantPlotAtPlayerLocation(Player player, User target) throws TownsCommandException {
        TownPlot plot = this.getPlotAtPlayer(player);
        this.plotService.setTownPlotOwner(plot, this.residentService.getOrCreate(target));
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Granted the plot ", TextColors.GOLD, plot.getName(), TextColors.DARK_GREEN, " to ", TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, "."});
    }

    public void revokePlotAtPlayerLocation(Player player) throws TownsCommandException {
        TownPlot plot = this.getPlotAtPlayer(player);
        this.plotService.setTownPlotOwner(plot, null);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Revoked ownership of plot ", TextColors.GOLD, plot.getName(), TextColors.DARK_GREEN, "."});
    }

    private TownPlot getPlotAtPlayer(Player player) throws TownsCommandException {
        return this.plotService.getTownPlotByLocation((Location<World>)player.getLocation()).orElseThrow(() -> new TownsCommandException("No plot found at your position"));
    }

    private Optional<TownPlot> getPlotAtPlayerOptional(Player player) {
        return this.plotService.getTownPlotByLocation((Location<World>)player.getLocation());
    }

    public Set<TownsPermissionContext> getRelevantResidentContexts(TownPlot plot, Resident resident) {
        HashSet<TownsPermissionContext> contexts = new HashSet<TownsPermissionContext>();
        contexts.add(TownsPermissionContexts.ALL);
        Resident owner = plot.getOwner();
        if (owner != null && owner.getFriends().contains(resident)) {
            contexts.add(TownsPermissionContexts.FRIEND);
        }
        Town plotTown = plot.getTown();
        Town resTown = resident.getTown();
        if (resTown == null) {
            contexts.add(TownsPermissionContexts.NEUTRAL);
        } else {
            if (resTown == plotTown) {
                contexts.add(TownsPermissionContexts.TOWN);
            }
            Nation plotNation = plotTown.getNation();
            Nation resNation = resTown.getNation();
            if (plotNation == null || resNation == null) {
                contexts.add(TownsPermissionContexts.NEUTRAL);
            } else {
                if (resNation == plotNation || plotNation.getAllies().contains(resNation)) {
                    contexts.add(TownsPermissionContexts.ALLY);
                }
                if (plotNation.getEnemies().contains(resNation)) {
                    contexts.add(TownsPermissionContexts.ENEMY);
                }
            }
        }
        return contexts;
    }

    public boolean hasPlotAccess(User player, TownPlot plot, WorldPermission permission) {
        Resident resPlayer = this.residentService.getOrCreate(player);
        Resident plotOwner = plot.getOwner();
        Set<TownsPermissionContext> contexts = this.getRelevantResidentContexts(plot, resPlayer);
        if (plotOwner == null) {
            Tristate permissionValue = player.getPermissionValue(this.townsPermissionService.getContextsForTown(plot.getTown()), permission.getId());
            if (permissionValue.equals((Object)Tristate.UNDEFINED)) {
                return this.config.TOWN.DEFAULT_PLOT_PERMISSIONS.stream().anyMatch(p -> p.getWorldPermission().equals(permission) && contexts.contains(p.getContext()));
            }
            return permissionValue.asBoolean();
        }
        if (plotOwner == resPlayer) {
            return true;
        }
        return plot.getPermissions().stream().anyMatch(p -> p.getWorldPermission() != null && p.getWorldPermission().equals(permission) && p.getContext() != null && contexts.contains(p.getContext()));
    }

    public void plotAccessCheck(Cancellable event, User player, WorldPermission permission, Location<World> location, boolean messageUser) {
        this.plotService.getTownPlotByLocation(location).ifPresent(plot -> {
            if (!this.hasPlotAccess(player, (TownPlot)plot, permission)) {
                if (messageUser && player instanceof Player) {
                    this.townsMsg.error((MessageReceiver)player, new Object[]{"You do not have permission to do that!"});
                }
                event.setCancelled(true);
            }
        });
    }

    public void onPlayerMove(Transform<World> from, Transform<World> to, Player player) {
        Optional<TownPlot> plotTo = this.plotService.getTownPlotByLocation((Location<World>)to.getLocation());
        Optional<TownPlot> plotFrom = this.plotService.getTownPlotByLocation((Location<World>)from.getLocation());
        if (plotTo.isPresent() && !plotFrom.isPresent()) {
            player.sendTitle(Title.builder().stay(Integer.valueOf(20)).title(Text.of((Object[])new Object[]{plotTo.get().getTown().getColor(), plotTo.get().getTown().getName()})).build());
            return;
        }
        if (!plotTo.isPresent() && plotFrom.isPresent()) {
            player.sendTitle(Title.builder().stay(Integer.valueOf(20)).title(Text.of((Object[])new Object[]{TextColors.GREEN, "Wilderness"})).build());
        }
    }

    private void verifyPlotOwnership(TownPlot plot, Player player) throws TownsCommandException {
        if (plot.getOwner() == null) {
            throw new TownsCommandException("This plot does not have an owner!");
        }
        Resident resident = this.residentService.getOrCreate((User)player);
        if (!plot.getOwner().equals(resident)) {
            throw new TownsCommandException("You are not the owner of this plot!");
        }
    }

    public void addPlotPermission(Player player, TownsPermissionContext type, WorldPermission permission) throws TownsCommandException {
        TownPlot plot = this.getPlotAtPlayer(player);
        this.verifyPlotOwnership(plot, player);
        if (this.plotService.permissionAlreadyExistsInContext(type, plot, permission)) {
            throw new TownsCommandException("You have already added this permission for this group!");
        }
        this.plotService.addPlotPermission(plot, type, permission);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Added the ", TextColors.GOLD, permission.getName(), TextColors.DARK_GREEN, " permission to the ", TextColors.GOLD, type.toString(), TextColors.DARK_GREEN, " group."});
    }

    public void removePlotPermission(Player player, TownsPermissionContext type, WorldPermission permission) throws TownsCommandException {
        TownPlot plot = this.getPlotAtPlayer(player);
        this.verifyPlotOwnership(plot, player);
        if (!this.plotService.permissionAlreadyExistsInContext(type, plot, permission)) {
            throw new TownsCommandException("This permission does not exist within the specified group!");
        }
        this.plotService.removePlotPermission(plot, type, permission);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Removed the ", TextColors.GOLD, permission.getName(), TextColors.DARK_GREEN, " permission from the ", TextColors.GOLD, type.toString(), TextColors.DARK_GREEN, " group."});
    }

    public void sendPlotPermissions(Player player) {
        Text.Builder plotPermsText = Text.builder();
        plotPermsText.append(new Text[]{this.townsMsg.createTownsHeader("Plot Permissions")});
        this.permissionFacade.WORLD_PERMISSIONS.forEach((s, worldPermission) -> plotPermsText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, worldPermission.getName(), ": ", TextColors.GOLD, s, Text.NEW_LINE})}));
        player.sendMessage(plotPermsText.build());
    }

    public void sendCurrentPlotPermissions(Player player) throws TownsCommandException {
        TownPlot plot = this.getPlotAtPlayer(player);
        this.verifyPlotOwnership(plot, player);
        Text.Builder plotPermsText = Text.builder();
        plotPermsText.append(new Text[]{this.townsMsg.createTownsHeader("Plot Permissions")});
        this.permissionFacade.WORLD_PERMISSIONS.forEach((s, worldPermission) -> {
            Set<TownPlotPermission> permissions = plot.getPermissions();
            Set<Object> groups = new HashSet();
            if (permissions != null) {
                groups = permissions.stream().filter(p -> p.getWorldPermission().equals(worldPermission)).map(p -> p.getContext().getName()).collect(Collectors.toSet());
            }
            if (groups.size() > 0) {
                plotPermsText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, worldPermission.getName(), ": ", TextColors.GOLD, String.join((CharSequence)", ", groups), Text.NEW_LINE})});
            }
        });
        player.sendMessage(plotPermsText.build());
    }
}

