/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.facade.PlotBorderFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.PlotSelection;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class PlotSelectionFacade {
    private final Map<UUID, PlotSelection> selections = new HashMap<UUID, PlotSelection>();
    @Inject
    TownsMessagingFacade townMsg;
    @Inject
    PlotBorderFacade plotBorderFacade;

    private PlotSelection getOrCreateSelection(Player player) {
        if (this.selections.containsKey(player.getUniqueId())) {
            return this.selections.get(player.getUniqueId());
        }
        PlotSelection plotSelection = new PlotSelection();
        this.selections.put(player.getUniqueId(), plotSelection);
        return plotSelection;
    }

    public void clearSelection(Player player) {
        this.selections.remove(player.getUniqueId());
        this.plotBorderFacade.refreshBorders(player, (Location<World>)player.getLocation());
        this.townMsg.info((MessageReceiver)player, new Object[]{"You have cleared your selection."});
    }

    private int getPlotSelectionArea(PlotSelection plotSelection) {
        if (plotSelection == null || !plotSelection.isComplete()) {
            return -1;
        }
        return Math.abs(plotSelection.getPointA().getBlockX() - plotSelection.getPointB().getBlockX()) * Math.abs(plotSelection.getPointA().getBlockZ() - plotSelection.getPointB().getBlockZ());
    }

    private int getSmallestPlotSelectionSideSize(PlotSelection plotSelection) {
        if (plotSelection == null || !plotSelection.isComplete()) {
            return -1;
        }
        int sideX = Math.abs(plotSelection.getPointA().getBlockX() - plotSelection.getPointB().getBlockX());
        int sideZ = Math.abs(plotSelection.getPointA().getBlockZ() - plotSelection.getPointB().getBlockZ());
        return Math.min(sideX, sideZ);
    }

    public void checkBorders(Player player) {
        PlotSelection selection = this.getOrCreateSelection(player);
        if (selection.isComplete()) {
            this.plotBorderFacade.refreshBorders(player, (Location<World>)player.getLocation());
        }
    }

    private void selectPointAAtLocation(Player player, Location<World> location) {
        this.getOrCreateSelection(player).setPointA(location);
        this.checkBorders(player);
    }

    private void selectPointBAtLocation(Player player, Location<World> location) {
        this.getOrCreateSelection(player).setPointB(location);
        this.checkBorders(player);
    }

    public void selectPointAFromPlayerLocation(Player player) {
        this.selectPointAAtLocation(player, (Location<World>)player.getLocation());
        this.sendPointSelectionMessage(player, "A");
    }

    public void selectPointBFromPlayerLocation(Player player) {
        this.selectPointBAtLocation(player, (Location<World>)player.getLocation());
        this.sendPointSelectionMessage(player, "B");
    }

    private void sendPointSelectionMessage(Player player, String point) {
        Location location = player.getLocation();
        this.townMsg.info((MessageReceiver)player, new Object[]{"You have selected point", TextColors.GOLD, " ", point, " ", TextColors.DARK_GREEN, "at ", location.getBlockX(), ", ", location.getBlockY(), ", ", location.getBlockZ(), "."});
    }

    public void validatePlayerPlotSelection(Player player) throws TownsCommandException {
        PlotSelection selection = this.getCurrentPlotSelection(player);
        if (selection == null) {
            throw new TownsCommandException("Plot selection is null");
        }
        if (!selection.isComplete()) {
            throw new TownsCommandException("Plot selection is incomplete.");
        }
    }

    public boolean playerHasValidSelection(Player player) {
        try {
            this.validatePlayerPlotSelection(player);
        }
        catch (TownsCommandException e) {
            return false;
        }
        return true;
    }

    public PlotSelection getValidPlayerPlotSelection(Player player) throws TownsCommandException {
        PlotSelection selection = this.getOrCreateSelection(player);
        this.validatePlayerPlotSelection(player);
        return selection;
    }

    public PlotSelection getCurrentPlotSelection(Player player) {
        return this.getOrCreateSelection(player);
    }
}

