/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.core.utils.Question;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.event.PlayerVoteEvent;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.Poll;
import com.atherys.towns.model.Vote;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.service.PollService;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.TownService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.Identifiable;

@Singleton
public class PollFacade {
    @Inject
    private TownService townService;
    @Inject
    private PollService pollService;
    @Inject
    private ResidentService residentService;
    @Inject
    private TownsMessagingFacade townsMsg;
    @Inject
    private TownFacade townFacade;
    @Inject
    private TownsConfig config;

    PollFacade() {
    }

    private Set<Player> getPlayersByUUID(Set<UUID> uuidSet) {
        return uuidSet.stream().map(uuid -> Sponge.getServer().getPlayer(uuid)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Set<UUID> getUUIDsByPlayer(Set<Player> playerSet) {
        return playerSet.stream().map(Identifiable::getUniqueId).collect(Collectors.toSet());
    }

    private Set<Player> findNonVoters(Poll poll) {
        Set<UUID> voted = poll.getVoters().stream().filter(uuid -> poll.getVotes().stream().noneMatch(vote -> vote.getVoter() == uuid)).collect(Collectors.toSet());
        return this.getPlayersByUUID(voted);
    }

    public void sendPollPartyMessage(Set<Player> party, Text msg) {
        party.forEach(player -> this.townsMsg.info((MessageReceiver)player, new Object[]{msg}));
    }

    private void postVoteEvent(Player player, boolean voteResult, UUID pollId) {
        Vote vote = new Vote();
        vote.setVotedYes(voteResult);
        vote.setVoter(player.getUniqueId());
        vote.setPollId(pollId);
        this.pollService.addVoteToPoll(vote, pollId);
        Sponge.getEventManager().post((Event)new PlayerVoteEvent(player, vote));
    }

    private Question generateTownPoll(String townName, String mayorName, UUID id) {
        Text.Builder invitationText = Text.builder();
        Text townText = Text.of((Object[])new Object[]{TextColors.GOLD, townName, TextColors.DARK_GREEN, "?"});
        Text mayorText = Text.of((Object[])new Object[]{TextColors.GOLD, mayorName, TextColors.DARK_GREEN});
        invitationText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Do you wish to help ", mayorText, TextColors.DARK_GREEN, " create the town of ", townText, Text.NEW_LINE})});
        invitationText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, "Warning! ", TextColors.RED, "If you are currently in a town, you will be removed."})});
        return Question.of((Text)invitationText.build()).addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextStyles.BOLD, TextColors.DARK_GREEN, "Yes"}), player -> this.postVoteEvent((Player)player, true, id))).addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextStyles.BOLD, TextColors.DARK_RED, "No"}), player -> this.postVoteEvent((Player)player, false, id))).build();
    }

    private Text getPollInfo(Poll poll) {
        String voterList = String.join((CharSequence)",", this.getPlayersByUUID(poll.getVoters()).stream().map(User::getName).collect(Collectors.toSet()));
        Text.Builder pollText = Text.builder();
        Text townText = Text.of((Object[])new Object[]{TextColors.GOLD, poll.getPollName(), TextColors.DARK_GREEN});
        pollText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Vote has met minimum required residents that voted yes. Would you like to create ", townText, " now?", Text.NEW_LINE})});
        pollText.append(new Text[]{this.townsMsg.createTownsHeader(poll.getPollName())}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Votes Collected: ", TextColors.GOLD, poll.getVotes().size(), " of ", poll.getVoters().size(), Text.NEW_LINE})});
        pollText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Voters: ", TextColors.GOLD, voterList, Text.NEW_LINE})});
        return pollText.build();
    }

    private Question generateMayorQuestion(Poll poll) {
        Question.Builder mayorQuestion = Question.of((Text)this.getPollInfo(poll)).addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextStyles.BOLD, TextColors.DARK_GREEN, "Yes"}), player -> this.createTownFromPoll(poll))).addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextStyles.BOLD, TextColors.DARK_RED, "No"}), player -> {
            Text creationDenied = Text.of((Object[])new Object[]{TextColors.RED, "Mayor has denied creation of the town, Poll cancelled."});
            this.sendPollPartyMessage(this.getPlayersByUUID(poll.getVoters()), creationDenied);
            Sponge.getServer().getPlayer(poll.getCreator()).ifPresent(mayor -> this.townsMsg.info((MessageReceiver)mayor, new Object[]{creationDenied}));
            this.pollService.deletePoll(poll.getId());
        }));
        if (poll.getVoters().size() > poll.getVotes().size()) {
            mayorQuestion.addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextStyles.BOLD, TextColors.DARK_GREEN, "Wait for more"}), player -> {
                poll.setPassed(false);
                Optional mayor = Sponge.getServer().getPlayer(poll.getCreator());
                mayor.ifPresent(value -> this.findNonVoters(poll).forEach(player1 -> this.generateTownPoll(poll.getPollName(), value.getName(), poll.getId()).pollChat(player1)));
            }));
        }
        return mayorQuestion.build();
    }

    public void createTownFromPoll(Poll poll) {
        Optional mayor = Sponge.getServer().getPlayer(poll.getCreator());
        if (mayor.isPresent()) {
            try {
                Town town = this.townFacade.createTown((Player)mayor.get(), poll.getPollName(), poll.getHomePlot(), poll.getNation());
                for (Player player : this.getPlayersByUUID(poll.getVoters())) {
                    if (this.residentService.getOrCreate((User)player).getTown() != null) {
                        this.townFacade.leaveTown(player);
                    }
                    this.townService.addResidentToTown((User)player, this.residentService.getOrCreate((User)player), town);
                    this.townsMsg.info((MessageReceiver)player, new Object[]{"You have been added as a resident to the town of ", TextColors.GOLD, poll.getPollName(), "."});
                }
            }
            catch (CommandException e) {
                ((Player)mayor.get()).sendMessage(Objects.requireNonNull(e.getText()));
            }
        }
        this.pollService.deletePoll(poll.getId());
    }

    public void sendCreateTownPoll(String townName, Set<Player> voters, Player mayor, TownPlot homePlot, Nation nation) {
        voters.remove(mayor);
        UUID pollId = this.pollService.createPoll(mayor.getUniqueId(), townName, this.getUUIDsByPlayer(voters), homePlot, nation);
        Text startPollMsg = Text.of((Object[])new Object[]{"A vote to found the town of ", TextColors.GOLD, townName, TextColors.DARK_GREEN, " has begun!"});
        this.sendPollPartyMessage(voters, startPollMsg);
        this.townsMsg.info((MessageReceiver)mayor, new Object[]{startPollMsg});
        voters.forEach(player -> this.generateTownPoll(townName, mayor.getName(), pollId).pollChat(player));
    }

    public void onPlayerVote(PlayerVoteEvent event) {
        Vote vote = event.getVote();
        Poll poll = this.pollService.getPollById(vote.getPollId());
        Optional mayor = Sponge.getServer().getPlayer(poll.getCreator());
        boolean hasEnoughResidents = poll.getVotes().stream().filter(Vote::hasVotedYes).count() + 1L >= (long)this.config.MIN_RESIDENTS_TOWN_CREATE;
        boolean isVoteOver = poll.getVoters().size() == poll.getVotes().size();
        boolean townAlreadyCreated = this.townService.getTownFromName(poll.getPollName()).isPresent();
        Sponge.getServer().getPlayer(vote.getVoter()).ifPresent(voterPlayer -> {
            Text.Builder voteText = Text.builder();
            voteText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, voterPlayer.getName(), " has voted "})});
            voteText.append(new Text[]{vote.hasVotedYes() ? Text.of((Object[])new Object[]{TextColors.GREEN, "Yes"}) : Text.of((Object[])new Object[]{TextColors.RED, "No"})});
            this.townsMsg.info((MessageReceiver)voterPlayer, new Object[]{voteText});
            mayor.ifPresent(mayorPlayer -> this.townsMsg.info((MessageReceiver)mayorPlayer, new Object[]{voteText}));
        });
        if (isVoteOver && hasEnoughResidents && !townAlreadyCreated) {
            mayor.ifPresent(player -> this.generateMayorQuestion(poll).pollChat((Player)mayor.get()));
        } else if (isVoteOver) {
            Text notEnoughText = Text.of((Object[])new Object[]{TextColors.RED, "Not enough residents voted yes. Town creation has failed!"});
            this.sendPollPartyMessage(this.getPlayersByUUID(poll.getVoters()), notEnoughText);
            mayor.ifPresent(player -> this.townsMsg.info((MessageReceiver)player, new Object[]{notEnoughText}));
            this.pollService.deletePoll(poll.getId());
        } else if (hasEnoughResidents && !poll.getPassed() && vote.hasVotedYes()) {
            poll.setPassed(true);
            mayor.ifPresent(player -> this.generateMayorQuestion(poll).pollChat((Player)mayor.get()));
        }
    }
}

