/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.core.utils.UserUtils;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.facade.NationFacade;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.service.PlotService;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.RoleService;
import com.atherys.towns.service.TownsPermissionService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class ResidentFacade {
    @Inject
    private ResidentService residentService;
    @Inject
    private RoleService roleService;
    @Inject
    private TownsPermissionService townsPermissionService;
    @Inject
    private PlotService plotService;
    @Inject
    private TownsMessagingFacade townsMsg;
    @Inject
    private NationFacade nationFacade;
    @Inject
    private TownFacade townFacade;
    @Inject
    private TownsConfig config;

    ResidentFacade() {
    }

    public void onLogin(Player player) {
        Resident resident = this.residentService.getOrCreate((User)player);
        this.residentService.setLastTownSpawn(resident, LocalDateTime.now());
        this.residentService.setLastLogin(resident, LocalDateTime.now());
        this.roleService.validateRoles((User)player, resident);
        this.townsPermissionService.updateContexts((User)player, resident);
        Town currentTown = this.plotService.getTownPlotByLocation((Location<World>)player.getLocation()).map(TownPlot::getTown).orElse(null);
        this.townsPermissionService.updateWorldContexts(player, currentTown);
    }

    public void onPlayerSpawn(RespawnPlayerEvent event) {
        Town town = this.residentService.getOrCreate((User)event.getOriginalPlayer()).getTown();
        if (town != null) {
            event.setToTransform(town.getSpawn());
        }
    }

    public void sendResidentInfo(Player player) {
        this.sendResidentInfo((MessageReceiver)player, this.residentService.getOrCreate((User)player));
    }

    public void sendResidentInfo(MessageReceiver receiver, User target) throws TownsCommandException {
        this.sendResidentInfo(receiver, this.residentService.getOrCreate(target));
    }

    public void sendResidentInfo(MessageReceiver receiver, Resident resident) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(Locale.UK).withZone(ZoneId.systemDefault());
        boolean online = Sponge.getServer().getPlayer(resident.getUniqueId()).isPresent();
        Text status = online ? Text.of((Object[])new Object[]{TextColors.GREEN, "Online"}) : Text.of((Object[])new Object[]{TextColors.RED, "Offline"});
        Text title = Text.of((Object[])new Object[]{TextColors.GOLD, resident.getName(), TextColors.DARK_GRAY, " (", status, TextColors.DARK_GRAY, ")"});
        String padding = StringUtils.repeat((String)"=", (int)this.townsMsg.getPadding(title.toPlain().length()));
        String lastPlayed = formatter.format((TemporalAccessor)((User)UserUtils.getUser((UUID)resident.getId()).get()).get(Keys.LAST_DATE_PLAYED).get());
        Text.Builder residentInfo = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GRAY, "[]", padding, "[ ", title, TextColors.DARK_GRAY, " ]", padding, "[]", Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Town: ", this.townFacade.renderTown(resident.getTown()), Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Last online: ", TextColors.GOLD, lastPlayed, Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "First online: ", TextColors.GOLD, formatter.format(resident.getRegisteredOn()), Text.NEW_LINE})}).append(new Text[]{this.townsMsg.renderBank(resident.getId())});
        if (!resident.getFriends().isEmpty()) {
            residentInfo.append(new Text[]{Text.of((Object[])new Object[]{Text.NEW_LINE, TextColors.DARK_GREEN, "Friends: ", TextColors.GOLD, this.renderResidents(resident.getFriends())})});
        }
        receiver.sendMessage(residentInfo.build());
    }

    public Text renderResident(Resident resident) {
        return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{this.isResidentActive(resident) ? TextColors.GOLD : TextColors.GRAY, resident.getName()})}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, resident.getName(), Text.NEW_LINE, TextColors.DARK_GREEN, "Town: ", TextColors.GOLD, resident.getTown() == null ? "No Town" : resident.getTown().getName(), Text.NEW_LINE, this.townsMsg.renderBank(resident.getId()), Text.NEW_LINE, TextColors.DARK_GRAY, "Click to view"}))).onClick((ClickAction)TextActions.executeCallback(source -> this.sendResidentInfo((MessageReceiver)source, resident))).build();
    }

    public boolean isResidentActive(Resident resident) {
        return Duration.between(resident.getLastLogin(), LocalDateTime.now()).compareTo(this.config.TAXES.INACTIVE_DURATION) < 0;
    }

    public Text renderResidents(Collection<Resident> residents) {
        Text.Builder residentsText = Text.builder();
        int i = 0;
        for (Resident resident : residents) {
            residentsText.append(new Text[]{Text.of((Object[])new Object[]{this.renderResident(resident), ++i == residents.size() || i == this.config.MAX_RESIDENTS_DISPLAY ? "" : ", "})});
            if (i != this.config.MAX_RESIDENTS_DISPLAY) continue;
            residentsText.append(new Text[]{Text.of((String)"..")});
        }
        return residentsText.build();
    }

    public void addResidentFriend(Player player, User target) throws TownsCommandException {
        if (player.getUniqueId().equals(target.getUniqueId())) {
            throw new TownsCommandException("Cannot add yourself as a friend.");
        }
        this.residentService.addResidentFriend(this.residentService.getOrCreate((User)player), this.residentService.getOrCreate(target));
        this.townsMsg.info((MessageReceiver)player, new Object[]{TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, " was added as a friend."});
    }

    public void removeResidentFriend(Player player, User target) throws TownsCommandException {
        Resident resident = this.residentService.getOrCreate((User)player);
        Resident residentFriend = this.residentService.getOrCreate(target);
        if (resident.getFriends().contains(residentFriend)) {
            this.residentService.removeResidentFriend(resident, residentFriend);
            this.townsMsg.info((MessageReceiver)player, new Object[]{TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, " was removed from your friends."});
        } else {
            this.townsMsg.error((MessageReceiver)player, new Object[]{target.getName(), " is not your friend."});
        }
    }

    public Optional<Town> getPlayerTown(Player player) {
        return Optional.ofNullable(this.residentService.getOrCreate((User)player).getTown());
    }

    public Optional<Nation> getPlayerNation(Player player) {
        return this.getPlayerTown(player).map(Town::getNation);
    }
}

