/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.core.economy.Economy;
import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.service.TaxService;
import com.atherys.towns.service.TownService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransferResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

@Singleton
public class TaxFacade {
    @Inject
    private TownsConfig config;
    @Inject
    private TaxService taxService;
    @Inject
    private TownService townService;
    private Task townTaxTask;

    public void init() {
        if (AtherysTowns.economyIsEnabled() && this.config.TAXES.IS_ENABLED) {
            this.townTaxTask = Task.builder().execute(this::taxTowns).interval(this.config.TAXES.TAX_TIMER_INTERVAL.toMinutes(), TimeUnit.MINUTES).submit((Object)AtherysTowns.getInstance());
        }
    }

    public void taxTowns() {
        HashSet townsToRemove = new HashSet();
        TownsMessagingFacade townsMsg = AtherysTowns.getInstance().getTownsMessagingService();
        AtherysTowns.getInstance().getLogger().info("Running Tax Cycle");
        for (Town town : this.taxService.getTaxableTowns()) {
            AtherysTowns.getInstance().getLogger().info("Taxing Town: " + town.getName());
            double taxPaymentAmount = Math.floor(this.taxService.getTaxAmount(town));
            Account townBank = (Account)Economy.getAccount((String)town.getBank().toString()).get();
            double townBalance = townBank.getBalance(this.config.DEFAULT_CURRENCY).doubleValue();
            Optional<TransferResult> result = this.taxService.payTaxes(town, taxPaymentAmount);
            result.ifPresent(transferResult -> {
                town.setLastTaxDate(LocalDateTime.now());
                if (transferResult.getResult() == ResultType.SUCCESS) {
                    townsMsg.broadcastTownInfo(town, Text.of((Object[])new Object[]{"Paid ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(taxPaymentAmount)), TextColors.DARK_GREEN, " to ", TextColors.GOLD, town.getNation().getName(), TextColors.DARK_GREEN, " in taxes."}));
                    this.taxService.setTaxesPaid(town, true);
                } else if (transferResult.getResult() == ResultType.FAILED || transferResult.getResult() == ResultType.ACCOUNT_NO_FUNDS) {
                    if (town.getTaxFailedCount() >= this.config.TAXES.MAX_TAX_FAILURES) {
                        townsMsg.broadcastTownError(town, Text.of((Object[])new Object[]{"Failure to pay taxes has resulted in your ", "town being ruined!"}));
                        townsToRemove.add(town);
                    } else {
                        townsMsg.broadcastTownError(town, Text.of((Object[])new Object[]{"You have failed to pay your taxes!", " If not paid by next tax cycle your town will be ruined!", " Town features have been limited until paid off."}));
                        this.taxService.setTaxesPaid(town, false);
                        this.taxService.payTaxes(town, townBalance);
                        this.townService.addTownDebt(town, taxPaymentAmount - townBalance);
                    }
                }
            });
        }
        townsToRemove.forEach(this.townService::removeTown);
    }

    public Text renderTax(Town town) {
        double pvpMultiplier;
        double nationMultiplier;
        Text.Builder taxText = Text.builder();
        if (!this.config.TAXES.IS_ENABLED || !this.taxService.isTaxable(town)) {
            return taxText.build();
        }
        Text.Builder nextPaymentText = Text.builder();
        double townTotalTax = this.taxService.getTaxAmount(town);
        double townTotalTaxLessDebt = townTotalTax - town.getDebt();
        nextPaymentText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Next Tax Payment: ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(townTotalTax)), Text.NEW_LINE})});
        Text.Builder hoverText = Text.builder();
        hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Base Tax: ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(this.taxService.calcBaseTax(town))), Text.NEW_LINE})});
        double d = nationMultiplier = town.getNation() == null ? 1.0 : town.getNation().getTax();
        if (nationMultiplier != 1.0) {
            double nationTax = townTotalTaxLessDebt - townTotalTaxLessDebt / nationMultiplier;
            String taxType = nationTax > 0.0 ? "Tax" : "Rebate";
            hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Nation ", taxType, ": ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(nationTax)), Text.NEW_LINE})});
        }
        hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Area Tax: ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(this.taxService.calcAreaTax(town))), Text.NEW_LINE})});
        hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Resident Tax: ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(this.taxService.calcResidentTax(town))), Text.NEW_LINE})});
        double d2 = pvpMultiplier = town.isPvpEnabled() ? 1.0 : this.config.TAXES.PVP_TAX_MODIFIER;
        if (pvpMultiplier != 1.0) {
            double pvpPenalty = townTotalTaxLessDebt - townTotalTaxLessDebt / pvpMultiplier;
            hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "PVP Penalty: ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(pvpPenalty)), Text.NEW_LINE})});
        }
        if (town.getDebt() > 0.0) {
            hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Debt: ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(town.getDebt())), Text.NEW_LINE})});
        }
        hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Due: ", TextColors.GOLD})});
        LocalDateTime next = town.getLastTaxDate().plus(this.config.TAXES.TAX_COLLECTION_DURATION);
        Duration until = Duration.between(LocalDateTime.now(), next);
        if (until.isNegative()) {
            hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.RED, "Now"})});
        } else {
            String format = "H'h 'm'm 's's'";
            if (until.toDays() > 0L) {
                format = "d'd '" + format;
            }
            hoverText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, DurationFormatUtils.formatDuration((long)until.toMillis(), (String)format)})});
        }
        nextPaymentText.onHover((HoverAction)TextActions.showText((Text)hoverText.build()));
        taxText.append(new Text[]{nextPaymentText.build()});
        if (town.getDebt() > 0.0) {
            taxText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Debt Owed: ", TextColors.RED, this.config.DEFAULT_CURRENCY.format(BigDecimal.valueOf(town.getDebt())), Text.NEW_LINE})});
        }
        return taxText.build();
    }
}

