/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.service.TownService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.channel.MessageReceiver;

@Singleton
public class TownAdminFacade {
    @Inject
    TownService townService;
    @Inject
    TownsMessagingFacade townsMsg;

    public void decreaseTownSize(CommandSource source, String townName, int amount) throws TownsCommandException {
        Town town = this.townService.getTownFromName(townName).orElseThrow(() -> TownsCommandException.townNotFound(townName));
        if (town.getMaxSize() - amount > this.townService.getTownSize(town)) {
            this.townService.decreaseTownSize(town, amount);
            this.townsMsg.info((MessageReceiver)source, new Object[]{"Town size decreased."});
        } else {
            this.townsMsg.error((MessageReceiver)source, new Object[]{"Town size could not be decreased. You are trying to decrease by too much."});
        }
    }

    public void increaseTownSize(CommandSource source, String townName, int amount) throws TownsCommandException {
        Town town = this.townService.getTownFromName(townName).orElseThrow(() -> TownsCommandException.townNotFound(townName));
        this.townService.increaseTownSize(town, amount);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Town size increased."});
    }
}

