/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.core.economy.Economy;
import com.atherys.core.utils.Question;
import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.api.permission.town.TownPermission;
import com.atherys.towns.api.permission.town.TownPermissions;
import com.atherys.towns.facade.EconomyFacade;
import com.atherys.towns.facade.NationFacade;
import com.atherys.towns.facade.PermissionFacade;
import com.atherys.towns.facade.PlotBorderFacade;
import com.atherys.towns.facade.PlotSelectionFacade;
import com.atherys.towns.facade.PollFacade;
import com.atherys.towns.facade.ResidentFacade;
import com.atherys.towns.facade.TaxFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.integration.AtherysPartiesIntegration;
import com.atherys.towns.model.PlotSelection;
import com.atherys.towns.model.entity.Nation;
import com.atherys.towns.model.entity.NationPlot;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.model.entity.TownPlot;
import com.atherys.towns.service.PlotService;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.RoleService;
import com.atherys.towns.service.TaxService;
import com.atherys.towns.service.TownService;
import com.atherys.towns.service.TownsPermissionService;
import com.atherys.towns.util.MathUtils;
import com.flowpowered.math.vector.Vector2i;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.service.economy.transaction.TransferResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class TownFacade
implements EconomyFacade {
    @Inject
    private PlotSelectionFacade plotSelectionFacade;
    @Inject
    private PlotService plotService;
    @Inject
    private TownService townService;
    @Inject
    private PollFacade pollFacade;
    @Inject
    private ResidentService residentService;
    @Inject
    private RoleService roleService;
    @Inject
    private TownsMessagingFacade townsMsg;
    @Inject
    private TownsConfig config;
    @Inject
    private ResidentFacade residentFacade;
    @Inject
    private NationFacade nationFacade;
    @Inject
    private TaxFacade taxFacade;
    @Inject
    private PermissionFacade permissionFacade;
    @Inject
    private PlotBorderFacade plotBorderFacade;
    @Inject
    private TownsPermissionService townsPermissionService;
    @Inject
    private TaxService taxService;

    TownFacade() {
    }

    public boolean isTownTaxDue(Town town) {
        return town.getTaxFailedCount() > 0;
    }

    public void createTownOrPoll(Player player, String townName) throws CommandException {
        int centerZ;
        int centerX;
        double distance;
        if (townName == null || townName.isEmpty()) {
            throw new TownsCommandException("Must provide a town name.");
        }
        if (this.townService.getTownFromName(townName).isPresent()) {
            throw new TownsCommandException("A town with that name already exists.");
        }
        if (townName.length() > this.config.TOWN.MAX_TOWN_NAME_LENGTH) {
            throw new TownsCommandException("Your new name is longer than the maximum (", this.config.TOWN.MAX_TOWN_NAME_LENGTH, ").");
        }
        Resident resident = this.residentService.getOrCreate((User)player);
        if (this.hasPlayerTown(player) && this.residentService.isResidentTownLeader(resident, resident.getTown())) {
            throw new TownsCommandException("You are already a town leader!");
        }
        Nation nation = null;
        Optional plot = this.plotService.getNationPlotsByLocation((Location<World>)player.getLocation()).stream().findFirst();
        if (plot.isPresent()) {
            nation = ((NationPlot)plot.get()).getNation();
        }
        if (nation == null && !this.permissionFacade.isPermitted(player, TownPermissions.CREATE_WITHOUT_NATION)) {
            throw new TownsCommandException("You are not permitted to create a town outside of a nation!");
        }
        PlotSelection selection = this.plotSelectionFacade.getValidPlayerPlotSelection(player);
        TownPlot homePlot = this.plotService.createTownPlotFromSelection(selection);
        this.validateNewTownPlot(homePlot, player, (Location<World>)player.getLocation());
        Optional<TownPlot> closestPlot = this.plotService.getClosestTownPlot(homePlot);
        if (closestPlot.isPresent() && (distance = MathUtils.getDistanceToPlotSquared(Vector2i.from((int)(centerX = (homePlot.getNorthEastCorner().getX() + homePlot.getSouthWestCorner().getX()) / 2), (int)(centerZ = (homePlot.getNorthEastCorner().getY() + homePlot.getSouthWestCorner().getY()) / 2)), closestPlot.get())) < Math.pow(this.config.TOWN.MIN_CREATION_DISTANCE, 2.0)) {
            throw new TownsCommandException("This plot is too close to an existing town. (Min distance " + this.config.TOWN.MIN_CREATION_DISTANCE + ")");
        }
        if (!Sponge.getPluginManager().isLoaded("atherysparties") || this.permissionFacade.isPermitted(player, TownPermissions.CREATE_WITHOUT_PARTY)) {
            this.createTown(player, townName, homePlot, nation);
        } else if (AtherysPartiesIntegration.playerHasParty(player)) {
            Set<Player> partyMembers = AtherysPartiesIntegration.fetchPlayerPartyMembers(player);
            if (partyMembers.size() < this.config.MIN_RESIDENTS_TOWN_CREATE) {
                throw new TownsCommandException("Your party does not have enough members (Min: " + this.config.MIN_RESIDENTS_TOWN_CREATE + ").");
            }
            partyMembers.removeAll(partyMembers.stream().filter(this::isLeaderOfPlayerTown).collect(Collectors.toSet()));
            this.pollFacade.sendCreateTownPoll(townName, partyMembers, player, homePlot, nation);
        } else {
            throw new TownsCommandException("You require a party to form a town!");
        }
    }

    public Town createTown(Player player, String name, TownPlot homePlot, @Nullable Nation nation) throws CommandException {
        Resident mayor = this.residentService.getOrCreate((User)player);
        if (AtherysTowns.economyIsEnabled()) {
            Account account = (Account)Economy.getAccount((UUID)player.getUniqueId()).get();
            Cause cause = Sponge.getCauseStackManager().getCurrentCause();
            TransactionResult result = account.withdraw(this.config.DEFAULT_CURRENCY, BigDecimal.valueOf(this.config.TOWN.CREATION_COST), cause);
            if (result.getResult() == ResultType.FAILED || result.getResult() == ResultType.ACCOUNT_NO_FUNDS) {
                throw new TownsCommandException("You lack the funds to create a town. ", this.config.TOWN.CREATION_COST, " ", this.config.DEFAULT_CURRENCY.getPluralDisplayName(), " are required.");
            }
        }
        Town town = this.townService.createTown(player, homePlot, name, nation);
        this.townsPermissionService.updateContexts((User)player, mayor);
        this.sendTownInfo(town, (MessageReceiver)player);
        this.townsMsg.broadcastInfo(TextColors.GOLD, player.getName(), TextColors.DARK_GREEN, " has created the town of ", TextColors.GOLD, town.getName(), TextColors.DARK_GREEN, ".");
        this.plotSelectionFacade.clearSelection(player);
        return town;
    }

    public void grantTown(Player player, User target) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        Resident newMayor = this.residentService.getOrCreate(target);
        Resident oldMayor = this.residentService.getOrCreate((User)player);
        if (!this.residentService.isResidentTownLeader(oldMayor, town) || !this.partOfSameTown((User)player, target)) {
            throw new TownsCommandException("The player you are granting leadership to is either not in your town, or you are not the town leader.");
        }
        this.roleService.removeTownRole((User)player, town, this.config.TOWN.TOWN_LEADER_ROLE);
        this.townService.setTownLeader(town, newMayor, target);
        this.townsMsg.broadcastTownInfo(town, TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, " is now the mayor of ", TextColors.GOLD, town.getName(), ".");
    }

    public void sendTownInfo(Player player) throws TownsCommandException {
        this.sendTownInfo(this.getPlayerTown(player), (MessageReceiver)player);
    }

    public void setPlayerTownName(Player source, String name) throws TownsCommandException {
        if (name == null || name.isEmpty()) {
            throw new TownsCommandException("Must provide a new town name.");
        }
        Town town = this.getPlayerTown(source);
        this.townService.setTownName(town, name);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Town name set."});
    }

    public void setPlayerTownDescription(Player player, Text description) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        this.townService.setTownDescription(town, description);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Town description set."});
    }

    public void setPlayerTownColor(Player player, TextColor color) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        this.townService.setTownColor(town, color);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Town color set."});
    }

    public void setPlayerTownMotd(Player player, Text motd) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        this.townService.setTownMotd(town, motd);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Town motd set."});
    }

    public void setPlayerTownPvp(Player player, boolean pvp) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        if (this.isTownTaxDue(town)) {
            throw new TownsCommandException("Unable to change PvP status as taxes are unpaid!");
        }
        this.townService.setTownPvp(town, pvp);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Your town now has PvP ", pvp ? "enabled." : "disabled."});
    }

    public void setPlayerTownJoinable(Player player, boolean joinable) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        this.townService.setTownJoinable(town, joinable);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Your town is now ", joinable ? "freely joinable." : "not freely joinable."});
    }

    public void ruinPlayerTown(Player player) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        Resident resident = this.residentService.getOrCreate((User)player);
        if (town.getNation() != null && town.getNation().getCapital().equals(town)) {
            throw new TownsCommandException("Nation capitals cannot be ruined.");
        }
        if (!this.residentService.isResidentTownLeader(resident, town)) {
            throw new TownsCommandException("Only the town leader may remove the town.");
        }
        Question confirmation = Question.of((Text)Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Are you sure you want to delete your town?"})).addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Yes"}), p -> {
            this.townService.removeTown(town);
            this.plotBorderFacade.removeBordersForTown(town);
            this.townsMsg.info((MessageReceiver)player, new Object[]{"Town ruined."});
        })).addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextColors.RED, "No"}), p -> this.townsMsg.error((MessageReceiver)p, new Object[]{"Town deletion cancelled."}))).build();
        confirmation.pollChat(player);
    }

    public Town getPlayerTown(Player source) throws TownsCommandException {
        Town town = this.residentService.getOrCreate((User)source).getTown();
        if (town == null) {
            throw TownsCommandException.notPartOfTown();
        }
        return town;
    }

    public void validateNewTownPlot(TownPlot plot, Player player, Location<World> location) throws TownsCommandException {
        Optional<NationPlot> nPlot;
        int plotArea = MathUtils.getArea(plot);
        if (plotArea > this.config.TOWN.MAX_PLOT_AREA) {
            throw new TownsCommandException("Plot selection has an area greater than permitted ( ", plotArea, " > ", this.config.TOWN.MAX_PLOT_AREA, " )");
        }
        int smallestSide = MathUtils.getShortestSide(plot);
        if (smallestSide < this.config.TOWN.MIN_PLOT_SIDE - 1) {
            throw new TownsCommandException("Plot selection has a side smaller than permitted ( ", smallestSide, " < ", this.config.TOWN.MIN_PLOT_SIDE, " )");
        }
        if (this.plotService.townPlotIntersectAnyOthers(plot)) {
            throw new TownsCommandException("The plot selection intersects with an already-existing plot.");
        }
        if (!this.plotService.isLocationWithinPlot(location, plot)) {
            throw new TownsCommandException("You must be within your plot selection!");
        }
        Town town = this.residentService.getOrCreate((User)player).getTown();
        if (town != null) {
            if (this.isTownTaxDue(town)) {
                throw new TownsCommandException("Plot claiming has been disabled due to unpaid taxes!");
            }
            if (this.townService.getTownSize(town) + MathUtils.getArea(plot) > town.getMaxSize()) {
                throw new TownsCommandException("The plot you are claiming is larger than your town's remaining max area.");
            }
            if (!this.plotService.townPlotBordersTown(town, plot)) {
                throw new TownsCommandException("New plot does not border the town it's being claimed for.");
            }
        }
        if ((nPlot = this.plotService.getNationPlotsByTownPlot(plot)).isPresent() && !MathUtils.rectangleContainedInSet(plot, nPlot.get().getNation().getPlots())) {
            throw new TownsCommandException("New plot is not contained completely within the nation.");
        }
    }

    public boolean isValidNewTownPlot(TownPlot plot, Player player, Location<World> location, boolean messageUser) {
        try {
            this.validateNewTownPlot(plot, player, location);
        }
        catch (TownsCommandException e) {
            if (messageUser && e.getText() != null) {
                player.sendMessage(e.getText());
            }
            return false;
        }
        return true;
    }

    public void abandonTownPlotAtPlayerLocation(Player source) throws TownsCommandException {
        Town town = this.getPlayerTown(source);
        TownPlot plot = this.plotService.getTownPlotByLocation((Location<World>)source.getLocation()).orElseThrow(() -> new TownsCommandException("You are not currently standing on a claim area."));
        if (town.getPlots().size() == 1) {
            throw new TownsCommandException("You cannot unclaim your last remaining plot.");
        }
        if (this.townService.checkPlotRemovalCreatesOrphans(town, plot)) {
            throw new TownsCommandException("You cannot unclaim a plot that would result in orphaned plots.");
        }
        this.townService.removePlotFromTown(town, plot);
        this.plotBorderFacade.removeSelectionBorder(source, plot);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Plot abandoned."});
    }

    public void claimTownPlotFromPlayerSelection(Player source) throws CommandException {
        PlotSelection selection = this.plotSelectionFacade.getValidPlayerPlotSelection(source);
        Town town = this.getPlayerTown(source);
        TownPlot plot = this.plotService.createTownPlotFromSelection(selection);
        this.validateNewTownPlot(plot, source, (Location<World>)source.getLocation());
        this.townService.claimPlotForTown(plot, town);
        this.plotSelectionFacade.clearSelection(source);
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Plot claimed."});
    }

    public void inviteToTown(Player source, Player invitee) throws TownsCommandException {
        Town town = this.getPlayerTown(source);
        if (this.partOfSameTown((User)source, (User)invitee)) {
            throw new TownsCommandException(invitee.getName(), " is already part of your town.");
        }
        this.generateTownInvite(town).pollChat(invitee);
    }

    private Question generateTownInvite(Town town) {
        Text townText = Text.of((Object[])new Object[]{TextColors.GOLD, town.getName(), TextColors.DARK_GREEN, "."});
        Text invitationText = this.townsMsg.formatInfo(new Object[]{"You have been invited to the town ", townText});
        return Question.of((Text)invitationText).addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextStyles.BOLD, TextColors.DARK_GREEN, "Accept"}), player -> {
            this.townService.addResidentToTown((User)player, this.residentService.getOrCreate((User)player), town);
            this.joinTownMessage((Player)player, town);
        })).addAnswer(Question.Answer.of((Text)Text.of((Object[])new Object[]{TextStyles.BOLD, TextColors.DARK_RED, "Decline"}), player -> {})).build();
    }

    public void kickFromTown(Player player, User target) throws TownsCommandException {
        Resident resident;
        Town town = this.getPlayerTown(player);
        if (town.equals((resident = this.residentService.getOrCreate(target)).getTown())) {
            if (town.getLeader().equals(resident)) {
                throw new TownsCommandException("You cannot kick the leader of the town.");
            }
        } else {
            throw new TownsCommandException(target.getName(), " is not part of your town.");
        }
        this.townService.removeResidentFromTown((User)player, resident, town);
        this.townsMsg.info((MessageReceiver)player, new Object[]{TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, " was kicked from the town."});
    }

    public void joinTown(Player player, Town town) throws TownsCommandException {
        if (!town.isFreelyJoinable()) {
            throw new TownsCommandException(Text.of((Object[])new Object[]{town.getName(), " is not freely joinable."}));
        }
        this.townService.addResidentToTown((User)player, this.residentService.getOrCreate((User)player), town);
        this.joinTownMessage(player, town);
    }

    public void leaveTown(Player player) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        Resident resident = this.residentService.getOrCreate((User)player);
        if (town.getLeader().equals(resident)) {
            throw new TownsCommandException("The town leader cannot leave the town.");
        }
        this.townService.removeResidentFromTown((User)player, resident, town);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"You have left the town ", TextColors.GOLD, town.getName(), TextColors.DARK_GREEN, "."});
    }

    public void addTownPermission(Player source, User target, TownPermission permission) throws TownsCommandException {
    }

    public void removeTownPermission(Player source, User target, TownPermission permission) throws TownsCommandException {
    }

    public void addTownRole(Player source, User target, String role) throws TownsCommandException {
        Town town = this.getPlayerTown(source);
        if (!this.partOfSameTown((User)source, target)) {
            throw new TownsCommandException("");
        }
        this.roleService.addTownRole(target, town, role);
        this.townsMsg.info((MessageReceiver)source, new Object[]{TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, " was granted the role ", TextColors.GOLD, role, "."});
    }

    public void removeTownRole(Player source, User target, String role) throws TownsCommandException {
        Town town = this.getPlayerTown(source);
        if (!this.partOfSameTown((User)source, target)) {
            throw new TownsCommandException("");
        }
        this.roleService.removeTownRole(target, town, role);
        this.townsMsg.info((MessageReceiver)source, new Object[]{TextColors.GOLD, target.getName(), TextColors.DARK_GREEN, " had the role ", TextColors.GOLD, role, TextColors.DARK_GREEN, " revoked."});
    }

    private boolean partOfSameTown(User user, User other) {
        Town town = this.residentService.getOrCreate(user).getTown();
        Town otherTown = this.residentService.getOrCreate(other).getTown();
        return town != null && town.equals(otherTown);
    }

    public void depositToTown(Player player, BigDecimal amount) throws TownsCommandException {
        this.checkEconomyEnabled();
        Town town = this.getPlayerTown(player);
        if (this.config.TOWN.LOCAL_TRANSACTIONS && !this.playerInsideTown(player, town)) {
            throw new TownsCommandException("You must be inside your town to deposit.");
        }
        Optional result = Economy.transferCurrency((UUID)player.getUniqueId(), (String)town.getBank().toString(), (Currency)this.config.DEFAULT_CURRENCY, (BigDecimal)amount, (Cause)Sponge.getCauseStackManager().getCurrentCause());
        if (result.isPresent()) {
            Text feedback = this.getResultFeedback(((TransferResult)result.get()).getResult(), Text.of((Object[])new Object[]{"Deposited ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(amount), TextColors.DARK_GREEN, " to the town."}), (Text)Text.of((String)"You do not have enough to deposit."), (Text)Text.of((String)"Depositing failed."));
            this.townsMsg.info((MessageReceiver)player, new Object[]{feedback});
        }
    }

    public void withdrawFromTown(Player player, BigDecimal amount) throws TownsCommandException {
        this.checkEconomyEnabled();
        Town town = this.getPlayerTown(player);
        if (this.config.TOWN.LOCAL_TRANSACTIONS && !this.playerInsideTown(player, town)) {
            throw new TownsCommandException("You must be inside your town to deposit.");
        }
        Optional result = Economy.transferCurrency((String)town.getBank().toString(), (UUID)player.getUniqueId(), (Currency)this.config.DEFAULT_CURRENCY, (BigDecimal)amount, (Cause)Sponge.getCauseStackManager().getCurrentCause());
        if (result.isPresent()) {
            Text feedback = this.getResultFeedback(((TransferResult)result.get()).getResult(), Text.of((Object[])new Object[]{"Withdrew ", TextColors.GOLD, this.config.DEFAULT_CURRENCY.format(amount), TextColors.DARK_GREEN, " from the town."}), (Text)Text.of((String)"The town does not have enough to withdraw."), (Text)Text.of((String)"Withdrawing failed."));
            this.townsMsg.info((MessageReceiver)player, new Object[]{feedback});
        }
    }

    public void setPlayerTownSpawn(Player source) throws TownsCommandException {
        Town town = this.getPlayerTown(source);
        Optional<TownPlot> plot = this.plotService.getTownPlotByLocation((Location<World>)source.getLocation());
        if (!plot.isPresent()) {
            throw new TownsCommandException("Current location is not part of your town");
        }
        if (!plot.get().getTown().equals(town)) {
            throw new TownsCommandException("Current location is not part of your town");
        }
        this.townsMsg.info((MessageReceiver)source, new Object[]{"Town spawn set."});
        this.townService.setTownSpawn(town, (Transform<World>)source.getTransform());
    }

    private boolean playerInsideTown(Player player, Town town) {
        return this.plotService.getTownPlotByLocation((Location<World>)player.getLocation()).map(plot -> plot.getTown().equals(town)).orElse(false);
    }

    public Set<Player> getOnlineTownMembers(Town town) {
        Set townResidents = town.getResidents().stream().map(Resident::getId).collect(Collectors.toSet());
        return Sponge.getServer().getOnlinePlayers().stream().filter(player -> townResidents.contains(player.getUniqueId())).collect(Collectors.toSet());
    }

    public void sendTownInfo(Town town, MessageReceiver receiver) {
        Text.Builder townText = Text.builder();
        townText.append(new Text[]{this.townsMsg.createTownsHeader(town.getName())}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, town.getDescription(), Text.NEW_LINE})});
        townText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Nation: ", town.getNation() == null ? Text.of((Object[])new Object[]{TextColors.RED, "None"}) : this.nationFacade.renderNation(town.getNation()), Text.NEW_LINE})});
        townText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Leader: ", TextColors.GOLD, this.residentFacade.renderResident(town.getLeader()), Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Size: ", TextColors.GOLD, this.townService.getTownSize(town), "/", town.getMaxSize(), Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Board: ", TextColors.GOLD, town.getMotd(), Text.NEW_LINE})}).append(new Text[]{this.townsMsg.renderBank(town.getBank().toString()), Text.NEW_LINE}).append(new Text[]{this.taxFacade.renderTax(town)}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "PvP: ", this.townsMsg.renderBoolean(town.isPvpEnabled(), true), TextColors.DARK_GRAY, " | "})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Freely Joinable: ", this.townsMsg.renderBoolean(town.isFreelyJoinable(), true), Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Residents [", TextColors.GREEN, town.getResidents().size(), TextColors.DARK_GREEN, "]: ", TextColors.GOLD, this.residentFacade.renderResidents(town.getResidents())})});
        receiver.sendMessage(townText.build());
    }

    public Text renderTown(Town town) {
        if (town == null) {
            return Text.of((Object[])new Object[]{TextColors.GOLD, "No Town"});
        }
        return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, town.getName()})}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, town.getName(), Text.NEW_LINE, TextColors.DARK_GREEN, "Nation: ", this.nationFacade.renderNation(town.getNation()), Text.NEW_LINE, TextColors.DARK_GREEN, "Leader: ", TextColors.GOLD, town.getLeader().getName(), Text.NEW_LINE, TextColors.DARK_GREEN, "Residents: ", TextColors.GOLD, town.getResidents().size(), Text.NEW_LINE, TextColors.DARK_GRAY, "Click to view"}))).onClick((ClickAction)TextActions.executeCallback(source -> this.sendTownInfo(town, (MessageReceiver)source))).build();
    }

    public Text renderTowns(Collection<Town> towns) {
        Text.Builder townsText = Text.builder();
        int i = 0;
        for (Town town : towns) {
            townsText.append(new Text[]{Text.of((Object[])new Object[]{this.renderTown(town), ++i == towns.size() ? "" : ", "})});
        }
        return townsText.build();
    }

    public void onPlayerDamage(DamageEntityEvent event, Player attacker, Player target) {
        Optional<TownPlot> attackerPlot = this.plotService.getTownPlotByLocation((Location<World>)attacker.getLocation());
        Optional<TownPlot> targetPlot = this.plotService.getTownPlotByLocation((Location<World>)target.getLocation());
        if (!attackerPlot.isPresent() && !targetPlot.isPresent()) {
            return;
        }
        if (targetPlot.isPresent()) {
            event.setCancelled(!targetPlot.get().getTown().isPvpEnabled());
            return;
        }
        event.setCancelled(!attackerPlot.get().getTown().isPvpEnabled());
    }

    private void joinTownMessage(Player player, Town town) {
        this.townsMsg.broadcastTownInfo(town, player.getName(), " has joined the town");
    }

    private boolean isLeaderOfPlayerTown(Player player) {
        Resident resident = this.residentService.getOrCreate((User)player);
        if (resident.getTown() != null) {
            return resident.equals(resident.getTown().getLeader());
        }
        return false;
    }

    private boolean hasPlayerTown(Player player) {
        return this.residentFacade.getPlayerTown(player).isPresent();
    }

    public void payTownDebt(Player player) throws TownsCommandException {
        Town town = this.getPlayerTown(player);
        if (town.getDebt() == 0.0) {
            throw new TownsCommandException("You have no debt to pay!");
        }
        Account townBank = (Account)Economy.getAccount((String)town.getBank().toString()).get();
        double townBalance = townBank.getBalance(this.config.DEFAULT_CURRENCY).doubleValue();
        if (town.getDebt() > townBalance) {
            throw new TownsCommandException("Town bank does not have enough money to pay your debt!");
        }
        this.taxService.payTaxes(town, town.getDebt());
        this.taxService.setTaxesPaid(town, true);
        this.townsMsg.info((MessageReceiver)player, new Object[]{"Tax debt has been paid off! All town features have been re-enabled!"});
    }

    public void recalculateTownSizes() {
        if (!this.config.TOWN_SIZE_AUTOMATION.IS_ENABLED) {
            return;
        }
        this.townService.fetchAllTowns().forEach(this::recalculateTownSize);
    }

    private void recalculateTownSize(Town town) {
        int numberOfActiveResidents = (int)town.getResidents().stream().filter(resident -> this.residentFacade.isResidentActive((Resident)resident)).count();
        int newTownMaxArea = this.config.TOWN_SIZE_AUTOMATION.AREA_GRANTED_PER_ACTIVE_RESIDENT * numberOfActiveResidents;
        town.setMaxSize(newTownMaxArea);
    }

    public void setTownTaxable(Town town, boolean taxable) {
        this.townService.setTownTaxable(town, taxable);
    }
}

