/*
 * Decompiled with CFR 0.152.
 */
package com.atherys.towns.facade;

import com.atherys.core.economy.Economy;
import com.atherys.towns.AtherysTowns;
import com.atherys.towns.TownsConfig;
import com.atherys.towns.api.command.TownsCommandException;
import com.atherys.towns.facade.TownFacade;
import com.atherys.towns.facade.TownsMessagingFacade;
import com.atherys.towns.model.RaidPoint;
import com.atherys.towns.model.entity.Plot;
import com.atherys.towns.model.entity.Resident;
import com.atherys.towns.model.entity.Town;
import com.atherys.towns.service.PlotService;
import com.atherys.towns.service.ResidentService;
import com.atherys.towns.service.TownRaidService;
import com.atherys.towns.util.MathUtils;
import com.atherys.towns.util.Rectangle;
import com.flowpowered.math.vector.Vector3d;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.entity.AreaEffectCloud;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@Singleton
public class TownRaidFacade {
    @Inject
    TownsConfig config;
    @Inject
    TownFacade townFacade;
    @Inject
    TownsMessagingFacade townsMsg;
    @Inject
    TownRaidService townRaidService;
    @Inject
    ResidentService residentService;
    @Inject
    PlotService plotService;

    public boolean isEntityRaidPoint(Entity entity) {
        return this.townRaidService.isIdRaidEntity(entity.getUniqueId());
    }

    public void checkDistanceToTown(Town town, Vector3d targetPoint) throws TownsCommandException {
        boolean townInRange = false;
        for (Plot plot : town.getPlots()) {
            double plotDistance = MathUtils.getDistanceSquaredToRectangle(targetPoint, (Rectangle)plot);
            if (plotDistance < Math.pow(this.config.RAID.RAID_MIN_CREATION_DISTANCE, 2.0)) {
                throw new TownsCommandException("Target town is too close to current location!");
            }
            if (!(plotDistance < Math.pow(this.config.RAID.RAID_MAX_CREATION_DISTANCE, 2.0))) continue;
            townInRange = true;
        }
        if (!townInRange) {
            throw new TownsCommandException("Target town is too far away from current location!");
        }
    }

    public boolean isPlayerCloseToRaid(Transform<World> targetSpawn, Transform<World> spawnLocation) {
        return MathUtils.getDistanceBetweenPointsSquared(spawnLocation.getPosition(), targetSpawn.getPosition()) <= Math.pow(this.config.RAID.RAID_SPAWN_RADIUS, 2.0);
    }

    public void validateRaid(Town town, Transform<World> transform, Town targetTown) throws TownsCommandException {
        Optional townBank;
        Location location = transform.getLocation();
        if (AtherysTowns.economyIsEnabled() && (townBank = Economy.getAccount((String)town.getBank().toString())).isPresent() && ((Account)townBank.get()).getBalance(this.config.DEFAULT_CURRENCY).doubleValue() < this.config.RAID.RAID_COST) {
            throw new TownsCommandException("Your town bank does not have enough money to create a raid point!");
        }
        if (town.getNation() != null && targetTown.getNation() != null && !town.getNation().getEnemies().contains(targetTown.getNation())) {
            throw new TownsCommandException("Target town is not an enemy of your nation!");
        }
        if (this.townRaidService.isTownRaidActive(town)) {
            throw new TownsCommandException("Your town already has an active raid point!");
        }
        if (this.townRaidService.isLocationTaken((Location<World>)location)) {
            throw new TownsCommandException("This location is too close to another town's raid point!");
        }
        if (!this.townRaidService.hasCooldownPeriodPassed(town)) {
            throw new TownsCommandException("Raid Cooldown is still in effect!");
        }
        if (this.plotService.getTownPlotByLocation((Location<World>)location).isPresent()) {
            throw new TownsCommandException("You cannot create a raid point within the borders of a town!");
        }
        this.checkDistanceToTown(targetTown, transform.getPosition());
    }

    public AreaEffectCloud getEffectCloud(ParticleType type, double verticalAdjustment, Transform<World> transform) {
        AreaEffectCloud cloud = (AreaEffectCloud)((World)transform.getExtent()).createEntity(EntityTypes.AREA_EFFECT_CLOUD, transform.getPosition().add(0.0, verticalAdjustment, 0.0));
        cloud.offer(Keys.AREA_EFFECT_CLOUD_RADIUS, (Object)2.0);
        cloud.offer(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE, (Object)type);
        cloud.offer(Keys.AREA_EFFECT_CLOUD_DURATION, (Object)((int)this.config.RAID.RAID_DURATION.getSeconds() * 20));
        return cloud;
    }

    public Set<UUID> spawnPortalParticles(Transform<World> transform, Player player) {
        AreaEffectCloud cloud1 = this.getEffectCloud(ParticleTypes.CLOUD, -0.1, transform);
        AreaEffectCloud cloud2 = this.getEffectCloud(ParticleTypes.ENCHANTING_GLYPHS, 0.5, transform);
        player.getWorld().spawnEntity((Entity)cloud1);
        player.getWorld().spawnEntity((Entity)cloud2);
        return new HashSet<UUID>(Arrays.asList(cloud1.getUniqueId(), cloud2.getUniqueId()));
    }

    public UUID spawnRaidPoint(Transform<World> transform, Player player) {
        Entity entity = player.getWorld().createEntity(EntityTypes.HUMAN, transform.getPosition().add(0.0f, 1.0f, -2.0f));
        entity.offer(Keys.AI_ENABLED, (Object)false);
        entity.offer(Keys.DISPLAY_NAME, (Object)Text.of((String)"Hired Mage"));
        entity.offer(Keys.MAX_HEALTH, (Object)this.config.RAID.RAID_HEALTH);
        entity.offer(Keys.HEALTH, (Object)this.config.RAID.RAID_HEALTH);
        entity.offer(Keys.SKIN_UNIQUE_ID, (Object)UUID.fromString(this.config.RAID.RAID_SKIN_UUID));
        player.getWorld().spawnEntity(entity);
        return entity.getUniqueId();
    }

    private Text formatRaidLocation(Transform<World> transform) {
        Location location = transform.getLocation();
        return Text.of((Object[])new Object[]{TextColors.GOLD, "x: ", location.getBlockX(), ", y: ", location.getBlockY(), ", z: ", location.getBlockZ()});
    }

    public Text formatDurationLeft(LocalDateTime time, Duration duration) {
        Duration durationLeft = duration.minus(Duration.between(time, LocalDateTime.now()));
        if (durationLeft.toMinutes() >= 1L) {
            return Text.of((Object[])new Object[]{TextColors.GOLD, durationLeft.toMinutes(), " minute(s)"});
        }
        return Text.of((Object[])new Object[]{TextColors.GOLD, durationLeft.getSeconds(), " second(s)"});
    }

    public void sendRaidPointInfo(Player player) throws TownsCommandException {
        Town town = this.townFacade.getPlayerTown(player);
        boolean raidExists = this.townRaidService.isTownRaidActive(town);
        Optional<RaidPoint> point = this.townRaidService.getTownRaidPoint(town);
        Text status = raidExists ? Text.of((Object[])new Object[]{TextColors.GREEN, "True"}) : Text.of((Object[])new Object[]{TextColors.RED, "False"});
        Text pointLocation = raidExists ? this.formatRaidLocation(point.get().getPointTransform()) : Text.of((Object[])new Object[]{TextColors.RED, "No Raid in Progress"});
        Text pointHealth = raidExists ? Text.of((Object[])new Object[]{TextColors.GOLD, this.townRaidService.getRaidHealth(player.getWorld(), point.get())}) : Text.of((Object[])new Object[]{TextColors.RED, "No Raid in Progress"});
        Text durationLeft = raidExists ? this.formatDurationLeft(point.get().getCreationTime(), this.config.RAID.RAID_DURATION) : Text.of((Object[])new Object[]{TextColors.RED, "No Raid in Progress"});
        Text cooldown = this.townRaidService.hasCooldownPeriodPassed(town) ? Text.of((Object[])new Object[]{TextColors.GREEN, "No Cooldown Remaining"}) : this.formatDurationLeft(town.getLastRaidCreationDate().get(), this.config.RAID.RAID_COOLDOWN);
        Text.Builder raidText = Text.builder();
        raidText.append(new Text[]{this.townsMsg.createTownsHeader("Raid Point")});
        raidText.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Raid in Progress: ", status, Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Raid Location: ", pointLocation, Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Point Health: ", pointHealth, Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Duration Left: ", durationLeft, Text.NEW_LINE})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Cooldown: ", cooldown})});
        player.sendMessage(raidText.build());
    }

    public Transform<World> getRaidPointTransform(Player player) {
        Vector3d playerVector = player.getTransform().getPosition();
        Location highLocation = player.getLocation().asHighestLocation();
        Location newLocation = new Location((Extent)player.getWorld(), playerVector.getX(), (double)highLocation.getBlockY(), playerVector.getZ());
        return player.getTransform().setLocation(newLocation);
    }

    public void createRaidPoint(Player player, Town targetTown) throws TownsCommandException {
        Town town = this.townFacade.getPlayerTown(player);
        Transform<World> transform = this.getRaidPointTransform(player);
        this.validateRaid(town, transform, targetTown);
        UUID entityId = this.spawnRaidPoint(transform, player);
        Set<UUID> particleEffects = this.spawnPortalParticles(transform, player);
        if (AtherysTowns.economyIsEnabled()) {
            Economy.getAccount((String)town.getBank().toString()).ifPresent(account -> {
                Cause cause = Sponge.getCauseStackManager().getCurrentCause();
                account.withdraw(this.config.DEFAULT_CURRENCY, BigDecimal.valueOf(this.config.RAID.RAID_COST), cause);
                this.townsMsg.info((MessageReceiver)player, new Object[]{Text.of((Object[])new Object[]{"You've paid ", this.config.RAID.RAID_COST, " from the town bank to hire a mage!"})});
            });
        }
        this.townRaidService.createRaidPointEntry(transform, town, targetTown, entityId, particleEffects);
        this.townFacade.getOnlineTownMembers(town).forEach(member -> this.townsMsg.info((MessageReceiver)member, new Object[]{"A mage has been deployed to assist you with your raid!"}));
    }

    public void removeRaidPoint(Player player) throws TownsCommandException {
        Resident resident = this.residentService.getOrCreate((User)player);
        if (!this.townRaidService.isTownRaidActive(resident.getTown())) {
            throw new TownsCommandException("You do not have a town raid currently active!");
        }
        Optional<RaidPoint> raidPoint = this.townRaidService.getTownRaidPoint(resident.getTown());
        raidPoint.ifPresent(point -> this.townRaidService.removeRaidPoint(point.getRaidPointUUID()));
        this.townFacade.getOnlineTownMembers(resident.getTown()).forEach(member -> this.townsMsg.info((MessageReceiver)member, new Object[]{"Your mage has been relieved of duty!"}));
    }

    public void onRaidPointDeath(DestructEntityEvent.Death event) {
        UUID raidPointUUID = event.getTargetEntity().getUniqueId();
        RaidPoint point = this.townRaidService.getRaidPoint(raidPointUUID);
        this.townFacade.getOnlineTownMembers(point.getRaidingTown()).forEach(member -> this.townsMsg.info((MessageReceiver)member, new Object[]{"Your mage has been killed!"}));
        this.townRaidService.removeRaidPoint(raidPointUUID);
    }

    public boolean onPlayerSpawn(RespawnPlayerEvent event) {
        Optional<RaidPoint> point;
        Town town = this.residentService.getOrCreate((User)event.getOriginalPlayer()).getTown();
        if (this.townRaidService.isTownRaidActive(town) && (point = this.townRaidService.getTownRaidPoint(town)).isPresent() && this.isPlayerCloseToRaid((Transform<World>)event.getFromTransform(), point.get().getPointTransform())) {
            event.setToTransform(point.get().getPointTransform());
            event.getOriginalPlayer().getWorld().getEntity(point.get().getRaidPointUUID()).ifPresent(entity -> {
                double initialHealth = entity.get(Keys.HEALTH).orElse(0.0);
                entity.offer(Keys.HEALTH, (Object)(initialHealth - (double)this.config.RAID.RAID_DAMAGE_PER_SPAWN));
            });
            return true;
        }
        return false;
    }
}

